/**
    NVT evb board file
    To handle na51xxx basic init.
    @file       na51xxxevb.c
    @ingroup
    @note
    Copyright   Novatek Microelectronics Corp. 2022.  All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as
    published by the Free Software Foundation.
*/


#include <common.h>
#include <cli.h>
#include <command.h>
#include <linux/delay.h>
#include <env.h>
#include <asm/io.h>
#include <asm/mach-types.h>
#include <asm/armv8/mmu.h>
#include <asm/nvt-common/nvt_common.h>
#include <asm/nvt-common/rcw_macro.h>
#include <asm/arch/IOAddress.h>
#include <asm/arch/na51102evb.h>
#include <linux/libfdt.h>
#include <fdt_support.h>
#include <pwm.h>

DECLARE_GLOBAL_DATA_PTR;
extern int nvt_mmc_init(int id);
extern int na51102_eth_initialize(struct bd_info *bis);
const char *boardinfo[] = {
	"Board:"_CHIP_NAME_"EVB\n"
};

#ifdef AB_MODIFIED
#ifdef CONFIG_FW_MULTI_PARTITION_ENABLE
extern bool b_load_ab_boot;
#endif
#endif

static struct mm_region na51102_a64_evb_mem_map[] = {
	{
	    .virt = 0x0UL,
		.phys = 0x0UL,
		.size = 0x80000000UL,
		.attrs = PTE_BLOCK_MEMTYPE(MT_NORMAL) |
			 PTE_BLOCK_INNER_SHARE
	}, {
	    .virt = 0xf0000000UL,
		.phys = 0xf0000000UL,
		.size = 0x10000000UL,
		.attrs = PTE_BLOCK_MEMTYPE(MT_DEVICE_NGNRNE) |
			 PTE_BLOCK_NON_SHARE
			 /* TODO: Do we need these? */
			 /* | PTE_BLOCK_PXN | PTE_BLOCK_UXN */

	}, {
	    .virt = 0x2f0000000UL, /* For 0x2F000_0000 peri io */
		.phys = 0x2f0000000UL,
		.size = 0x10000000UL,
		.attrs = PTE_BLOCK_MEMTYPE(MT_DEVICE_NGNRNE) |
			 PTE_BLOCK_NON_SHARE
			 /* TODO: Do we need these? */
			 /* | PTE_BLOCK_PXN | PTE_BLOCK_UXN */

	}, {
	    .virt = 0x400000000UL, /* For 0x4_0000_0000 pcie space  */
		.phys = 0x400000000UL,
		.size = 0x1000000000UL,
		.attrs = PTE_BLOCK_MEMTYPE(MT_DEVICE_NGNRNE) |
			 PTE_BLOCK_NON_SHARE
			 /* TODO: Do we need these? */
			 /* | PTE_BLOCK_PXN | PTE_BLOCK_UXN */

	}, {

		/* List terminator */
		0,
	}
};

struct mm_region *mem_map = na51102_a64_evb_mem_map;

int dram_init_banksize(void)
{
	/* Set Dram bank to physical memory range for booti relocation */
	gd->bd->bi_dram[0].start = nvt_memory_cfg[MEMTYPE_DRAM].addr;
	gd->bd->bi_dram[0].size = nvt_memory_cfg[MEMTYPE_DRAM].size;

	return 0;
}

#ifdef AB_MODIFIED

#ifdef CONFIG_AB_UPGRADE_LED_SINGLE
extern void gpio_set_output(u32 pin);
extern void gpio_set_pin(u32 pin);
extern void gpio_clear_pin(u32 pin);

static inline void ab_gpio_set_pin(u32 pin, bool status)
{
	if (status) 	gpio_set_pin(pin); 	 // 1
	else        	gpio_clear_pin(pin); // 0
}

static void ab_get_fwup_led_info(uint32_t* led_pin,bool* active)
{
	uint32_t *cell = NULL;
	ulong fdt_addr = nvt_readl((ulong)nvt_shminfo_boot_fdt_addr);
	int nodeoffset = fdt_path_offset((const void*)fdt_addr, "/ab_uboot_fwup_led");
	if (nodeoffset >= 0) {

		cell = (uint32_t*)fdt_getprop((const void*)fdt_addr, nodeoffset, "fwup_status_led_pin", NULL);
		if (cell > 0) {
			*led_pin= be32_to_cpu(cell[0]);
			printf("Get fwup_status_led_pin = %d\n",*led_pin);
		}
		else
		{
			ab_err_print("Get fwup_status_led_pin fail\n");
		}
		
		cell = (uint32_t*)fdt_getprop((const void*)fdt_addr, nodeoffset, "led_active_status", NULL);
		if (cell > 0) {
			*active= be32_to_cpu(cell[0]);
			printf("Get led_active_status = %d\n",*active);
		}
		else
		{
			ab_err_print("Get led_active_status fail\n");
		}
		
	}
	else
	{
		ab_err_print("get nodeoffset of ab_uboot_fwup_led fail.\n");
	}
}

static void ab_fwup_led_ctrl(uint32_t led_pin,bool active,int fwup_ret)
{
	uint8_t ui_cnt=0;
	
	switch(fwup_ret)
	{
		case ERR_NVT_UPDATE_FAILED:
			gpio_set_output(led_pin);
			while(1)
			{
				ui_cnt = 1;
				while(ui_cnt--)
				{
					ab_gpio_set_pin(led_pin,active);
					mdelay(200);
					ab_gpio_set_pin(led_pin,!active);
					mdelay(200);
				}
				mdelay(1000);
			}
			break;
		case ERR_NVT_UPDATE_OPENFAILED:// no sd card case
		case ERR_NVT_UPDATE_READ_FAILED:
			gpio_set_output(led_pin);
			while(1)
			{
				ui_cnt = 2;
				while(ui_cnt--)
				{
					ab_gpio_set_pin(led_pin,active);
					mdelay(200);
					ab_gpio_set_pin(led_pin,!active);
					mdelay(200);
				}
				mdelay(1000);
			}
			break;
		case ERR_NVT_UPDATE_NO_NEED:
			/*Do nothing*/
			break;
		default:
			break;
	}
}

#define AB_FWUP_LED_TOGGLE_TIME 200000//us
bool b_is_ab_fwup=0;
uint32_t ui_ab_fwup_led_pin=0;
bool b_ab_fwup_led_active_status=0;
unsigned long ul_fwup_led_last_toggle_time=0;
bool b_ab_fwup_led_state=0;

void ab_fwup_led_toggle(void)
{
	if( b_is_ab_fwup && (get_nvt_timer0_cnt() - ul_fwup_led_last_toggle_time >= AB_FWUP_LED_TOGGLE_TIME) )
	{//ab_err_print("toggle %d %d\n",get_nvt_timer0_cnt() - ul_fwup_led_last_toggle_time, b_ab_fwup_led_state);
		ul_fwup_led_last_toggle_time = get_nvt_timer0_cnt();
		b_ab_fwup_led_state ^= 1;
		ab_gpio_set_pin( ui_ab_fwup_led_pin, b_ab_fwup_led_state);
	}
}

void ab_fwup_led_toggle_init(void)
{//ab_err_print("init toggle %d %d\n",get_nvt_timer0_cnt() - ul_fwup_led_last_toggle_time, b_ab_fwup_led_state);
	b_is_ab_fwup = 1;

	ab_get_fwup_led_info(&ui_ab_fwup_led_pin, &b_ab_fwup_led_active_status);
	gpio_set_output(ui_ab_fwup_led_pin);
	ab_gpio_set_pin(ui_ab_fwup_led_pin, b_ab_fwup_led_active_status);
	b_ab_fwup_led_state = b_ab_fwup_led_active_status;
}

void ab_fwup_led_toggle_deinit(void)
{//ab_err_print("deinit toggle %d %d\n",get_nvt_timer0_cnt() - ul_fwup_led_last_toggle_time, b_ab_fwup_led_state);
	if(b_is_ab_fwup == 1)
	{
		b_is_ab_fwup = 0;

		ab_gpio_set_pin(ui_ab_fwup_led_pin, !b_ab_fwup_led_active_status);
		b_ab_fwup_led_state = !b_ab_fwup_led_active_status;
	}
}

bool is_ab_fwup_led_toggle_processing(void)
{
	return b_is_ab_fwup;
}
#endif

#endif

void reset_cpu()
{
	nvt_ivot_reset_cpu();
}


/**
 * @brief board_early_init_f
 *
 * @return 0
 */
#ifdef CONFIG_BOARD_EARLY_INIT_F
int board_early_init_f(void)
{
	return 0;
}
#endif

#ifdef CONFIG_BOARD_EARLY_INIT_R
int board_early_init_r(void)
{

	return 0;
}
#endif

/**
 * @brief board_init
 *
 * @return 0
 */
int board_init(void)
{
	int ret = 0;
#ifndef CONFIG_ARMV8_SET_SMPEN
	unsigned long  cval = 0;
#endif

#ifdef CONFIG_NVT_IVOT_BOOT_FAST
	char command[100] = {0};
	sprintf(command, "nvt_uart_disable");
	ret = run_command(command, 0);
#endif
	nvt_tm0_cnt_beg = get_nvt_timer0_cnt();

	printf("Relocation to 0x%08lx, Offset is 0x%08lx sp at %08lx\n", gd->relocaddr, gd->reloc_off, gd->start_addr_sp);

	icache_disable();
	dcache_disable();

	invalidate_icache_all();
	invalidate_dcache_all();

	icache_enable();
	dcache_enable();

	nvt_shminfo_init();
	ret = nvt_fdt_init(false);
	if (ret < 0) {
		printf("fdt init fail\n");
	}

#ifdef CONFIG_ARMV8_MULTIENTRY
	/* Loader will use the register value as a pc address
	then slave core will jump to the address when register value is not equal to zero */
	nvt_writel(nvt_memory_cfg[MEMTYPE_UBOOT].addr + gd->reloc_off, LOADER_CPU_RELEASE_ADDR);
#endif

	ret = nvt_board_init_early();
	if (ret < 0) {
		printf("board init early fail\n");
		return 0;
	}

	return 0;
}

int board_mmc_init(struct bd_info *bis)
{
	int ret = 0;
#ifdef CONFIG_NVT_MMC
	int i;
	int CONFIG_NVT_MMC_CHANNEL = 0;

#ifdef CONFIG_NVT_MMC_CHANNEL_SDIO1
	CONFIG_NVT_MMC_CHANNEL |= 1 << 0;
#endif

#ifdef CONFIG_NVT_MMC_CHANNEL_SDIO2
	CONFIG_NVT_MMC_CHANNEL |= 1 << 1;
#endif

#ifdef CONFIG_NVT_MMC_CHANNEL_SDIO3
	CONFIG_NVT_MMC_CHANNEL |= 1 << 2;
#endif

	for (i = 0; i < CONFIG_NVT_MMC_MAX_NUM; i++) {
		if((CONFIG_NVT_MMC_CHANNEL >> i) & 0x1) {
			ret = nvt_mmc_init(i);
			if(ret)
				break;
		}
	}
#endif
	return ret;
}

int board_eth_init(struct bd_info *bis)
{
	int rc = 0;

#ifdef CFG_ETHNET
	rc = na51102_eth_initialize(bis);
#endif

	return rc;
}

#ifdef CONFIG_NVT_IVOT_SOC_FW_UPDATE_SUPPORT
static int nvt_handle_fw_abin(void)
{
	int ret = 0;
	char cmdline[1024] = {0};
	char command[1024] = {0};
	char buf[1024] = {0};

	/* To handle firmware update */
	ret = nvt_fw_update(false);
	#ifdef AB_MODIFIED
	#ifdef CONFIG_FW_MULTI_PARTITION_ENABLE
	// a/b partition modify
	printf("[%s] Ability nvt_fw_update ret: %d\n",__func__,ret);
	u32 nand_addr = 0,nand_size = 0, nand_block_size = 0;
	int nodeoffset, len;
    u32 *pui_cell = NULL;
    char * pc_string_blk_size = NULL;
    /* get fdt info*/
    ulong fdt_addr = nvt_readl((ulong)nvt_shminfo_boot_fdt_addr);
	#ifdef CONFIG_NVT_LINUX_SPINAND_BOOT
    nodeoffset = fdt_path_offset((const void*)fdt_addr, "/nand/partition_ab_boot");
	#elif defined(CONFIG_NVT_LINUX_EMMC_BOOT)
	nodeoffset = fdt_path_offset((const void*)fdt_addr, "mmc2/partition_ab_boot");
	#endif
    if (nodeoffset < 0) {
        ab_err_print("%s(%d) nodeoffset < 0\n",__func__, __LINE__);
        return false;
    }
	
	pui_cell = (u32 *)fdt_getprop((const void*)fdt_addr, nodeoffset, "reg", &len);
    if (len == 0) {
        ab_err_print("%s(%d) len = 0\n",__func__, __LINE__);
        return false;
    }

    nand_addr = __be32_to_cpu(pui_cell[1]);
    nand_size = __be32_to_cpu(pui_cell[3]);
    printf("[%s] nand_addr: 0x%x, nand_size: 0x%x\n",__func__,nand_addr,nand_size);

    nodeoffset = fdt_path_offset((const void*)fdt_addr, "/nvt_info");
    if (nodeoffset < 0) {
        ab_err_print("%s(%d) nodeoffset < 0\n",__func__, __LINE__);
        return false;
    }

    pc_string_blk_size = (u32 *)fdt_getprop((const void*)fdt_addr, nodeoffset, "EMBMEM_BLK_SIZE", &len);
    if (len == 0) {
        ab_err_print("%s(%d) len = 0\n",__func__, __LINE__);
        return false;
    }
    printf("[%s] len: %d, pc_string_blk_size: %s\n",__func__,len,pc_string_blk_size);
    nand_block_size = simple_strtoul(pc_string_blk_size, NULL, 16);

    int boot_ret = 0;
	if(ret == 0){
        #ifdef CONFIG_NVT_LINUX_SPINAND_BOOT
        boot_ret = ab_reset_bootup_config(nand_addr,nand_size,nand_block_size);
        #elif defined(CONFIG_NVT_LINUX_EMMC_BOOT)
        boot_ret = ab_emmc_reset_bootup_config(nand_addr,nand_size,nand_block_size);
        #endif
        if(boot_ret<0)
            ab_err_print("reset boot config fail.\n");
    }
    else{
        #ifdef CONFIG_NVT_LINUX_SPINAND_BOOT
        if(ab_load_bootup_config(nand_addr,nand_size,nand_block_size) == 0)
            b_load_ab_boot = true;
        else
        {
            boot_ret = ab_reset_bootup_config(nand_addr,nand_size,nand_block_size);
            if(boot_ret<0)
                ab_err_print("reset boot config fail.\n");
        }
        #elif defined(CONFIG_NVT_LINUX_EMMC_BOOT)
        if(ab_emmc_load_bootup_config(nand_addr,nand_size,nand_block_size) == 0)
            b_load_ab_boot = true;
        else
        {
            boot_ret = ab_emmc_reset_bootup_config(nand_addr,nand_size,nand_block_size);
            if(boot_ret<0)
                ab_err_print("reset boot config fail.\n");
        }
        #endif
    }
	#endif
    #endif
	if (ret < 0) {
		#if defined AB_MODIFIED && defined CONFIG_AB_UPGRADE_LED_SINGLE
		uint32_t led1_pin=0;
		bool led1_active = TRUE;
		ab_get_fwup_led_info(&led1_pin,&led1_active);
		#endif
		switch (ret) {
		case ERR_NVT_UPDATE_FAILED:
			#if defined AB_MODIFIED && defined CONFIG_AB_UPGRADE_LED_SINGLE
			sprintf(command, "abpwm disable");
			run_command(command, 0);
			ab_fwup_led_ctrl(led1_pin,led1_active,ERR_NVT_UPDATE_FAILED);
			#endif
			printf("%sUpdate fail %s\r\n", ANSI_COLOR_RED, ANSI_COLOR_RESET);
			return -1;
			break;
		case ERR_NVT_UPDATE_OPENFAILED:
			#if defined AB_MODIFIED && defined CONFIG_AB_UPGRADE_LED_SINGLE
			sprintf(command, "abpwm disable");
			run_command(command, 0);
			if( is_ab_fwup_led_toggle_processing() )
			{//Open SD fail will also occur in normal boot.
				ab_fwup_led_ctrl(led1_pin,led1_active,ERR_NVT_UPDATE_OPENFAILED);
			}
			#endif
			printf("Open SD fail:%s No SD device? %s\r\n", ANSI_COLOR_YELLOW, ANSI_COLOR_RESET);
			break;
		case ERR_NVT_UPDATE_READ_FAILED:
			#if defined AB_MODIFIED && defined CONFIG_AB_UPGRADE_LED_SINGLE
			sprintf(command, "abpwm disable");
			run_command(command, 0);
			ab_fwup_led_ctrl(led1_pin,led1_active,ERR_NVT_UPDATE_READ_FAILED);
			#endif
			printf("%sRead SD fail %s\r\n", ANSI_COLOR_RED, ANSI_COLOR_RESET);
			return -1;
			break;
		case ERR_NVT_UPDATE_NO_NEED:
			printf("%sNo need to update (%s) %s\r\n", ANSI_COLOR_YELLOW, get_nvt_bin_name(NVT_BIN_NAME_TYPE_FW), ANSI_COLOR_RESET);
			break;
		default:
			break;
		}
		ret = nvt_fdt_init(true);
		if (ret < 0) {
			printf("modelext init fail\n");
		}
	} else{
		printf("%sUpdate successfully %s\r\n", ANSI_COLOR_YELLOW, ANSI_COLOR_RESET);
	}
	#if defined AB_MODIFIED && defined CONFIG_AB_UPGRADE_LED_SINGLE
	sprintf(command, "abpwm disable");
	run_command(command, 0);
	ab_fwup_led_toggle_deinit();
	#endif

	/*
	 * To handle bootargs expanding for the kernel /proc/cmdline and uboot mtdids env setting
	 */
	sprintf(buf,"%s ",env_get("bootargs"));
	strcat(cmdline, buf);
	ret = nvt_part_config((char *)cmdline, NULL);
	if (ret < 0)
		return ret;

	env_set("bootargs",cmdline);

	return 0;
}
#endif

#ifdef CONFIG_NVT_IVOT_SOC_FW_UPDATE_SUPPORT
static int nvt_handle_fw_tbin(void)
{
	int ret = 0;
	char cmdline[1024] = {0};
	char buf[1024] = {0};

	ret = nvt_fw_load_tbin();
	if (ret < 0) {
		switch (ret) {
		case ERR_NVT_UPDATE_OPENFAILED:
			printf("Open SD fail:%s No SD device? (%s) %s\r\n", ANSI_COLOR_YELLOW, get_nvt_bin_name(NVT_BIN_NAME_TYPE_RUNFW), ANSI_COLOR_RESET);
			break;
		case ERR_NVT_UPDATE_NO_NEED:
		case ERR_NVT_UPDATE_READ_FAILED:
			printf("%sRead SD fail (%s) %s\r\n", ANSI_COLOR_RED, get_nvt_bin_name(NVT_BIN_NAME_TYPE_RUNFW), ANSI_COLOR_RESET);
			return -1;
			break;
		default:
			break;
		}
	} else
		printf("%sLoad successfully %s\r\n", ANSI_COLOR_YELLOW, ANSI_COLOR_RESET);

	ret = nvt_fdt_init(false);
	if (ret < 0) {
		printf("modelext init fail\n");
		return ret;
	}

	/*
	 * To handle bootargs expanding for the kernel /proc/cmdline and uboot mtdids env setting
	 */
	sprintf(buf,"%s ",env_get("bootargs"));
	strcat(cmdline, buf);
	ret = nvt_part_config((char *)cmdline, NULL);
	if (ret < 0)
		return ret;

	env_set("bootargs",cmdline);

	return 0;
}
#endif

#ifdef CONFIG_NVT_IVOT_SOC_FW_UPDATE_SUPPORT
static int nvt_handle_update_fw_by_usb_eth(void)
{
	int ret = 0;
	char cmdline[1024] = {0};
	char command[128] = {0};
	char buf[1024] = {0};

	printf("%sStarting to update firmware from USB/ETH%s\r\n", ANSI_COLOR_YELLOW, ANSI_COLOR_RESET);
	/* To handle firmware update */
	ret = nvt_fw_update(true);
	if (ret < 0) {
		#if defined AB_MODIFIED && defined CONFIG_AB_UPGRADE_LED_SINGLE
		uint32_t led1_pin=0;
		bool led1_active = TRUE;
		ab_get_fwup_led_info(&led1_pin,&led1_active);
		sprintf(command, "abpwm disable");
		run_command(command, 0);
		#endif
		printf("%sUpdate fail %s\r\n", ANSI_COLOR_RED, ANSI_COLOR_RESET);
		#if defined AB_MODIFIED && defined CONFIG_AB_UPGRADE_LED_SINGLE
		ab_fwup_led_ctrl(led1_pin,led1_active,ERR_NVT_UPDATE_FAILED);
		#endif
		return -1;
	} else {
		printf("%sUpdate firmware successfully %s\r\n", ANSI_COLOR_YELLOW, ANSI_COLOR_RESET);
	}

	/*
	 * To handle bootargs expanding for the kernel /proc/cmdline and uboot mtdids env setting
	 * Continue to boot
	 */
	sprintf(buf,"%s ",env_get("bootargs"));
	strcat(cmdline, buf);
	ret = nvt_part_config((char *)cmdline, NULL);
	if (ret < 0)
		return ret;

	env_set("bootargs",cmdline);
	return 0;
}
#endif

#ifdef CONFIG_NVT_IVOT_SOC_FW_UPDATE_SUPPORT
static int nvt_handle_recovery_sys(void)
{
	int ret = 0;
	char cmdline[1024] = {0};
	char buf[1024] = {0};
	ret = nvt_process_sys_recovery();

	/*
	 * To handle bootargs expanding for the kernel /proc/cmdline and uboot mtdids env setting
	 */
	sprintf(buf,"%s ",env_get("bootargs"));
	strcat(cmdline, buf);
	ret = nvt_part_config((char *)cmdline, NULL);
	if (ret < 0)
		return ret;

	env_set("bootargs",cmdline);

	return ret;
}
#endif

#ifdef CONFIG_NVT_IVOT_SOC_FW_UPDATE_SUPPORT
static int nvt_handle_fw_auto(void)
{
	int ret = 0;
	unsigned long boot_reason = nvt_readl((ulong)nvt_shminfo_comm_uboot_boot_func) & COMM_UBOOT_BOOT_FUNC_BOOT_REASON_MASK;

	if ((boot_reason == COMM_UBOOT_BOOT_FUNC_BOOT_UPD_FRM_USB) || \
				(boot_reason == COMM_UBOOT_BOOT_FUNC_BOOT_UPD_FRM_ETH)){
		// Update by USB/ETH: firmware hsa been loaded by loader.
		ret = nvt_handle_update_fw_by_usb_eth();
		if (ret < 0)
			return ret;
	} else if (nvt_detect_fw_tbin()) {
		ret = nvt_handle_fw_tbin();
		if (ret < 0)
			return ret;
	} else if (boot_reason == COMM_UBOOT_BOOT_FUNC_BOOT_FORMAT_ROOTFS){
		printf("%s: COMM_UBOOT_BOOT_FUNC_BOOT_FORMAT_ROOTFS is not supported\n", __func__);
		return -1;
	} else if (boot_reason == COMM_UBOOT_BOOT_FUNC_BOOT_RECOVERY_SYS){
		// Recovery system if loader send event to do system recovery. (EMMC boot only)
		ret = nvt_handle_recovery_sys();
		if (ret < 0)
			return ret;
	} else {
		ret = nvt_handle_fw_abin();
		if (ret < 0)
			return ret;
	}
	#if defined AB_MODIFIED && defined CONFIG_AB_UPGRADE_LED_SINGLE
	ab_fwup_led_toggle_deinit();
	#endif

	return 0;
}
#endif

#if defined(CONFIG_NVT_IVOT_EMMC)
static int nvt_emmc_set_bootbus(void)
{
	int ret = 0;
	char command[128] = {0};
	int bus_width;
	int  nodeoffset;
	u32 *val = NULL;
	char path[20] = {0};

	sprintf(path,"mmc%d", CONFIG_NVT_IVOT_EMMC);
	nodeoffset = fdt_path_offset((void *)nvt_fdt_buffer, path);
	if (nodeoffset <= 0) {
		nvt_dbg(ERR, "can not find [%s] on device tree\n", path);
		return -1;
	}

	val = (u32 *)fdt_getprop((const void *)nvt_fdt_buffer, nodeoffset, "bus-width", NULL);
	if (val == NULL) {
		nvt_dbg(ERR, "can not find [bus-width] on device tree\n");
		return -1;
	}

	bus_width = fdt_read_number(val, 1);

	if (bus_width == 8) {
		bus_width = 2; // 8 bit
		nvt_dbg(MSG, "Set EMMC boot bus to 8-bit mode\n");
	} else {
		bus_width = 1; // 4 bit
		nvt_dbg(MSG, "Set EMMC boot bus to 4-bit mode\n");
	}
	sprintf(command, "mmc bootbus %d %d 0 0", CONFIG_NVT_IVOT_EMMC, bus_width);
	ret = run_command(command, 0);
	if (ret < 0){
		nvt_dbg(ERR, "command : [%s] failed\n", command);
	}
	return ret;
}

static int nvt_emmc_init(void)
{
	int ret = 0;
	char command[128] = {0};

	/* Switch to emmc bus and user partition access config */
	sprintf(command, "mmc dev %d", CONFIG_NVT_IVOT_EMMC);
	ret = run_command(command, 0);
	if (ret < 0)
		return ret;

	ret = nvt_emmc_set_bootbus();
	if (ret < 0)
		return ret;

	sprintf(command, "mmc partconf %d 1 1 0", CONFIG_NVT_IVOT_EMMC);
	ret = run_command(command, 0);
	return ret;
}
#elif defined(CONFIG_NVT_SPI_NOR)
static int nvt_norflash_init(void)
{
	int ret = 0;
	char command[128] = {0};

	sprintf(command, "sf probe");
	ret = run_command(command, 0);
	if (ret < 0) {
		nvt_dbg(ERR, "nor flash init failed\n");
	}

	return ret;
}
#endif /* CONFIG_NVT_LINUX_EMMC_BOOT */
/**
 * @brief misc_init_r - To do nvt update and board init.
 *
 * @return 0
 */
int misc_init_r(void)
{
	/* if part of misc_init_r failed, print msg and go to boot shell cli_loop() */
	int ret = 0;

#ifdef CONFIG_NVT_IVOT_SOC_FW_UPDATE_SUPPORT
	nvt_dbg(FUNC, "%sFirmware name: %s %s %s %s \n", ANSI_COLOR_YELLOW,
						  get_nvt_bin_name(NVT_BIN_NAME_TYPE_FW),
						  get_nvt_bin_name(NVT_BIN_NAME_TYPE_RUNFW),
						  get_nvt_bin_name(NVT_BIN_NAME_TYPE_MODELEXT),
						  ANSI_COLOR_RESET);
	nvt_dbg(FUNC, "boot time: %lu(us) \n", get_nvt_timer0_cnt());
#endif /* CONFIG_NVT_IVOT_SOC_FW_UPDATE_SUPPORT */

#if defined(CONFIG_NVT_IVOT_EMMC)
	ret = nvt_emmc_init();
	if (ret < 0) {
		printf("nvt_emmc_init fail\n");
		cli_loop();
		return 0;
	}
#elif defined(CONFIG_NVT_SPI_NOR)
	ret = nvt_norflash_init();
	if (ret < 0) {
		printf("nvt_norflash_init fail\n");
		cli_loop();
		return 0;
	}
#endif /* CONFIG_NVT_LINUX_EMMC_BOOT */

#ifdef CONFIG_NVT_IVOT_SOC_FW_UPDATE_SUPPORT
	ret = nvt_handle_fw_auto();
	if (ret < 0) {
		printf("nvt_handle_fw_auto fail\n");
		cli_loop();
	}
#endif

	/* Why to do this again?
	 * This is because modelext maybe updated, we should init again here.
	 */
	nvt_dbg(FUNC, "boot time: %lu(us) \n", get_nvt_timer0_cnt());
	ret = nvt_board_init();
	if (ret < 0) {
		printf("board init fail\n");
		cli_loop();
		return 0;
	}

	nvt_dbg(FUNC, "boot time: %lu(us) \n", get_nvt_timer0_cnt());

	return 0;
}

/*
 * dram init.
 */

int dram_init(void)
{
	nvt_get_memory_by_dts(gd->fdt_blob);
	nvt_print_dram_setting();
	return 0;
}

ulong board_get_usable_ram_top(ulong total_size)
{
	/* Set relocate address to the top of uboot memory */
	return nvt_memory_cfg[MEMTYPE_UBOOT].addr + nvt_memory_cfg[MEMTYPE_UBOOT].size;
}

/*
 * get_board_rev() - get board revision
 */
u32 get_board_rev(void)
{
	return 0;
}

int board_late_init(void)
{
	return 0;
}


