#
# Include related setting
#

include $(NVT_PRJCFG_MODEL_CFG)

C_DEFINE_EXT = -D_BOARD_FDT_ADDR_=$(BOARD_FDT_ADDR) \
				-D_BIN_NAME_='"$(BIN_NAME)"' \
				-D_BIN_NAME_T_='"$(BIN_NAME_T)"' \
				-D_CHIP_$(CHIP)_ \
				-D_CHIP_NAME_='"NT$(CHIP)"' \
				-D_$(EMBMEM)_ \
				-D_EMBMEM_BLK_SIZE_=$(EMBMEM_BLK_SIZE) \
				-D_$(NVT_ROOTFS_TYPE)_ \
				-D_$(NVT_LINUX_SMP)_ \
				-D_$(NVT_UBOOT_ENV_IN_STORG_SUPPORT)_ \
				-D_$(ENCRYPT_ATF)_ \
				-D_$(ENCRYPT_DTS)_ \
				-D_$(ENCRYPT_UBOOT)_ \
				-D_$(ENCRYPT_KERNEL)_ \
				-D_$(ENCRYPT_RTOS)_ \
				-D_$(ENCRYPT_OPTEE)_ \
				-D_$(ENCRYPT_ROOTFS)_ \
				-D_$(SIGNATUREMETHOD)_ \
				-D_$(CHECK_SIGNATURE_BEFORE_BOOT)_


ifeq ($(BOOT_OS), BOOT_OS_RTOS_BOOT_LINUX)
	C_DEFINE_EXT += -D_NVT_FASTBOOT_
endif

ifeq ($(NVT_ROOTFS_TYPE), NVT_ROOTFS_TYPE_RAMDISK)
	C_DEFINE_EXT += -DNVT_LINUX_RAMDISK_SUPPORT
else ifeq ($(NVT_ROOTFS_TYPE), NVT_ROOTFS_TYPE_NAND_UBI)
	C_DEFINE_EXT += -DNVT_UBIFS_SUPPORT
else ifeq ($(NVT_ROOTFS_TYPE), NVT_ROOTFS_TYPE_NAND_JFFS2)
	C_DEFINE_EXT += -DNVT_JFFS2_SUPPORT
else ifeq ($(NVT_ROOTFS_TYPE), NVT_ROOTFS_TYPE_NOR_JFFS2)
	C_DEFINE_EXT += -DNVT_JFFS2_SUPPORT
else ifeq ($(NVT_ROOTFS_TYPE), NVT_ROOTFS_TYPE_NOR_SQUASH)
	C_DEFINE_EXT += -DNVT_SQUASH_SUPPORT
else ifeq ($(NVT_ROOTFS_TYPE), NVT_ROOTFS_TYPE_NAND_SQUASH)
	C_DEFINE_EXT += -DNVT_SQUASH_SUPPORT
else ifeq ($(NVT_ROOTFS_TYPE), NVT_ROOTFS_TYPE_NAND_SQUASH_NEW)
	C_DEFINE_EXT += -DNVT_SQUASH_SUPPORT
else ifeq ($(NVT_ROOTFS_TYPE), NVT_ROOTFS_TYPE_EXT4)
	C_DEFINE_EXT += -DNVT_EXT4_SUPPORT
endif

PLATFORM_CPPFLAGS += $(C_DEFINE_EXT)
PLATFORM_CPPFLAGS += -DCONFIG_SYS_TEXT_BASE=$(BOARD_UBOOT_ADDR)
