#ifndef __IDE_REG_H__
#define __IDE_REG_H__

#include "ide_platform.h"

/*
    @addtogroup mIDrvDisp_IDE
*/
//@{

#define IDE_CTRL_OFS            0x000
REGDEF_BEGIN(IDE_CTRL)
REGDEF_BIT(dmach_dis, 1)
REGDEF_BIT(o1_en, 1)
//  REGDEF_BIT(o2_en            , 1)
REGDEF_BIT(dmach_idle, 1)
REGDEF_BIT(v1_en, 1)
REGDEF_BIT(v2_en, 1)
REGDEF_BIT(dither_en, 1)
REGDEF_BIT(dither_freerun, 1)
REGDEF_BIT(disp_dev, 4)
REGDEF_BIT(p_dir, 1)
REGDEF_BIT(lcd_odd, 2)
REGDEF_BIT(lcd_even, 2)
REGDEF_BIT(hs_inv, 1)
REGDEF_BIT(vs_inv, 1)
REGDEF_BIT(hvld_inv, 1)
REGDEF_BIT(vvld_inv, 1)
REGDEF_BIT(clk_inv, 1)
REGDEF_BIT(fld_inv, 1)
REGDEF_BIT(rgbd, 1)
REGDEF_BIT(de_inv, 1)
REGDEF_BIT(hdmi_ddr, 1)
REGDEF_BIT(srst, 1)
REGDEF_BIT(through, 1)
REGDEF_BIT(ide_en, 1)
REGDEF_BIT(load, 1)
REGDEF_BIT(clk_1_2, 1)
REGDEF_BIT(rgbd_swap, 1)
REGDEF_BIT(out_dram_fmt, 1)         //New
REGDEF_END(IDE_CTRL)

#define IDE_DRAM_WB_OFS      0x004

REGDEF_BEGIN(IDE_DRAM_WB)
REGDEF_BIT(out_dram_en, 1)
REGDEF_BIT(out_uv_swap, 1)
REGDEF_BIT(, 30)
REGDEF_END(IDE_DRAM_WB)

#define IDE_V1_DB0_Y_OFS        0xD00
#define IDE2_V1_DB0_Y_OFS       0xB00
//#define IDE_V1_DB1_Y_OFS        0xD04
//#define IDE_V1_DB2_Y_OFS        0xD08
//#define IDE_V1_DB3_Y_OFS        0xD0C
#define IDE_V1_DB0_UV_OFS       0xD10
#define IDE_V1_DB0_UV_ODD_OFS   0xD14
#define IDE2_V1_DB0_UV_OFS      0xB10
#define IDE2_V1_DB0_UV_ODD_OFS  0xB14
//#define IDE_V1_DB1_UV_OFS       0xD14
//#define IDE_V1_DB2_UV_OFS       0xD18
//#define IDE_V1_DB3_UV_OFS       0xD1C

/*#define IDE_V1_F1_DB0_Y_OFS     0xD20
#define IDE_V1_F1_DB1_Y_OFS     0xD24
#define IDE_V1_F1_DB2_Y_OFS     0xD28
#define IDE_V1_F1_DB3_Y_OFS     0xD2C
#define IDE_V1_F1_DB0_UV_OFS    0xD30
#define IDE_V1_F1_DB1_UV_OFS    0xD34
#define IDE_V1_F1_DB2_UV_OFS    0xD38
#define IDE_V1_F1_DB3_UV_OFS    0xD3C*/

#define IDE_V2_DB0_Y_OFS        0xD40
//#define IDE_V2_DB1_Y_OFS        0xD44
//#define IDE_V2_DB2_Y_OFS        0xD48
//#define IDE_V2_DB3_Y_OFS        0xD4C
#define IDE_V2_DB0_UV_OFS       0xD50
#define IDE_V2_DB0_UV_ODD_OFS   0xD54
//#define IDE_V2_DB1_UV_OFS       0xD54
//#define IDE_V2_DB2_UV_OFS       0xD58
//#define IDE_V2_DB3_UV_OFS       0xD5C

/*#define IDE_V2_F1_DB0_Y_OFS     0xD60
#define IDE_V2_F1_DB1_Y_OFS     0xD64
#define IDE_V2_F1_DB2_Y_OFS     0xD68
#define IDE_V2_F1_DB3_Y_OFS     0xD6C
#define IDE_V2_F1_DB0_UV_OFS    0xD70
#define IDE_V2_F1_DB1_UV_OFS    0xD74
#define IDE_V2_F1_DB2_UV_OFS    0xD78
#define IDE_V2_F1_DB3_UV_OFS    0xD7C*/

#define IDE_O1_ST_OFS           0x05C
#if 0
#define IDE_O2_ST_OFS           0x068
#endif

#define IDE_O1_AST_OFS          0x1BC

REGDEF_BEGIN(IDE_BUF_ADDR)
REGDEF_BIT(addr, 32)
REGDEF_END(IDE_BUF_ADDR)

/*#define IDE_V1_DB0_CB_OFS       0x010
#define IDE_V1_DB1_CB_OFS       0x014
#define IDE_V1_DB2_CB_OFS       0x018
#define IDE_V2_DB0_CB_OFS       0x03C
#define IDE_V2_DB1_CB_OFS       0x040
#define IDE_V2_DB2_CB_OFS       0x044*/
REGDEF_BEGIN(IDE_BUF_ADDR2)
REGDEF_BIT(addr, 32)
REGDEF_END(IDE_BUF_ADDR2)

#define IDE_V1_BUF_DIM_OFS      0x028
#define IDE_V2_BUF_DIM_OFS      0x054
#define IDE_O1_BUF_DIM_OFS      0x060
//#define IDE_O2_BUF_DIM_OFS    0x06C

REGDEF_BEGIN(IDE_BUF_DIM)
REGDEF_BIT(width, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(height, 13)
REGDEF_BIT(, 3)
REGDEF_END(IDE_BUF_DIM)

#define IDE_V1_BUF_ATTR_OFS     0x02C
#define IDE_V2_BUF_ATTR_OFS     0x058
REGDEF_BEGIN(IDE_VBUF_ATTR)
REGDEF_BIT(lofs, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(, 2)
REGDEF_BIT(, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(l2r, 1)
REGDEF_BIT(t2b, 1)
REGDEF_BIT(, 2)
REGDEF_BIT(, 2)
REGDEF_BIT(, 2)
REGDEF_END(IDE_VBUF_ATTR)

#define IDE_O1_BUF_ATTR_OFS     0x064
//#define IDE_O2_BUF_ATTR_OFS   0x070

REGDEF_BEGIN(IDE_OBUF_ATTR)
REGDEF_BIT(lofs, 13)
REGDEF_BIT(, 5)
REGDEF_BIT(, 1)
REGDEF_BIT(, 5)
REGDEF_BIT(l2r, 1)
REGDEF_BIT(t2b, 1)
REGDEF_BIT(, 6)
REGDEF_END(IDE_OBUF_ATTR)

#define IDE_SCALE_CTRL_OFS      0x074
REGDEF_BEGIN(IDE_SCALE_CTRL)
REGDEF_BIT(o1_vud, 1)
REGDEF_BIT(o2_vud, 1)
REGDEF_BIT(v1_vud, 1)
REGDEF_BIT(v2_vud, 1)
REGDEF_BIT(o1_hud, 1)
REGDEF_BIT(o2_hud, 1)
REGDEF_BIT(v1_hud, 1)
REGDEF_BIT(v2_hud, 1)
REGDEF_BIT(vpi_en, 1)		//new, progressive to interlace 2 tap filter enable bit.
REGDEF_BIT(, 23)
REGDEF_END(IDE_SCALE_CTRL)

// new, progressive to interlace control 
#define IDE_PI_CTRL_OFS      0x078
REGDEF_BEGIN(IDE_PI_CTRL)
REGDEF_BIT(pif_coef0, 4)
REGDEF_BIT(pif_coef1, 4)
REGDEF_BIT(, 24)
REGDEF_END(IDE_PI_CTRL)

#define IDE_O1_WIN_ATTR3_OFS    0x07C
//#define IDE_O2_WIN_ATTR3_OFS  0x080
#define IDE_V1_WIN_ATTR3_OFS    0x0C4
#define IDE_V2_WIN_ATTR3_OFS    0x0C8
REGDEF_BEGIN(IDE_VSF_INIT)
REGDEF_BIT(vsf_init0, 12)
REGDEF_BIT(, 4)
REGDEF_BIT(vsf_init1, 14)
REGDEF_BIT(, 2)
REGDEF_END(IDE_VSF_INIT)

#define IDE_VIDEO_OPT_OFS       0x084
REGDEF_BEGIN(IDE_VIDEO_OPT)
REGDEF_BIT(ck_y, 8)
REGDEF_BIT(ck_cb, 8)
REGDEF_BIT(ck_cr, 8)
REGDEF_BIT(, 4)
REGDEF_BIT(vopt2, 2)
REGDEF_BIT(ck_sel, 1)
REGDEF_BIT(, 1)
REGDEF_END(IDE_VIDEO_OPT)

/*#define IDE_OSD_OPT_OFS         0x088
REGDEF_BEGIN(IDE_OSD_OPT)
    REGDEF_BIT(ck               , 8)
    REGDEF_BIT(                 , 16)
    REGDEF_BIT(ck_en            , 1)
    REGDEF_BIT(                 , 7)
REGDEF_END(IDE_OSD_OPT)*/

#define IDE_O1_WIN_ATTR0_OFS    0x08C
//#define IDE_O2_WIN_ATTR0_OFS  0x098
#define IDE_OSD_HSF_TOTAL_BITS  15
#define IDE_OSD_VSF_TOTAL_BITS  12
REGDEF_BEGIN(IDE_OSD_WIN_ATTR0)
REGDEF_BIT(hsf, 15)
REGDEF_BIT(, 1)
REGDEF_BIT(sub, 1)
REGDEF_BIT(hsm, 1)
REGDEF_BIT(vsf, 12)
REGDEF_BIT(vsub, 1)
REGDEF_BIT(vsm, 1)
REGDEF_END(IDE_OSD_WIN_ATTR0)

#define IDE_O1_WIN_ATTR1_OFS    0x090
//#define IDE_O2_WIN_ATTR1_OFS  0x09C
REGDEF_BEGIN(IDE_OSD_WIN_ATTR1)
REGDEF_BIT(width, 13)
REGDEF_BIT(, 2)
REGDEF_BIT(fmt_ord, 1)
REGDEF_BIT(height, 12)
REGDEF_BIT(fmt, 4)
REGDEF_END(IDE_OSD_WIN_ATTR1)

#define IDE_O1_WIN_ATTR2_OFS    0x094
//#define IDE_O2_WIN_ATTR2_OFS  0x0A0
REGDEF_BEGIN(IDE_OSD_WIN_ATTR2)
REGDEF_BIT(x, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(y, 12)
REGDEF_BIT(, 2)
REGDEF_BIT(cst_dis, 1)
REGDEF_BIT(rld_en, 1)
REGDEF_END(IDE_OSD_WIN_ATTR2)

#define IDE_V1_WIN_ATTR0_OFS    0x0A4
#define IDE_V2_WIN_ATTR0_OFS    0x0B0
#define IDE_VIDEO_HSF_TOTAL_BITS  15
#define IDE_VIDEO_VSF_TOTAL_BITS  12
REGDEF_BEGIN(IDE_VIDEO_WIN_ATTR0)
REGDEF_BIT(hsf, 15)
REGDEF_BIT(, 1)
REGDEF_BIT(sub, 1)
REGDEF_BIT(hsm, 1)
REGDEF_BIT(vsf, 12)
REGDEF_BIT(vsub, 1)
REGDEF_BIT(, 1)                  //vsm
REGDEF_END(IDE_VIDEO_WIN_ATTR0)

#define IDE_V1_WIN_ATTR1_OFS    0x0A8
#define IDE_V2_WIN_ATTR1_OFS    0x0B4
REGDEF_BEGIN(IDE_VIDEO_WIN_ATTR1)
REGDEF_BIT(width, 13)
REGDEF_BIT(, 2)
REGDEF_BIT(ycc_en, 1)
REGDEF_BIT(height, 12)
REGDEF_BIT(fmt, 4)
REGDEF_END(IDE_VIDEO_WIN_ATTR1)

#define IDE_V1_WIN_ATTR2_OFS    0x0AC
#define IDE_V2_WIN_ATTR2_OFS    0x0B8
REGDEF_BEGIN(IDE_VIDEO_WIN_ATTR2)
REGDEF_BIT(x, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(y, 13)
REGDEF_BIT(, 3)
REGDEF_END(IDE_VIDEO_WIN_ATTR2)

#define IDE_BG_OFS              0x0BC
REGDEF_BEGIN(IDE_BG)
REGDEF_BIT(y, 8)
REGDEF_BIT(cb, 8)
REGDEF_BIT(cr, 8)
REGDEF_BIT(, 8)
REGDEF_END(IDE_BG)

#define IDE_OSD_CTRL_OFS        0x0C0
REGDEF_BEGIN(IDE_OSD_CTRL)
REGDEF_BIT(, 10)
REGDEF_BIT(pal0_rw, 1)
//  REGDEF_BIT(pal1_rw          , 1)
REGDEF_BIT(, 21)
REGDEF_END(IDE_OSD_CTRL)

#define IDE_TIMING1_OFS         0x0CC
REGDEF_BEGIN(IDE_TIMING1)
REGDEF_BIT(hsynct, 12)
REGDEF_BIT(htotal, 17)
REGDEF_BIT(, 2)
REGDEF_BIT(hsdelay, 1)
REGDEF_END(IDE_TIMING1)

#define IDE_TIMING2_OFS         0x0D0
REGDEF_BEGIN(IDE_TIMING2)
REGDEF_BIT(hvldst, 12)
REGDEF_BIT(hvlded, 17)
REGDEF_BIT(, 3)
REGDEF_END(IDE_TIMING2)

#define IDE_TIMING3_OFS         0x0D4
REGDEF_BEGIN(IDE_TIMING3)
REGDEF_BIT(vsynct, 9)
REGDEF_BIT(, 3)
REGDEF_BIT(vtotal, 17)
REGDEF_BIT(, 2)
REGDEF_BIT(vsdelay, 1)
REGDEF_END(IDE_TIMING3)

#define IDE_TIMING4_OFS         0x0D8
REGDEF_BEGIN(IDE_TIMING4)
REGDEF_BIT(oddvvldst, 11)
REGDEF_BIT(, 1)
REGDEF_BIT(oddvvlded, 17)
REGDEF_BIT(, 2)
REGDEF_BIT(inter_load_mode, 1)
REGDEF_END(IDE_TIMING4)

#define IDE_TIMING5_OFS         0x0DC
REGDEF_BEGIN(IDE_TIMING5)
REGDEF_BIT(evenvvldst, 11)
REGDEF_BIT(, 1)
REGDEF_BIT(evenvvlded, 17)
REGDEF_BIT(interlace, 1)
REGDEF_BIT(, 1)                  //odd_st
REGDEF_BIT(cdfld, 1)
REGDEF_END(IDE_TIMING5)

#define IDE_DIGI_TIMING1_OFS    0x0E0
REGDEF_BEGIN(IDE_DIGI_TIMING1)
REGDEF_BIT(coddblkst, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(coddblked, 13)
REGDEF_BIT(, 3)
REGDEF_END(IDE_DIGI_TIMING1)

#define IDE_DIGI_TIMING2_OFS    0x0E4
REGDEF_BEGIN(IDE_DIGI_TIMING2)
REGDEF_BIT(cevenblkst, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(cevenblked, 13)
REGDEF_BIT(, 3)
REGDEF_END(IDE_DIGI_TIMING2)

#define IDE_DIGI_TIMING3_OFS    0x0E8
REGDEF_BEGIN(IDE_DIGI_TIMING3)
REGDEF_BIT(cfidst, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(cfided, 13)
REGDEF_BIT(, 3)
REGDEF_END(IDE_DIGI_TIMING3)

#define IDE_SUBPIXEL_OFS        0x0EC
REGDEF_BEGIN(IDE_SUBPIXEL)
REGDEF_BIT(odd_r,  1)
REGDEF_BIT(odd_g,  1)
REGDEF_BIT(odd_b,  1)
REGDEF_BIT(,  1)
REGDEF_BIT(even_r,  1)
REGDEF_BIT(even_g,  1)
REGDEF_BIT(even_b,  1)
REGDEF_BIT(, 25)
REGDEF_END(IDE_SUBPIXEL)

#define IDE_PANEL_CTRL_OFS      0x0F0

REGDEF_BEGIN(IDE_PANEL_CTRL)
REGDEF_BIT(cex, 1)
REGDEF_BIT(yc_ex, 1)
REGDEF_BIT(ycc_clm, 2)
REGDEF_BIT(, 4)
REGDEF_BIT(r_vbits, 2)
REGDEF_BIT(g_vbits, 2)
REGDEF_BIT(b_vbits, 2)
REGDEF_BIT(out_comp0_sel, 2)
REGDEF_BIT(out_comp1_sel, 2)
REGDEF_BIT(out_comp2_sel, 2)
REGDEF_BIT(out_comp_bswp, 1)
REGDEF_BIT(out_comp_len, 1)
REGDEF_BIT(, 10)
REGDEF_END(IDE_PANEL_CTRL)

#define IDE_CTRL2_OFS           0x0F4
REGDEF_BEGIN(IDE_CTRL2)
REGDEF_BIT(icst0_en, 1)
REGDEF_BIT(icst1_en, 1)
REGDEF_BIT(gamma_en, 1)
REGDEF_BIT(cst1_en, 1)
REGDEF_BIT(color_ctrl_en, 1)
REGDEF_BIT(color_comp_adj_en, 1)
REGDEF_BIT(color_comphue_adj_en, 1)
REGDEF_BIT(color_comp_ycon_en, 1)
REGDEF_BIT(color_comp_ccon_en, 1)
REGDEF_BIT(, 23)
REGDEF_END(IDE_CTRL2)

#define IDE_INT_OFS                     0x0F8
#define IDE_VS_IRQEN                    ((UINT32)0x00000001 << 0)
#define IDE_HS_IRQEN                    ((UINT32)0x00000001 << 1)
#define IDE_V1BWF_IRQEN                 ((UINT32)0x00000001 << 2)
#define IDE_V2BWF_IRQEN                 ((UINT32)0x00000001 << 3)
#define IDE_OSD1BWF_IRQEN               ((UINT32)0x00000001 << 4)
//#define IDE_OSD2BWF_IRQEN               ((UINT32)0x00000001 << 5)
#define IDE_YUV_OUT_DRAM_END_IRQEN      ((UINT32)0x00000001 << 6)
#define IDE_FRAME_END_IRQEN             ((UINT32)0x00000001 << 7)
#define IDE_V1_LINE_START_ERROR_IRQEN   ((UINT32)0x00000001 << 8)
#define IDE_V2_LINE_START_ERROR_IRQEN   ((UINT32)0x00000001 << 9)
#define IDE_O1_LINE_START_ERROR_IRQEN   ((UINT32)0x00000001 <<10)
#define IDE_MON_N1_LINE_IRQEN   		((UINT32)0x00000001 <<14)
#define IDE_MON_N2_LINE_IRQEN   		((UINT32)0x00000001 <<15)
#define IDE_V1_YCC_ERROR_IRQEN   		((UINT32)0x00000001 <<19)
#define IDE_V2_YCC_ERROR_IRQEN   		((UINT32)0x00000001 <<20)

#define IDE_INTEN_MSK           0x001FFFFF

REGDEF_BEGIN(IDE_INT)
REGDEF_BIT(vs_irqen, 1)
REGDEF_BIT(hs_irqen, 1)
REGDEF_BIT(v1bwf_irqen, 1)
REGDEF_BIT(v2bwf_irqen, 1)
REGDEF_BIT(o1bwf_irqen, 1)
REGDEF_BIT(o2bwf_irqen, 1)
REGDEF_BIT(dramend_irqen, 1)	// yuv output dram end
REGDEF_BIT(fmend_irqen, 1)      //v1or_irqen
REGDEF_BIT(v1lse_irqen, 1)      //v1 line start error
REGDEF_BIT(v2lse_irqen, 1)      //v2 line start error
REGDEF_BIT(o1lse_irqen, 1)      //o1 line start error
REGDEF_BIT(, 3)
REGDEF_BIT(linemon1_irqen, 1)   //monitor N1-th line 
REGDEF_BIT(linemon2_irqen, 1)   //monitor N2-th line
REGDEF_BIT(, 3)
REGDEF_BIT(v1ycc_irqen, 1)      //v1 ycc error
REGDEF_BIT(v2ycc_irqen, 1)      //v2 ycc error
REGDEF_BIT(, 11)
REGDEF_END(IDE_INT)

#define IDE_INT_STS_OFS                     0x0FC
#define IDE_VS_IRQSTS                   ((UINT32)0x00000001 << 0)
#define IDE_HS_IRQSTS                   ((UINT32)0x00000001 << 1)
#define IDE_V1BWF_IRQSTS                ((UINT32)0x00000001 << 2)
#define IDE_V2BWF_IRQSTS                ((UINT32)0x00000001 << 3)
#define IDE_OSD1BWF_IRQSTS              ((UINT32)0x00000001 << 4)
#define IDE_OSD2BWF_IRQSTS              ((UINT32)0x00000001 << 5)
#define IDE_YUV_OUT_DRAM_END_IRQSTS     ((UINT32)0x00000001 << 6)
#define IDE_FRAME_END_IRQSTS            ((UINT32)0x00000001 << 7)
#define IDE_V1_LINE_START_ERROR_IRQSTS  ((UINT32)0x00000001 << 8)
#define IDE_V2_LINE_START_ERROR_IRQSTS  ((UINT32)0x00000001 << 9)
#define IDE_O1_LINE_START_ERROR_IRQSTS  ((UINT32)0x00000001 <<10)
#define IDE_MON_N1_LINE_IRQSTS   		((UINT32)0x00000001 <<14)
#define IDE_MON_N2_LINE_IRQSTS   		((UINT32)0x00000001 <<15)
#define IDE_WB_Y_OVERRUN_IRQSTS   		((UINT32)0x00000001 <<16)
#define IDE_WB_C_OVERRUN_IRQSTS   		((UINT32)0x00000001 <<17)
#define IDE_DMA_ERROR_IRQSTS	   		((UINT32)0x00000001 <<18)
#define IDE_V1_YCC_ERROR_IRQSTS   		((UINT32)0x00000001 <<19)
#define IDE_V2_YCC_ERROR_IRQSTS   		((UINT32)0x00000001 <<20)
#define IDE_INTSTS_MSK          0x001FFFFF
#define IDE_INTSTS_SFT          0

REGDEF_BEGIN(IDE_INT_STS)
REGDEF_BIT(vs_irqsts, 1)
REGDEF_BIT(hs_irqsts, 1)
REGDEF_BIT(v1_bwf_irqsts, 1)
REGDEF_BIT(v2_bwf_irqsts, 1)
REGDEF_BIT(o1_bwf_irqsts, 1)
REGDEF_BIT(o2_bwf_irqsts, 1)
REGDEF_BIT(dramend_irqen, 1)	// yuv output dram end
REGDEF_BIT(fmend_irqsts, 1)      //v1or_irqen
REGDEF_BIT(v1lse_irqsts, 1)      //v1 line start error
REGDEF_BIT(v2lse_irqsts, 1)      //v2 line start error
REGDEF_BIT(o1lse_irqsts, 1)      //o1 line start error
REGDEF_BIT(, 3)
REGDEF_BIT(linemon1_irqsts, 1)   //monitor N1-th line 
REGDEF_BIT(linemon2_irqsts, 1)   //monitor N2-th line
REGDEF_BIT(, 3)
REGDEF_BIT(v1ycc_irqsts, 1)      //v1 ycc error
REGDEF_BIT(v2ycc_irqsts, 1)      //v2 ycc error
REGDEF_BIT(, 11)
REGDEF_END(IDE_INT_STS)

#define IDE_V1_BUF_Y_OFS        0x100
#define IDE_V1_BUF_CB_OFS       0x104
//#define IDE_V1_BUF_CR_OFS     0x108
#define IDE_V2_BUF_Y_OFS        0x10C
#define IDE_V2_BUF_CB_OFS       0x110
//#define IDE_V2_BUF_CR_OFS     0x114
#define IDE_O1_BUF_ADDR_OFS     0x118
//#define IDE_O2_BUF_ADDR_OFS   0x11C
#define IDE_O1_BUF_ALPHA_OFS    0x120
REGDEF_BEGIN(IDE_CUR_ADDR)
REGDEF_BIT(addr, 29)
REGDEF_BIT(, 3)
REGDEF_END(IDE_CUR_ADDR)

#define IDE_DMA_LEN_OFS         0x124
REGDEF_BEGIN(IDE_DMA_LEN)
REGDEF_BIT(v1_y_len, 4)
REGDEF_BIT(v1_c_len, 4)
REGDEF_BIT(v2_y_len, 4)
REGDEF_BIT(v2_c_len, 4)
REGDEF_BIT(o1_a_len, 4)
REGDEF_BIT(o1_rgb_len, 4)
REGDEF_BIT(o2_dma_len, 4)
REGDEF_END(IDE_DMA_LEN)

#define IDE_PAL_SHADOW_OFS     0x128
REGDEF_BEGIN(IDE_PAL_SHADOW)
REGDEF_BIT(, 1)
REGDEF_BIT(ide_lb_r_en, 1)
REGDEF_BIT(, 30)
REGDEF_END(IDE_PAL_SHADOW)

#define IDE_O1_COLORKEY_OFS    0x130
//#define IDE_O2_COLORKEY_OFS  0x134
REGDEF_BEGIN(IDE_OSD_COLORKEY)
REGDEF_BIT(ck_y, 8)
REGDEF_BIT(ck_cb, 8)
REGDEF_BIT(ck_cr, 8)
REGDEF_BIT(ck_alpha, 8)
//REGDEF_BIT(ck_en, 1)
//REGDEF_BIT(ck_op, 2)
//REGDEF_BIT(, 5)
REGDEF_END(IDE_OSD_COLORKEY)

#define IDE_O1_COLORKEY_CTL_OFS    0x138
REGDEF_BEGIN(IDE_OSD_COLORKEY_CTL)
REGDEF_BIT(ck_en, 1)
REGDEF_BIT(ck_op, 3)
REGDEF_BIT(, 28)
REGDEF_END(IDE_OSD_COLORKEY_CTL)

#define IDE_LINE_MON_CTL1_OFS    0x140
#define IDE_LINE_MON_CTL2_OFS    0x144
REGDEF_BEGIN(IDE_LINE_MON_CTL)
REGDEF_BIT(mon_line, 13)
REGDEF_BIT(, 19)
REGDEF_END(IDE_LINE_MON_CTL)

#define IDE_V1_LOWPASS_OFS     0x148
#define IDE_V2_LOWPASS_OFS     0x14C
#define IDE_O1_LOWPASS_OFS     0x150
//#define IDE_O2_LOWPASS_OFS   0x154
REGDEF_BEGIN(IDE_LOWPASS_OPT)
REGDEF_BIT(lp_tap0, 8)
REGDEF_BIT(lp_tap1, 8)
REGDEF_BIT(lp_tap2, 8)
REGDEF_BIT(, 7)
REGDEF_BIT(lp_en, 1)
REGDEF_END(IDE_LOWPASS_OPT)


#define IDE_CST0_0_OFS           0x158
#define IDE_CST0_COEF_NUM         4
REGDEF_BEGIN(IDE_CST0_COEF)
REGDEF_BIT(coef0, 8)
REGDEF_BIT(coef1, 8)
REGDEF_BIT(coef2, 8)
REGDEF_BIT(coef3, 8)
REGDEF_END(IDE_CST0_COEF)


#define IDE_CST1_0_OFS           0x15C
#define IDE_CST1_COEF_NUM         4
REGDEF_BEGIN(IDE_CST1_COEF)
REGDEF_BIT(coef0, 8)
REGDEF_BIT(coef1, 8)
REGDEF_BIT(coef2, 8)
REGDEF_BIT(coef3, 8)
REGDEF_END(IDE_CST1_COEF)


#define IDE_ICST0_0_OFS          0x160
#define IDE_ICST0_1_OFS          0x164
#define IDE_ICST0_2_OFS          0x168
#define IDE_ICST0_3_OFS          0x16C
#define IDE_ICST0_4_OFS          0x170
#define IDE_ICST0_COEF_NUM       9
REGDEF_BEGIN(IDE_ICST0_COEF)
REGDEF_BIT(coef0, 12)
REGDEF_BIT(, 4)
REGDEF_BIT(coef1, 12)
REGDEF_BIT(, 4)
REGDEF_END(IDE_ICST0_COEF)


#define IDE_ICST0_PREOFS_OFS     0x174
REGDEF_BEGIN(IDE_ICST0_PREOFS)
REGDEF_BIT(y, 8)
REGDEF_BIT(cb, 9)
REGDEF_BIT(cr, 9)
REGDEF_BIT(, 6)
REGDEF_END(IDE_ICST0_PREOFS)


#define IDE_ICST0_OUTOFS_OFS     0x178
//#define IDE_TV_OUTOFS_OFS       0x180
REGDEF_BEGIN(IDE_ICST0_POSTOFS)
REGDEF_BIT(y, 8)
REGDEF_BIT(cb, 9)
REGDEF_BIT(cr, 9)
REGDEF_BIT(, 6)
REGDEF_END(IDE_ICST0_POSTOFS)

#define IDE_ICST0_OUTLMT1_OFS    0x17C
//#define IDE_TV_OUTLMT1_OFS      0x184
REGDEF_BEGIN(IDE_ICST0_OUTLMT1)
REGDEF_BIT(y_lower_lmt, 8)
REGDEF_BIT(y_upper_lmt, 8)
REGDEF_BIT(cb_lower_lmt, 8)
REGDEF_BIT(cb_upper_lmt, 8)
REGDEF_END(IDE_ICST0_OUTLMT1)

#define IDE_ICST0_OUTLMT2_OFS    0x180
//#define IDE_TV_OUTLMT2_OFS      0x188
REGDEF_BEGIN(IDE__ICST0_OUTLMT2)
REGDEF_BIT(cr_lower_lmt, 8)
REGDEF_BIT(cr_upper_lmt, 8)
REGDEF_BIT(, 16)
REGDEF_END(IDE_ICST0_OUTLMT2)

#define IDE_ICST1_COFS           0x184
#define IDE_ICST1_COEF_NUM       4
REGDEF_BEGIN(IDE_ICST1_COEF)
REGDEF_BIT(coef0, 8)
REGDEF_BIT(coef1, 8)
REGDEF_BIT(coef2, 8)
REGDEF_BIT(coef3, 8)
REGDEF_END(IDE_ICST1_COEF)


#define IDE_V1_BLINK_OFS        0x18C
#define IDE_V2_BLINK_OFS        0x1A0
REGDEF_BEGIN(IDE_BLINK)
REGDEF_BIT(ovrexp_en, 1)
REGDEF_BIT(undexp_en, 1)
REGDEF_BIT(blink_sel, 1)
REGDEF_BIT(cnt_set, 1)
REGDEF_BIT(, 4)
REGDEF_BIT(blink_cnt, 8)
REGDEF_BIT(, 16)
REGDEF_END(IDE_BLINK)

#define IDE_V1_OVREXP_TH_OFS    0x190
#define IDE_V1_OVREXP_COLOR_OFS 0x194
#define IDE_V1_UNDEXP_TH_OFS    0x198
#define IDE_V1_UNDEXP_COLOR_OFS 0x19C
#define IDE_V2_OVREXP_TH_OFS    0x1A4
#define IDE_V2_OVREXP_COLOR_OFS 0x1A8
#define IDE_V2_UNDEXP_TH_OFS    0x1AC
#define IDE_V2_UNDEXP_COLOR_OFS 0x1B0
REGDEF_BEGIN(IDE_EXP_COLOR)
REGDEF_BIT(y, 8)
REGDEF_BIT(cb, 8)
REGDEF_BIT(cr, 8)
REGDEF_BIT(, 8)
REGDEF_END(IDE_EXP_COLOR)

#define IDE_BLEND_OFS           0x1B4
REGDEF_BEGIN(IDE_BLEND)
REGDEF_BIT(alpha_sel1, 2)
REGDEF_BIT(alpha_sel2, 2)
REGDEF_BIT(alpha_sel3, 3)
REGDEF_BIT(alpha_sel4, 1)
REGDEF_BIT(global_alpha1, 8)
REGDEF_BIT(global_alpha2, 8)
REGDEF_BIT(global_alpha3, 8)
REGDEF_END(IDE_BLEND)

#define IDE_BLEND2_OFS          0x1B8
REGDEF_BEGIN(IDE_BLEND2)
REGDEF_BIT(global_alpha4, 8)
REGDEF_BIT(global_alpha5, 8)
REGDEF_BIT(, 15)
REGDEF_BIT(fd_line_lyr_swap, 1)
REGDEF_END(IDE_BLEND2)

#define IDE_AXI_REG1_OFS          0x1CC		//new
REGDEF_BEGIN(IDE_AXI_REG1)
REGDEF_BIT(axi_dis, 1)
REGDEF_BIT(, 31)
REGDEF_END(IDE_AXI_REG1)

#define IDE_RLD_CTRL_OFS          0x1D4		//new
REGDEF_BEGIN(IDE_RLD_CTRL)
REGDEF_BIT(rld_cnt, 3)
REGDEF_BIT(, 1)
REGDEF_BIT(rld_len, 2)
REGDEF_BIT(, 26)
REGDEF_END(IDE_RLD_CTRL)

#define IDE_RLD_READ_SIZE_OFS				0x1D8
#define IDE_RLD_ALPHA_READ_SIZE_OFS         0x1DC
REGDEF_BEGIN(IDE_RLD_SIZE)
REGDEF_BIT(rld_size, 32)
REGDEF_END(IDE_RLD_SIZE)

#define IDE_YCC_ENC_CTRL_OFS	 0x1E0
REGDEF_BEGIN(IDE_YCC_ENC_CTRL)
REGDEF_BIT(shift_en, 1)
REGDEF_BIT(, 7)
REGDEF_BIT(dith_en, 1)
REGDEF_BIT(, 3)
REGDEF_BIT(dith_rst, 1)
REGDEF_BIT(sw_rst, 1)
REGDEF_BIT(, 18)
REGDEF_END(IDE_YCC_ENC_CTRL)

#define IDE_YCC_DITH_INIT_OFS	 0x1E4
REGDEF_BEGIN(IDE_YCC_DITH_INIT)
REGDEF_BIT(rounding_init0, 15)
REGDEF_BIT(, 1)
REGDEF_BIT(rounding_init1, 4)
REGDEF_BIT(, 12)
REGDEF_END(IDE_YCC_DITH_INIT)

#define IDE_YCC_QTBL_IDX0_OFS	 0x1E8
#define IDE_YCC_QTBL_IDX1_OFS	 0x1EC
#define IDE_YCC_QTBL_IDX2_OFS	 0x1F0
#define IDE_YCC_QTBL_IDX3_OFS	 0x1F4
REGDEF_BEGIN(IDE_YCC_QTBL_IDX)
REGDEF_BIT(qtbl0, 5)
REGDEF_BIT(, 3)
REGDEF_BIT(qtbl1, 5)
REGDEF_BIT(, 3)
REGDEF_BIT(qtbl2, 5)
REGDEF_BIT(, 3)
REGDEF_BIT(qtbl3, 5)
REGDEF_BIT(, 3)
REGDEF_END(IDE_YCC_QTBL_IDX)

#define IDE_CURSOR_POS_OFS	 0x700
REGDEF_BEGIN(IDE_CURSOR_POS)
REGDEF_BIT(x, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(y, 13)
REGDEF_BIT(, 1)
REGDEF_BIT(cursor_en, 1)
REGDEF_BIT(, 1)
REGDEF_END(IDE_CURSOR_POS)

#define IDE_CURSOR_COLOR1_OFS	 0x708
#define IDE_CURSOR_COLOR2_OFS	 0x70C
#define IDE_CURSOR_COLOR3_OFS	 0x710
#define IDE_CURSOR_COLOR4_OFS	 0x714
#define IDE_CURSOR_COLOR5_OFS	 0x718
#define IDE_CURSOR_COLOR6_OFS	 0x71C
#define IDE_CURSOR_COLOR7_OFS	 0x720
#define IDE_CURSOR_COLOR8_OFS	 0x724
#define IDE_CURSOR_COLOR9_OFS	 0x728
#define IDE_CURSOR_COLOR10_OFS	 0x72C
#define IDE_CURSOR_COLOR11_OFS	 0x730
#define IDE_CURSOR_COLOR12_OFS	 0x734
#define IDE_CURSOR_COLOR13_OFS	 0x738
#define IDE_CURSOR_COLOR14_OFS	 0x73C
#define IDE_CURSOR_COLOR15_OFS	 0x740
REGDEF_BEGIN(IDE_CURSOR_COLOR)
REGDEF_BIT(cursor_y, 8)
REGDEF_BIT(cursor_cb, 8)
REGDEF_BIT(cursor_cr, 8)
REGDEF_BIT(, 8)
REGDEF_END(IDE_CURSOR_COLOR)

#define IDE_CURSOR_SRAM_OFS	 0x744
REGDEF_BEGIN(IDE_CURSOR_SRAM)
REGDEF_BIT(cpu_access, 1)
REGDEF_BIT(, 31)
REGDEF_END(IDE_CURSOR_SRAM)

#define IDE_DELAY_COUNT_OFS	 0x748
REGDEF_BEGIN(IDE_DELAY_COUNT)
REGDEF_BIT(frm_delay_cnt, 16)
REGDEF_BIT(axi_delay_cnt, 16)
REGDEF_END(IDE_DELAY_COUNT)


#define IDE2_RGAMMA0_OFS         0xC00

#define IDE_RGAMMA0_OFS          0xA00
#define IDE_RGAMMA1_OFS          0xA04
#define IDE_RGAMMA2_OFS          0xA08
#define IDE_RGAMMA3_OFS          0xA0C
#define IDE_RGAMMA4_OFS          0xA10
#define IDE_RGAMMA5_OFS          0xA14
#define IDE_RGAMMA6_OFS          0xA18
#define IDE_RGAMMA7_OFS          0xA1C
#define IDE_RGAMMA8_OFS          0xA20

#define IDE2_GGAMMA0_OFS         0xC24
#define IDE_GGAMMA0_OFS          0xA24
#define IDE_GGAMMA1_OFS          0xA28
#define IDE_GGAMMA2_OFS          0xA2C
#define IDE_GGAMMA3_OFS          0xA30
#define IDE_GGAMMA4_OFS          0xA34
#define IDE_GGAMMA5_OFS          0xA38
#define IDE_GGAMMA6_OFS          0xA3C
#define IDE_GGAMMA7_OFS          0xA40
#define IDE_GGAMMA8_OFS          0xA44

#define IDE2_BGAMMA0_OFS         0xC48
#define IDE_BGAMMA0_OFS          0xA48
#define IDE_BGAMMA1_OFS          0xA4C
#define IDE_BGAMMA2_OFS          0xA50
#define IDE_BGAMMA3_OFS          0xA54
#define IDE_BGAMMA4_OFS          0xA58
#define IDE_BGAMMA5_OFS          0xA5C
#define IDE_BGAMMA6_OFS          0xA60
#define IDE_BGAMMA7_OFS          0xA64
#define IDE_BGAMMA8_OFS          0xA68
#define IDE_GAMMA_LEVEL         32
REGDEF_BEGIN(IDE_GAMMA)
REGDEF_BIT(gamma0, 8)
REGDEF_BIT(gamma1, 8)
REGDEF_BIT(gamma2, 8)
REGDEF_BIT(gamma3, 8)
REGDEF_END(IDE_GAMMA)

#define IDE2_CC_HUE0_OFS         0xC6C
#define IDE_CC_HUE0_OFS          0xA6C
#define IDE_CC_HUE1_OFS          0xA70
#define IDE_CC_HUE2_OFS          0xA74
#define IDE_CC_HUE3_OFS          0xA78
#define IDE_CC_HUE4_OFS          0xA7c
#define IDE_CC_HUE5_OFS          0xA80
#define IDE_CC_HUE_NUM          24
REGDEF_BEGIN(IDE_CC_HUEM)
REGDEF_BIT(cc_huem0, 8)
REGDEF_BIT(cc_huem1, 8)
REGDEF_BIT(cc_huem2, 8)
REGDEF_BIT(cc_huem3, 8)
REGDEF_END(IDE_CC_HUEM)

#define IDE2_CC_INT0_OFS         0xC84
#define IDE_CC_INT0_OFS          0xA84
#define IDE_CC_INT1_OFS          0xA88
#define IDE_CC_INT2_OFS          0xA8C
#define IDE_CC_INT3_OFS          0xA90
#define IDE_CC_INT4_OFS          0xA94
#define IDE_CC_INT5_OFS          0xA98
#define IDE_CC_INT_NUM          24
REGDEF_BEGIN(IDE_CC_INTM)
REGDEF_BIT(cc_intm0, 8)
REGDEF_BIT(cc_intm1, 8)
REGDEF_BIT(cc_intm2, 8)
REGDEF_BIT(cc_intm3, 8)
REGDEF_END(IDE_CC_INTM)

#define IDE2_CC_SAT0_OFS         0xC9C
#define IDE_CC_SAT0_OFS          0xA9C
#define IDE_CC_SAT1_OFS          0xAA0
#define IDE_CC_SAT2_OFS          0xAA4
#define IDE_CC_SAT3_OFS          0xAA8
#define IDE_CC_SAT4_OFS          0xAAC
#define IDE_CC_SAT5_OFS          0xAB0
#define IDE_CC_SAT_NUM         24
REGDEF_BEGIN(IDE_CC_SATM)
REGDEF_BIT(cc_satm0, 8)
REGDEF_BIT(cc_satm1, 8)
REGDEF_BIT(cc_satm2, 8)
REGDEF_BIT(cc_satm3, 8)
REGDEF_END(IDE_CC_SATM)

#define IDE2_CC_DDS0_OFS         0xCB4
#define IDE_CC_DDS0_OFS          0xAB4
#define IDE_CC_DDS1_OFS          0xAB8
#define IDE_CC_DDS_NUM         8
REGDEF_BEGIN(IDE_CC_DDSM)
REGDEF_BIT(cc_ddsm0, 8)
REGDEF_BIT(cc_ddsm1, 8)
REGDEF_BIT(cc_ddsm2, 8)
REGDEF_BIT(cc_ddsm3, 8)
REGDEF_END(IDE_CC_DDSM)

#define IDE2_CC_INTOFS_OFS       0xCBC
#define IDE_CC_INTOFS_OFS        0xABC
REGDEF_BEGIN(IDE_CC_INTOFS)
REGDEF_BIT(cc_int_ofs, 8)
REGDEF_BIT(cc_sat_ofs, 8)
REGDEF_BIT(, 16)
REGDEF_END(IDE_CC_INTOFS)

#define IDE2_CCA0_OFS            0xCC0
#define IDE_CCA0_OFS             0xAC0
REGDEF_BEGIN(IDE_CCA0)
REGDEF_BIT(cca_y_con, 8)
REGDEF_BIT(cca_c_con, 8)
REGDEF_BIT(, 16)
REGDEF_END(IDE_CCA0)

#define IDE2_CCA1_OFS            0xCC4
#define IDE_CCA1_OFS             0xAC4
REGDEF_BEGIN(IDE_CCA1)
REGDEF_BIT(cca_y_ofs, 8)
REGDEF_BIT(cca_cb_ofs, 8)
REGDEF_BIT(cca_cr_ofs, 8)
REGDEF_BIT(, 8)
REGDEF_END(IDE_CCA1)


#define IDE_FD_EN_OFS           0xAD0
#define IDE_FD_EN_NUM           16
REGDEF_BEGIN(IDE_FD_EN)
REGDEF_BIT(FD0, 1)
REGDEF_BIT(FD1, 1)
REGDEF_BIT(FD2, 1)
REGDEF_BIT(FD3, 1)
REGDEF_BIT(FD4, 1)
REGDEF_BIT(FD5, 1)
REGDEF_BIT(FD6, 1)
REGDEF_BIT(FD7, 1)
REGDEF_BIT(FD8, 1)
REGDEF_BIT(FD9, 1)
REGDEF_BIT(FD10, 1)
REGDEF_BIT(FD11, 1)
REGDEF_BIT(FD12, 1)
REGDEF_BIT(FD13, 1)
REGDEF_BIT(FD14, 1)
REGDEF_BIT(FD15, 1)
REGDEF_BIT(FD16, 1)
REGDEF_BIT(FD17, 1)
REGDEF_BIT(FD18, 1)
REGDEF_BIT(FD19, 1)
REGDEF_BIT(FD20, 1)
REGDEF_BIT(FD21, 1)
REGDEF_BIT(FD22, 1)
REGDEF_BIT(FD23, 1)
REGDEF_BIT(FD24, 1)
REGDEF_BIT(FD25, 1)
REGDEF_BIT(FD26, 1)
REGDEF_BIT(FD27, 1)
REGDEF_BIT(FD28, 1)
REGDEF_BIT(FD29, 1)
REGDEF_BIT(FD30, 1)
REGDEF_BIT(FD31, 1)
REGDEF_END(IDE_FD_EN)

#define IDE_FD_ATTR0_OFS        0xAD4
REGDEF_BEGIN(IDE_FD_ATTR0)
REGDEF_BIT(x, 12)
REGDEF_BIT(y, 12)
REGDEF_BIT(border_h, 8)
REGDEF_END(IDE_FD_ATTR0)

#define IDE_FD_ATTR1_OFS        0xAD8
REGDEF_BEGIN(IDE_FD_ATTR1)
REGDEF_BIT(w, 12)
REGDEF_BIT(h, 12)
REGDEF_BIT(border_v, 8)
REGDEF_END(IDE_FD_ATTR1)

#define IDE_FD_COLOR_OFS        0xADC
REGDEF_BEGIN(IDE_FD_COLOR)
REGDEF_BIT(y, 8)
REGDEF_BIT(cb, 8)
REGDEF_BIT(cr, 8)
REGDEF_BIT(, 8)
REGDEF_END(IDE_FD_COLOR)


#define IDE_LINE_EN_OFS         0xD5C
#define IDE_LINE_EN_NUM         16
REGDEF_BEGIN(IDE_LINE_EN)
REGDEF_BIT(LINE0, 1)
REGDEF_BIT(LINE1, 1)
REGDEF_BIT(LINE2, 1)
REGDEF_BIT(LINE3, 1)
REGDEF_BIT(LINE4, 1)
REGDEF_BIT(LINE5, 1)
REGDEF_BIT(LINE6, 1)
REGDEF_BIT(LINE7, 1)
REGDEF_BIT(LINE8, 1)
REGDEF_BIT(LINE9, 1)
REGDEF_BIT(LINE10, 1)
REGDEF_BIT(LINE11, 1)
REGDEF_BIT(LINE12, 1)
REGDEF_BIT(LINE13, 1)
REGDEF_BIT(LINE14, 1)
REGDEF_BIT(LINE15, 1)
REGDEF_BIT(, 16)
REGDEF_END(IDE_LINE_EN)

#define IDE_LINE_SET_REGION_OFFSET  0x24
#define IDE_EACH_LINE_REGION_OFFSET 0x8
#define IDE_LINE0_0_ATTR_OFS        0xD60
#define IDE_LINE0_1_ATTR_OFS        0xD68
#define IDE_LINE0_2_ATTR_OFS        0xD70
#define IDE_LINE0_3_ATTR_OFS        0xD78
REGDEF_BEGIN(IDE_LINE_ATTR)
REGDEF_BIT(LINE_X_A_PARAM, 14)
REGDEF_BIT(, 1)
REGDEF_BIT(LINE_X_A_PARAM_SIGN_BIT, 1)
REGDEF_BIT(LINE_X_B_PARAM, 14)
REGDEF_BIT(, 1)
REGDEF_BIT(LINE_X_B_PARAM_SIGN_BIT, 1)
REGDEF_END(IDE_LINE_ATTR)

#define IDE_LINE0_0_SLOPE_ATTR_OFS 0xD64
#define IDE_LINE0_1_SLOPE_ATTR_OFS 0xD6C
#define IDE_LINE0_2_SLOPE_ATTR_OFS 0xD74
#define IDE_LINE0_3_SLOPE_ATTR_OFS 0xD7C
REGDEF_BEGIN(IDE_LINE_SLOPE)
REGDEF_BIT(LINE_X_SLOPE_PARAM, 28)
REGDEF_BIT(, 2)
REGDEF_BIT(LINE_X_COMPARE, 2)
REGDEF_END(IDE_LINE_SLOPE)

#define IDE_LINE0_COLOR_OFS         0xD80
REGDEF_BEGIN(IDE_LINE_X_COLOR)
REGDEF_BIT(alpha, 8)
REGDEF_BIT(y, 8)
REGDEF_BIT(cb, 8)
REGDEF_BIT(cr, 8)
REGDEF_END(IDE_LINE_X_COLOR)

#define IDE_LINE_X_COLOR         0x24


#define IDE_PAL0_OFS            0x200
#define IDE_PAL1_OFS            0x3000
#define IDE_PAL_NUM             256
REGDEF_BEGIN(IDE_PAL)
REGDEF_BIT(cr, 8)
REGDEF_BIT(cb, 8)
REGDEF_BIT(y, 8)
REGDEF_BIT(alpha, 8)
REGDEF_END(IDE_PAL)

#define IDE_CURSOR_FONT_OFS			0x1000
REGDEF_BEGIN(IDE_CURSOR_FONT)
REGDEF_BIT(curfont, 32)
REGDEF_END(IDE_CURSOR_FONT)


#define TV_CTRL1_OFS            0x00
REGDEF_BEGIN(TV_CTRL1)
REGDEF_BIT(tv_mode, 3)
REGDEF_BIT(test_mode, 2)
REGDEF_BIT(burst_adj, 7)
REGDEF_BIT(, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(brl, 7)
REGDEF_BIT(ckpn_pol, 1)
REGDEF_BIT(bll, 8)
REGDEF_END(TV_CTRL1)

#define TV_CTRL2_OFS            0x04
REGDEF_BEGIN(TV_CTRL2)
REGDEF_BIT(low_level, 10)
REGDEF_BIT(, 2)
REGDEF_BIT(bypass_lpf, 1)
REGDEF_BIT(, 11)
REGDEF_BIT(ntsc_setup, 7)
REGDEF_BIT(tv_src, 1)
REGDEF_END(TV_CTRL2)

#define TV_CTRL3_OFS            0x08
REGDEF_BEGIN(TV_CTRL3)
REGDEF_BIT(scale_y, 8)
REGDEF_BIT(scale_cb, 8)
REGDEF_BIT(scale_cr, 8)
REGDEF_BIT(, 8)
REGDEF_END(TV_CTRL3)

#define TV_DAC_OFS              0x10
REGDEF_BEGIN(TV_DAC)
REGDEF_BIT(dac_pdall, 1)
REGDEF_BIT(dac_pd, 1)
REGDEF_BIT(, 2)
REGDEF_BIT(dac_trim_fs, 8)
REGDEF_BIT(, 20)
REGDEF_END(TV_DAC)

#define TV_DAC_FIX_OFS          0x14
REGDEF_BEGIN(TV_DAC_FIX)
REGDEF_BIT(dac_fix_value, 10)
REGDEF_BIT(, 22)
REGDEF_END(TV_DAC_FIX)

#define IDE_TV_CHROMA_TAP0_OFS  0x20
#define IDE_TV_CHROMA_TAP1_OFS  0x24
REGDEF_BEGIN(IDE_TVCHOMA_COEF)
REGDEF_BIT(coef0, 6)
REGDEF_BIT(, 2)
REGDEF_BIT(coef1, 6)
REGDEF_BIT(, 2)
REGDEF_BIT(coef2, 6)
REGDEF_BIT(, 2)
REGDEF_BIT(coef3, 6)
REGDEF_BIT(, 2)
REGDEF_END(IDE_TVCHOMA_COEF)

#define TV_Y_TAP0_OFS           0x30
#define TV_Y_TAP1_OFS           0x34
#define TV_Y_TAP2_OFS           0x38
REGDEF_BEGIN(IDE_TVY_COEF)
REGDEF_BIT(coef0, 8)
REGDEF_BIT(coef1, 8)
REGDEF_BIT(coef2, 8)
REGDEF_BIT(coef3, 8)
REGDEF_END(IDE_TVY_COEF)


//@}
//
//0x10 System Clock Rate Register
//
#define PLL_SYS_CR_REG_OFS              0x10
REGDEF_BEGIN(PLL_SYS_CR_REG)
REGDEF_BIT(DONTCARE, 32)
REGDEF_END(PLL_SYS_CR_REG)

REGDEF_BEGIN(PLL_PLL2_CR0_REG)
REGDEF_BIT(PLL_RATIO0, 8)
REGDEF_BIT(reserved1, 24)
REGDEF_END(PLL_PLL2_CR0_REG)

REGDEF_BEGIN(PLL_PLL2_CR1_REG)
REGDEF_BIT(PLL_RATIO1, 8)
REGDEF_BIT(reserved1, 24)
REGDEF_END(PLL_PLL2_CR1_REG)

REGDEF_BEGIN(PLL_PLL2_CR2_REG)
REGDEF_BIT(PLL_RATIO2, 8)
REGDEF_BIT(reserved1, 24)
REGDEF_END(PLL_PLL2_CR2_REG)
//
//0x68 ~ 0x6C Reserved Register
//

//
//0x70 Clock Enable Register 0
//
#define PLL_CLKEN0_REG_OFS              0x70
REGDEF_BEGIN(PLL_CLKEN0_REG)
REGDEF_BIT(DONTCARE, 32)
REGDEF_END(PLL_CLKEN0_REG)

#define PLL_STBC_BASE_OFFSET 0x00560000 // base address from 0xF0020000 to 0xF0580000

//
//0x00 PLL power enable Register
//
#define PLL_PLL_PWREN_REG_OFS           0x00+PLL_STBC_BASE_OFFSET
REGDEF_BEGIN(PLL_PLL_PWREN_REG)
REGDEF_BIT(DONTCARE, 32)
REGDEF_END(PLL_PLL_PWREN_REG)

//
//0x04 PLL Status Register
//
#define PLL_PLL_STATUS_REG_OFS          0x04+PLL_STBC_BASE_OFFSET
REGDEF_BEGIN(PLL_PLL_STATUS_REG)
REGDEF_BIT(DONTCARE, 32)
REGDEF_END(PLL_PLL_STATUS_REG)


#endif
