/*
    HDMI register header file

    HDMI register header file.

    @file       hdmitx_reg.h
    @ingroup    mIDrvDisp_HDMITx
    @note       Nothing.

    Copyright   Novatek Microelectronics Corp. 2014.  All rights reserved.
*/

#ifndef _HDMITX_REG_H
#define _HDMITX_REG_H

/*
    @addtogroup mIDrvDisp_HDMITx
*/
//@{

//
//  HDMI TX Module Registers
//

HDMIREGDEF_OFFSET(HDMI_SYSCTRL_REG, 0x00)
HDMIREGDEF_BEGIN(HDMI_SYSCTRL_REG)
HDMIREGDEF_BIT(TXD_RST, 1)
HDMIREGDEF_BIT(FIFORST, 1)
HDMIREGDEF_BIT(TXPHY_RST, 1)
HDMIREGDEF_BIT(, 1)
HDMIREGDEF_BIT(HDMI2, 1)
HDMIREGDEF_BIT(, 3)
HDMIREGDEF_BIT(HSYNC_GATING, 1)
HDMIREGDEF_BIT(VSYNC_GATING, 1)
HDMIREGDEF_BIT(VSYNC, 1)
HDMIREGDEF_BIT(, 1)
HDMIREGDEF_BIT(PIXCLK_STABLE, 1)
HDMIREGDEF_BIT(HPD, 1)
HDMIREGDEF_BIT(RSEN, 1)
HDMIREGDEF_BIT(, 1)
HDMIREGDEF_BIT(AUD_MUTE, 1)
HDMIREGDEF_BIT(, 3)
HDMIREGDEF_BIT(VD_INV, 1)
HDMIREGDEF_BIT(HD_INV, 1)
HDMIREGDEF_BIT(, 2)
HDMIREGDEF_BIT(COMP0_SEL, 2)
HDMIREGDEF_BIT(COMP1_SEL, 2)
HDMIREGDEF_BIT(COMP2_SEL, 2)
HDMIREGDEF_BIT(, 1)
HDMIREGDEF_BIT(SRC_SEL, 1)
HDMIREGDEF_END(HDMI_SYSCTRL_REG)

HDMIREGDEF_OFFSET(HDMI_DEBUG_REG, 0x0C)
HDMIREGDEF_BEGIN(HDMI_DEBUG_REG)
HDMIREGDEF_BIT(CP_RESTN, 1)
HDMIREGDEF_BIT(, 3)
HDMIREGDEF_BIT(, 1)
HDMIREGDEF_BIT(, 8)
HDMIREGDEF_BIT(SIL9002_PD, 1)
HDMIREGDEF_BIT(SIL9002_ISEL, 1)
HDMIREGDEF_BIT(SIL9002_CLKINV, 1)
HDMIREGDEF_BIT(DBG_SEL, 8)
HDMIREGDEF_BIT(DC_HEADER, 8)
HDMIREGDEF_END(HDMI_DEBUG_REG)

HDMIREGDEF_OFFSET(HDMI_INTSTS_REG, 0x20)
HDMIREGDEF_BEGIN(HDMI_INTSTS_REG)
HDMIREGDEF_BIT(OVRUN_STS, 1)
HDMIREGDEF_BIT(RSEN_STS, 1)
HDMIREGDEF_BIT(HPD_CHG_STS, 1)
HDMIREGDEF_BIT(VSYNC_STS, 1)
HDMIREGDEF_BIT(PIXLK_STBL_STS, 1)
HDMIREGDEF_BIT(ACR_OVR_STS, 1)
HDMIREGDEF_BIT(CTS_CHG_STS, 1)
HDMIREGDEF_BIT(GCP_CHG_MUTE_STS, 1)
HDMIREGDEF_BIT(, 12)
HDMIREGDEF_BIT(CEC_RX_FRM_STS, 1)
HDMIREGDEF_BIT(CEC_RXPOLLING_STS, 1)
HDMIREGDEF_BIT(CEC_TX_FRM_STS, 1)
HDMIREGDEF_BIT(CEC_TX_RETRY_STS, 1)
HDMIREGDEF_BIT(CEC_TX_AL_STS, 1)
HDMIREGDEF_BIT(CEC_RX_TIMEOUT_STS, 1)
HDMIREGDEF_BIT(CEC_ERROR_STS, 1)
HDMIREGDEF_BIT(, 5)
HDMIREGDEF_END(HDMI_INTSTS_REG)

HDMIREGDEF_OFFSET(HDMI_INTEN_REG, 0x24)
HDMIREGDEF_BEGIN(HDMI_INTEN_REG)
HDMIREGDEF_BIT(OVRUN_EN, 1)
HDMIREGDEF_BIT(RSEN_EN, 1)
HDMIREGDEF_BIT(HPD_CHG_EN, 1)
HDMIREGDEF_BIT(VSYNC_EN, 1)
HDMIREGDEF_BIT(PIXLK_STBL_EN, 1)
HDMIREGDEF_BIT(ACR_OVR_EN, 1)
HDMIREGDEF_BIT(CTS_CHG_EN, 1)
HDMIREGDEF_BIT(GCP_CHG_MUTE_EN, 1)
HDMIREGDEF_BIT(, 12)
HDMIREGDEF_BIT(CEC_RX_FRM_EN, 1)
HDMIREGDEF_BIT(CEC_RXPOLLING_EN, 1)
HDMIREGDEF_BIT(CEC_TX_FRM_EN, 1)
HDMIREGDEF_BIT(CEC_TX_RETRY_EN, 1)
HDMIREGDEF_BIT(CEC_TX_AL_EN, 1)
HDMIREGDEF_BIT(CEC_RX_TIMEOUT_EN, 1)
HDMIREGDEF_BIT(CEC_ERROR_EN, 1)
HDMIREGDEF_BIT(, 5)
HDMIREGDEF_END(HDMI_INTEN_REG)

HDMIREGDEF_OFFSET(HDMI_TMDSCTRL0_REG, 0x28)
HDMIREGDEF_BEGIN(HDMI_TMDSCTRL0_REG)
HDMIREGDEF_BIT(, 1)
HDMIREGDEF_BIT(, 7)
HDMIREGDEF_BIT(CLKDETECT_STS, 1)
HDMIREGDEF_BIT(, 7)
HDMIREGDEF_BIT(, 1)
HDMIREGDEF_BIT(, 1)
HDMIREGDEF_BIT(, 3)
HDMIREGDEF_BIT(, 2)
HDMIREGDEF_BIT(, 9)
HDMIREGDEF_END(HDMI_TMDSCTRL0_REG)

HDMIREGDEF_OFFSET(HDMI_TMDSCTRL1_REG, 0x2C)
HDMIREGDEF_BEGIN(HDMI_TMDSCTRL1_REG)
HDMIREGDEF_BIT(, 16)
HDMIREGDEF_BIT(SAFE_START, 9)
HDMIREGDEF_BIT(, 7)
HDMIREGDEF_END(HDMI_TMDSCTRL1_REG)

HDMIREGDEF_OFFSET(HDMI_PG0_REG, 0x30)
HDMIREGDEF_BEGIN(HDMI_PG0_REG)
HDMIREGDEF_BIT(EN, 1)
HDMIREGDEF_BIT(PIXGEN_EN, 1)
HDMIREGDEF_BIT(SYNCGEN_EN, 1)
HDMIREGDEF_BIT(UPDATE, 1)
HDMIREGDEF_BIT(PR_CNT, 2)
HDMIREGDEF_BIT(, 1)
HDMIREGDEF_BIT(VBUF_EN, 1)
HDMIREGDEF_BIT(PG_TYPE, 5)
HDMIREGDEF_BIT(, 2)
HDMIREGDEF_BIT(CBAR_EN, 1)
HDMIREGDEF_BIT(DEPTH_TYPE, 2)
HDMIREGDEF_BIT(, 14)
HDMIREGDEF_END(HDMI_PG0_REG)

HDMIREGDEF_OFFSET(HDMI_PG1_REG, 0x34)
HDMIREGDEF_BEGIN(HDMI_PG1_REG)
HDMIREGDEF_BIT(GRAY, 10)
HDMIREGDEF_BIT(, 6)
HDMIREGDEF_BIT(SG_HTOT, 16)
HDMIREGDEF_END(HDMI_PG1_REG)

HDMIREGDEF_OFFSET(HDMI_PG2_REG, 0x38)
HDMIREGDEF_BEGIN(HDMI_PG2_REG)
HDMIREGDEF_BIT(SG_HSW, 16)
HDMIREGDEF_BIT(SG_HAB, 16)
HDMIREGDEF_END(HDMI_PG2_REG)

HDMIREGDEF_OFFSET(HDMI_PG3_REG, 0x3C)
HDMIREGDEF_BEGIN(HDMI_PG3_REG)
HDMIREGDEF_BIT(SG_HAW, 16)
HDMIREGDEF_BIT(SG_VTOT, 16)
HDMIREGDEF_END(HDMI_PG3_REG)

HDMIREGDEF_OFFSET(HDMI_PG4_REG, 0x40)
HDMIREGDEF_BEGIN(HDMI_PG4_REG)
HDMIREGDEF_BIT(SG_VSW, 16)
HDMIREGDEF_BIT(SG_VAB, 16)
HDMIREGDEF_END(HDMI_PG4_REG)

HDMIREGDEF_OFFSET(HDMI_PG5_REG, 0x44)
HDMIREGDEF_BEGIN(HDMI_PG5_REG)
HDMIREGDEF_BIT(SG_VAW, 16)
HDMIREGDEF_BIT(, 16)
HDMIREGDEF_END(HDMI_PG5_REG)



HDMIREGDEF_OFFSET(HDMI_AUDCTRL_REG, 0x70)
HDMIREGDEF_BEGIN(HDMI_AUDCTRL_REG)
HDMIREGDEF_BIT(CTS_SEL, 1)
HDMIREGDEF_BIT(NCTSPKT_EN, 1)
HDMIREGDEF_BIT(, 2)
HDMIREGDEF_BIT(AUD_EN, 1)
HDMIREGDEF_BIT(, 3)
HDMIREGDEF_BIT(N_SVAL, 20)
HDMIREGDEF_BIT(, 4)
HDMIREGDEF_END(HDMI_AUDCTRL_REG)

HDMIREGDEF_OFFSET(HDMI_SWCTS_REG, 0x74)
HDMIREGDEF_BEGIN(HDMI_SWCTS_REG)
HDMIREGDEF_BIT(CTS_SVAL, 20)
HDMIREGDEF_BIT(, 12)
HDMIREGDEF_END(HDMI_SWCTS_REG)

HDMIREGDEF_OFFSET(HDMI_HWCTS_REG, 0x78)
HDMIREGDEF_BEGIN(HDMI_HWCTS_REG)
HDMIREGDEF_BIT(CTS_HVAL, 20)
HDMIREGDEF_BIT(, 12)
HDMIREGDEF_END(HDMI_HWCTS_REG)

HDMIREGDEF_OFFSET(HDMI_PCMHDR0_REG, 0x80)
HDMIREGDEF_BEGIN(HDMI_PCMHDR0_REG)
HDMIREGDEF_BIT(SEL, 1)
HDMIREGDEF_BIT(PCM, 1)
HDMIREGDEF_BIT(COPYRIGHT, 1)
HDMIREGDEF_BIT(INFO, 3)
HDMIREGDEF_BIT(MODE, 2)
HDMIREGDEF_BIT(CATEGORY, 8)
HDMIREGDEF_BIT(SRCNUM, 4)
HDMIREGDEF_BIT(CANNUM, 4)
HDMIREGDEF_BIT(FS, 4)
HDMIREGDEF_BIT(CLKACCUR, 4)
HDMIREGDEF_END(HDMI_PCMHDR0_REG)

HDMIREGDEF_OFFSET(HDMI_PCMHDR1_REG, 0x84)
HDMIREGDEF_BEGIN(HDMI_PCMHDR1_REG)
HDMIREGDEF_BIT(MAXLEN, 1)
HDMIREGDEF_BIT(WORDLEN, 3)
HDMIREGDEF_BIT(FS_ORIG, 4)
HDMIREGDEF_BIT(, 24)
HDMIREGDEF_END(HDMI_PCMHDR1_REG)

HDMIREGDEF_OFFSET(HDMI_CTRL_REG, 0x88)
HDMIREGDEF_BEGIN(HDMI_CTRL_REG)
HDMIREGDEF_BIT(HDMI_MODE, 1)
HDMIREGDEF_BIT(, 2)
HDMIREGDEF_BIT(PKT_MODE, 3)
HDMIREGDEF_BIT(DC_EN, 1)
HDMIREGDEF_BIT(, 1)
HDMIREGDEF_BIT(NULLPKT_EN, 1)
HDMIREGDEF_BIT(NULLPKT_VS_EN, 1)
HDMIREGDEF_BIT(GCP_MUTE_STS, 1)
HDMIREGDEF_BIT(, 5)
HDMIREGDEF_BIT(AUD_FIFO_CNT, 5)
HDMIREGDEF_BIT(, 11)
HDMIREGDEF_END(HDMI_CTRL_REG)

//HDMIREGDEF_OFFSET(HDMI_POWDOWN_REG      ,0x8C)
//HDMIREGDEF_BEGIN(HDMI_POWDOWN_REG)
//    HDMIREGDEF_BIT(                 ,16)
//    HDMIREGDEF_BIT(PD               ,1)
//    HDMIREGDEF_BIT(PDOSC            ,1)
//    HDMIREGDEF_BIT(                 ,14)
//HDMIREGDEF_END(HDMI_POWDOWN_REG)

HDMIREGDEF_OFFSET(HDMI_PKTCTRL_REG, 0x90)
HDMIREGDEF_BEGIN(HDMI_PKTCTRL_REG)
HDMIREGDEF_BIT(AVIINFO_RPT, 1)
HDMIREGDEF_BIT(AVIINFO_EN, 1)
HDMIREGDEF_BIT(, 2)
HDMIREGDEF_BIT(AUDINFO_RPT, 1)
HDMIREGDEF_BIT(AUDINFO_EN, 1)
HDMIREGDEF_BIT(, 2)
HDMIREGDEF_BIT(GENINFO_RPT, 1)
HDMIREGDEF_BIT(GENINFO_EN, 1)
HDMIREGDEF_BIT(GCP_RPT, 1)
HDMIREGDEF_BIT(GCP_EN, 1)
HDMIREGDEF_BIT(GEN2INFO_RPT, 1)
HDMIREGDEF_BIT(GEN2INFO_EN, 1)
HDMIREGDEF_BIT(, 18)
HDMIREGDEF_END(HDMI_PKTCTRL_REG)


HDMIREGDEF_OFFSET(HDMI_AVIINFO_REG, 0x100)
HDMIREGDEF_OFFSET(HDMI_AUDINFO_REG, 0x140)
HDMIREGDEF_OFFSET(HDMI_GENINFO_REG, 0x170)
HDMIREGDEF_OFFSET(HDMI_GEN2INFO_REG, 0x190)


HDMIREGDEF_OFFSET(HDMI_INFO0_REG, 0x00)
HDMIREGDEF_BEGIN(HDMI_INFO0_REG)
HDMIREGDEF_BIT(TYPE, 8)
HDMIREGDEF_BIT(VERS, 8)
HDMIREGDEF_BIT(LEN, 8)
HDMIREGDEF_BIT(CHSUM, 8)
HDMIREGDEF_END(HDMI_INFO0_REG)

HDMIREGDEF_OFFSET(HDMI_INFO1_REG, 0x04)
HDMIREGDEF_BEGIN(HDMI_INFO1_REG)
HDMIREGDEF_BIT(BYTE1, 8)
HDMIREGDEF_BIT(BYTE2, 8)
HDMIREGDEF_BIT(BYTE3, 8)
HDMIREGDEF_BIT(BYTE4, 8)
HDMIREGDEF_END(HDMI_INFO1_REG)

HDMIREGDEF_OFFSET(HDMI_INFO2_REG, 0x08)
HDMIREGDEF_BEGIN(HDMI_INFO2_REG)
HDMIREGDEF_BIT(BYTE5, 8)
HDMIREGDEF_BIT(BYTE6, 8)
HDMIREGDEF_BIT(BYTE7, 8)
HDMIREGDEF_BIT(BYTE8, 8)
HDMIREGDEF_END(HDMI_INFO2_REG)

HDMIREGDEF_OFFSET(HDMI_INFO3_REG, 0x0C)
HDMIREGDEF_BEGIN(HDMI_INFO3_REG)
HDMIREGDEF_BIT(BYTE9, 8)
HDMIREGDEF_BIT(BYTE10, 8)
HDMIREGDEF_BIT(BYTE11, 8)
HDMIREGDEF_BIT(BYTE12, 8)
HDMIREGDEF_END(HDMI_INFO3_REG)

HDMIREGDEF_OFFSET(HDMI_INFO4_REG, 0x10)
HDMIREGDEF_BEGIN(HDMI_INFO4_REG)
HDMIREGDEF_BIT(BYTE13, 8)
HDMIREGDEF_BIT(BYTE14, 8)
HDMIREGDEF_BIT(BYTE15, 8)
HDMIREGDEF_BIT(BYTE16, 8)
HDMIREGDEF_END(HDMI_INFO4_REG)

HDMIREGDEF_OFFSET(HDMI_INFO5_REG, 0x14)
HDMIREGDEF_BEGIN(HDMI_INFO5_REG)
HDMIREGDEF_BIT(BYTE17, 8)
HDMIREGDEF_BIT(BYTE18, 8)
HDMIREGDEF_BIT(BYTE19, 8)
HDMIREGDEF_BIT(BYTE20, 8)
HDMIREGDEF_END(HDMI_INFO5_REG)

HDMIREGDEF_OFFSET(HDMI_INFO6_REG, 0x18)
HDMIREGDEF_BEGIN(HDMI_INFO6_REG)
HDMIREGDEF_BIT(BYTE21, 8)
HDMIREGDEF_BIT(BYTE22, 8)
HDMIREGDEF_BIT(BYTE23, 8)
HDMIREGDEF_BIT(BYTE24, 8)
HDMIREGDEF_END(HDMI_INFO6_REG)

HDMIREGDEF_OFFSET(HDMI_INFO7_REG, 0x1C)
HDMIREGDEF_BEGIN(HDMI_INFO7_REG)
HDMIREGDEF_BIT(BYTE25, 8)
HDMIREGDEF_BIT(BYTE26, 8)
HDMIREGDEF_BIT(BYTE27, 8)
HDMIREGDEF_BIT(, 8)
HDMIREGDEF_END(HDMI_INFO7_REG)


HDMIREGDEF_OFFSET(HDMI_GENCTRL_REG, 0x1B0)
HDMIREGDEF_BEGIN(HDMI_GENCTRL_REG)
HDMIREGDEF_BIT(SETAVM, 1)
HDMIREGDEF_BIT(, 3)
HDMIREGDEF_BIT(CLRAVM, 1)
HDMIREGDEF_BIT(, 27)
HDMIREGDEF_END(HDMI_GENCTRL_REG)


//
//  Analog Block (IP) Register Bank
//

HDMIREGDEF_OFFSET(HDMI_PHYBASE_REG, 0x200)


// TXPHY REG 0x06
/*HDMIREGDEF_OFFSET(HDMI_TTXCFG06_REG      ,0x218)
HDMIREGDEF_BEGIN(HDMI_TTXCFG06_REG)
    HDMIREGDEF_BIT(REG_PDB          ,1)
    HDMIREGDEF_BIT(REG_OSCLK_EN     ,1)
    HDMIREGDEF_BIT(REG_OE           ,1)
    HDMIREGDEF_BIT(REG_NOOSCLKOUT   ,1)
    HDMIREGDEF_BIT(REG_HALFCLKEN    ,1)
    HDMIREGDEF_BIT(REG_CLKDETECT    ,1)
    HDMIREGDEF_BIT(REG_CKSWCTL      ,1)
    HDMIREGDEF_BIT(REG_BGR_TEST     ,1)
    HDMIREGDEF_BIT(                 ,24)
HDMIREGDEF_END(HDMI_TTXCFG06_REG)*/

// TXPHY REG 0x09
/*HDMIREGDEF_OFFSET(HDMI_TTXCFG09_REG      ,0x224)
HDMIREGDEF_BEGIN(HDMI_TTXCFG09_REG)
    HDMIREGDEF_BIT(REG_PDB_M        ,1)
    HDMIREGDEF_BIT(REG_OSCLK_EN_M   ,1)
    HDMIREGDEF_BIT(REG_OE_M         ,1)
    HDMIREGDEF_BIT(REG_NOOSCLKOUT_M ,1)
    HDMIREGDEF_BIT(REG_HALFCLKEN_M  ,1)
    HDMIREGDEF_BIT(REG_CLKDETECT_M  ,1)
    HDMIREGDEF_BIT(REG_CKSWCTL_M    ,1)
    HDMIREGDEF_BIT(REG_BGR_TEST_M   ,1)
    HDMIREGDEF_BIT(                 ,24)
HDMIREGDEF_END(HDMI_TTXCFG09_REG)*/

// TXPHY REG 0x0A
/*HDMIREGDEF_OFFSET(HDMI_TTXCFG0A_REG      ,0x228)
HDMIREGDEF_BEGIN(HDMI_TTXCFG0A_REG)
    HDMIREGDEF_BIT(                 ,3)
    HDMIREGDEF_BIT(REG_PD           ,1)
    HDMIREGDEF_BIT(                 ,28)
HDMIREGDEF_END(HDMI_TTXCFG0A_REG)*/

//HDMIREGDEF_OFFSET(HDMI_TTXCFG0D_REG      ,0x230)


// TXPHY REG 0x34
/*HDMIREGDEF_OFFSET(HDMI_TTXCFG34_REG      ,0x2D0)
HDMIREGDEF_BEGIN(HDMI_TTXCFG34_REG)
    HDMIREGDEF_BIT(TRIM_TRIG            ,1)
    HDMIREGDEF_BIT(TRIM_DONE_FLAG       ,1)
    HDMIREGDEF_BIT(TRIM_ERR_FLAG        ,1)
    HDMIREGDEF_BIT(REG_FT_RTRIM_EN      ,1)
    HDMIREGDEF_BIT(REG_FT_RTRIM_EXT_EN  ,1)
    HDMIREGDEF_BIT(REG_FT_RTRIM_OP_EN   ,1)
    HDMIREGDEF_BIT(REG_RESTRIM_EN       ,1)
    HDMIREGDEF_BIT(REG_RESTRIM_CLK_EN   ,1)
    HDMIREGDEF_BIT(                     ,24)
HDMIREGDEF_END(HDMI_TTXCFG34_REG)*/

// TXPHY REG 0x35
/*HDMIREGDEF_OFFSET(HDMI_TTXCFG35_REG      ,0x2D4)
HDMIREGDEF_BEGIN(HDMI_TTXCFG35_REG)
    HDMIREGDEF_BIT(TRIM_RSEL        ,5)
    HDMIREGDEF_BIT(TRIM_CMP_OUT     ,1)
    HDMIREGDEF_BIT(                 ,26)
HDMIREGDEF_END(HDMI_TTXCFG35_REG)*/

// TXPHY REG 0x38
/*HDMIREGDEF_OFFSET(HDMI_TTXCFG38_REG      ,0x2E0)
HDMIREGDEF_BEGIN(HDMI_TTXCFG38_REG)
    HDMIREGDEF_BIT(TRIM_MAN_RSEL_SET,1)
    HDMIREGDEF_BIT(TRIM_MAN_RSEL    ,5)
    HDMIREGDEF_BIT(                 ,26)
HDMIREGDEF_END(HDMI_TTXCFG38_REG)*/




//
//  CEC Register Bank
//

HDMIREGDEF_OFFSET(CEC_CTRL_REG, 0x00)
HDMIREGDEF_BEGIN(CEC_CTRL_REG)
HDMIREGDEF_BIT(EN, 1)
HDMIREGDEF_BIT(, 3)
HDMIREGDEF_BIT(LOCAL_ADDR, 4)
HDMIREGDEF_BIT(, 8)
HDMIREGDEF_BIT(FREECNT_1, 4)
HDMIREGDEF_BIT(FREECNT_2, 4)
HDMIREGDEF_BIT(FREECNT_3, 4)
HDMIREGDEF_BIT(TX_RETRY, 4)
HDMIREGDEF_END(CEC_CTRL_REG)

HDMIREGDEF_OFFSET(CEC_TXTIME0_REG, 0x04)
HDMIREGDEF_BEGIN(CEC_TXTIME0_REG)
HDMIREGDEF_BIT(TX_RISE_OFS, 8)
HDMIREGDEF_BIT(TX_FALL_OFS, 8)
HDMIREGDEF_BIT(, 16)
HDMIREGDEF_END(CEC_TXTIME0_REG)

HDMIREGDEF_OFFSET(CEC_RXTIME0_REG, 0x08)
HDMIREGDEF_BEGIN(CEC_RXTIME0_REG)
HDMIREGDEF_BIT(RX_START_OFS, 8)
HDMIREGDEF_BIT(RX_DATARISE_OFS, 8)
HDMIREGDEF_BIT(RX_SMP_OFS, 8)
HDMIREGDEF_BIT(DE_GLITCH, 4)
HDMIREGDEF_BIT(, 4)
HDMIREGDEF_END(CEC_RXTIME0_REG)

HDMIREGDEF_OFFSET(CEC_RXTIME1_REG, 0x0C)
HDMIREGDEF_BEGIN(CEC_RXTIME1_REG)
HDMIREGDEF_BIT(RX_ERR_LOW, 9)
HDMIREGDEF_BIT(, 7)
HDMIREGDEF_BIT(RX_DATAFALL_OFS, 8)
HDMIREGDEF_BIT(, 8)
HDMIREGDEF_END(CEC_RXTIME1_REG)

HDMIREGDEF_OFFSET(CEC_FRMSIZE_REG, 0x18)
HDMIREGDEF_BEGIN(CEC_FRMSIZE_REG)
HDMIREGDEF_BIT(RX_LENGTH, 5)
HDMIREGDEF_BIT(, 3)
HDMIREGDEF_BIT(TX_LENGTH, 4)
HDMIREGDEF_BIT(, 4)
HDMIREGDEF_BIT(NACK_CTRL, 1)
HDMIREGDEF_BIT(, 15)
HDMIREGDEF_END(CEC_FRMSIZE_REG)

HDMIREGDEF_OFFSET(CEC_TXTRIG_REG, 0x1C)
HDMIREGDEF_BEGIN(CEC_TXTRIG_REG)
HDMIREGDEF_BIT(TX_TRIG, 1)
HDMIREGDEF_BIT(, 11)
HDMIREGDEF_BIT(ARBI_RANGE, 4)
HDMIREGDEF_BIT(, 16)
HDMIREGDEF_END(CEC_TXTRIG_REG)

HDMIREGDEF_OFFSET(CEC_TXHDR_REG, 0x20)
HDMIREGDEF_BEGIN(CEC_TXHDR_REG)
HDMIREGDEF_BIT(TX_DEST_ADDR, 4)
HDMIREGDEF_BIT(TX_SRC_ADDR, 4)
HDMIREGDEF_BIT(, 24)
HDMIREGDEF_END(CEC_TXHDR_REG)


HDMIREGDEF_OFFSET(CEC_TXDATA0_REG, 0x24)
HDMIREGDEF_OFFSET(CEC_TXDATA1_REG, 0x28)
HDMIREGDEF_OFFSET(CEC_TXDATA2_REG, 0x2C)
HDMIREGDEF_OFFSET(CEC_TXDATA3_REG, 0x30)


HDMIREGDEF_OFFSET(CEC_RXHDR_REG, 0x40)
HDMIREGDEF_BEGIN(CEC_RXHDR_REG)
HDMIREGDEF_BIT(RX_DEST_ADDR, 4)
HDMIREGDEF_BIT(RX_SRC_ADDR, 4)
HDMIREGDEF_BIT(, 24)
HDMIREGDEF_END(CEC_RXHDR_REG)


HDMIREGDEF_OFFSET(CEC_RXDATA0_REG, 0x44)
HDMIREGDEF_OFFSET(CEC_RXDATA1_REG, 0x48)
HDMIREGDEF_OFFSET(CEC_RXDATA2_REG, 0x4C)
HDMIREGDEF_OFFSET(CEC_RXDATA3_REG, 0x50)

HDMIREGDEF_OFFSET(HDMI_TOP_REG, 0x500)
HDMIREGDEF_BEGIN(HDMI_TOP_REG)
HDMIREGDEF_BIT(LCD_SRC_SEL, 2)
HDMIREGDEF_BIT(PCLK_POLAR_SEL, 1)
HDMIREGDEF_BIT(, 29)
HDMIREGDEF_END(HDMI_TOP_REG)
//@}

#endif
