/*
    Register offset and bit definition for LCD module

    Register offset and bit definition for LCD module.

    @file       lcd310_reg.h
    @ingroup    miDrvTimer_LCD
    @note       Nothing.

    Copyright   Novatek Microelectronics Corp. 2011.  All rights reserved.
*/

#ifndef __LCD_REG_H__
#define __LCD_REG_H__

#include "ide_platform.h"


#define IDE_PAL_NUM             256

/*
    @addtogroup miDrvTimer_LCD
*/
//@{
REGDEF_OFFSET(LCD_FUNC_REG, 0x00)
REGDEF_BEGIN(LCD_FUNC_REG)
REGDEF_BIT(, 29)
REGDEF_BIT(sys_idle, 1)
REGDEF_BIT(lost_update, 1)
REGDEF_BIT(update, 1)
REGDEF_END(LCD_FUNC_REG)

REGDEF_OFFSET(LCD_BG_PARM00_REG, 0x04)
REGDEF_BEGIN(LCD_BG_PARM00_REG)
REGDEF_BIT(bg_hs, 16)
REGDEF_BIT(bg_vs, 16)
REGDEF_END(LCD_BG_PARM00_REG)

REGDEF_OFFSET(LCD_BG_PARM01_REG, 0x08)
REGDEF_BEGIN(LCD_BG_PARM01_REG)
REGDEF_BIT(bg_y, 8)
REGDEF_BIT(, 24)
REGDEF_END(LCD_BG_PARM01_REG)

REGDEF_OFFSET(LCD_BG_PARM02_REG, 0x0C)
REGDEF_BEGIN(LCD_BG_PARM02_REG)
REGDEF_BIT(bg_cr, 8)
REGDEF_BIT(, 8)
REGDEF_BIT(bg_cb, 8)
REGDEF_BIT(, 8)
REGDEF_END(LCD_BG_PARM02_REG)


REGDEF_OFFSET(LCD_CH0_SRC_PARM00_REG, 0x10)
REGDEF_OFFSET(LCD_CH1_SRC_PARM10_REG, 0x38)
REGDEF_OFFSET(LCD_CH2_SRC_PARM20_REG, 0x60)
REGDEF_BEGIN(LCD_CH0_SRC_PARM00_REG)
REGDEF_BIT(y_ba, 32)
REGDEF_END(LCD_CH0_SRC_PARM00_REG)

REGDEF_OFFSET(LCD_CH0_SRC_PARM01_REG, 0x14)
REGDEF_OFFSET(LCD_CH1_SRC_PARM11_REG, 0x3C)
REGDEF_OFFSET(LCD_CH2_SRC_PARM21_REG, 0x64)
REGDEF_BEGIN(LCD_CH0_SRC_PARM01_REG)
REGDEF_BIT(cbr_ba, 32)
REGDEF_END(LCD_CH0_SRC_PARM01_REG)

REGDEF_OFFSET(LCD_CH0_SRC_PARM02_REG, 0x18)
REGDEF_OFFSET(LCD_CH1_SRC_PARM12_REG, 0x40)
REGDEF_OFFSET(LCD_CH2_SRC_PARM22_REG, 0x68)
REGDEF_BEGIN(LCD_CH0_SRC_PARM02_REG)
REGDEF_BIT(hs, 16)
REGDEF_BIT(vs, 16)
REGDEF_END(LCD_CH0_SRC_PARM02_REG)

REGDEF_OFFSET(LCD_CH0_SRC_PARM03_REG, 0x1C)
REGDEF_OFFSET(LCD_CH1_SRC_PARM13_REG, 0x44)
REGDEF_OFFSET(LCD_CH2_SRC_PARM23_REG, 0x6C)
REGDEF_BEGIN(LCD_CH0_SRC_PARM03_REG)
REGDEF_BIT(y_xy, 32)
REGDEF_END(LCD_CH0_SRC_PARM03_REG)

REGDEF_OFFSET(LCD_CH0_SRC_PARM04_REG, 0x20)
REGDEF_OFFSET(LCD_CH1_SRC_PARM14_REG, 0x48)
REGDEF_OFFSET(LCD_CH2_SRC_PARM24_REG, 0x70)
REGDEF_BEGIN(LCD_CH0_SRC_PARM04_REG)
REGDEF_BIT(cbr_xy, 32)
REGDEF_END(LCD_CH0_SRC_PARM04_REG)

REGDEF_OFFSET(LCD_CH0_SRC_PARM05_REG, 0x24)
REGDEF_OFFSET(LCD_CH1_SRC_PARM15_REG, 0x4C)
REGDEF_OFFSET(LCD_CH2_SRC_PARM25_REG, 0x74)
REGDEF_BEGIN(LCD_CH0_SRC_PARM05_REG)
REGDEF_BIT(y_line_offset, 32)
REGDEF_END(LCD_CH0_SRC_PARM05_REG)

REGDEF_OFFSET(LCD_CH0_SRC_PARM06_REG, 0x28)
REGDEF_OFFSET(LCD_CH1_SRC_PARM16_REG, 0x50)
REGDEF_OFFSET(LCD_CH2_SRC_PARM26_REG, 0x78)
REGDEF_BEGIN(LCD_CH0_SRC_PARM06_REG)
REGDEF_BIT(cbr_line_offset, 32)
REGDEF_END(LCD_CH0_SRC_PARM06_REG)

REGDEF_OFFSET(LCD_CH0_SRC_PARM07_REG, 0x2C)
REGDEF_OFFSET(LCD_CH1_SRC_PARM17_REG, 0x54)
REGDEF_OFFSET(LCD_CH2_SRC_PARM27_REG, 0x7C)
REGDEF_BEGIN(LCD_CH0_SRC_PARM07_REG)
REGDEF_BIT(sc_hs, 16)
REGDEF_BIT(sc_vs, 16)
REGDEF_END(LCD_CH0_SRC_PARM07_REG)

REGDEF_OFFSET(LCD_CH0_SRC_PARM08_REG, 0x30)
REGDEF_OFFSET(LCD_CH1_SRC_PARM18_REG, 0x58)
REGDEF_OFFSET(LCD_CH2_SRC_PARM28_REG, 0x80)
REGDEF_BEGIN(LCD_CH0_SRC_PARM08_REG)
REGDEF_BIT(, 8)
REGDEF_BIT(galpha, 8)
REGDEF_BIT(alpha0, 8)
REGDEF_BIT(alpha1, 8)
REGDEF_END(LCD_CH0_SRC_PARM08_REG)

REGDEF_OFFSET(LCD_CH0_SRC_PARM09_REG, 0x34)
REGDEF_OFFSET(LCD_CH1_SRC_PARM19_REG, 0x5C)
REGDEF_OFFSET(LCD_CH2_SRC_PARM29_REG, 0x84)
REGDEF_BEGIN(LCD_CH0_SRC_PARM09_REG)
REGDEF_BIT(fmt, 4)
REGDEF_BIT(, 12)
REGDEF_BIT(mode, 2)
REGDEF_BIT(rld_len, 2)
REGDEF_BIT(rld_cnt, 3)
REGDEF_BIT(trans444_mode, 1)
REGDEF_BIT(l2r, 1)
REGDEF_BIT(t2b, 1)
REGDEF_BIT(mg_fmt, 2)
REGDEF_BIT(mg_en, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(ch_swap, 1)
REGDEF_BIT(ch_en, 1)
REGDEF_END(LCD_CH0_SRC_PARM09_REG)

REGDEF_OFFSET(LCD_CH0_SRC_HADDR_REG, 0x88)
REGDEF_OFFSET(LCD_CH1_SRC_HADDR_REG, 0x90)
REGDEF_OFFSET(LCD_CH2_SRC_HADDR_REG, 0x98)
REGDEF_BEGIN(LCD_CH0_SRC_HADDR_REG)
REGDEF_BIT(y_ba_high, 4)
REGDEF_BIT(, 28)
REGDEF_END(LCD_CH0_SRC_HADDR_REG)

REGDEF_OFFSET(LCD_CH0_SRC_HADDR1_REG, 0x8C)
REGDEF_OFFSET(LCD_CH1_SRC_HADDR1_REG, 0x94)
REGDEF_OFFSET(LCD_CH2_SRC_HADDR1_REG, 0x9C)
REGDEF_BEGIN(LCD_CH0_SRC_HADDR1_REG)
REGDEF_BIT(cbr_ba_high, 4)
REGDEF_BIT(, 28)
REGDEF_END(LCD_CH0_SRC_HADDR1_REG)

REGDEF_OFFSET(LCD_CH0_CSC_PARM00_REG, 0xB0)
REGDEF_OFFSET(LCD_CH1_CSC_PARM10_REG, 0xD8)
REGDEF_OFFSET(LCD_CH2_CSC_PARM20_REG, 0x100)
REGDEF_OFFSET(LCD_CURSOR_CSC_PARM0_REG, 0x710)
REGDEF_OFFSET(LCD_CSC1_PARM0_REG, 0xA00)
REGDEF_OFFSET(LCD_CSC2_PARM0_REG, 0xA40)
REGDEF_OFFSET(LCD_CSC3_PARM0_REG, 0xA80)
REGDEF_BEGIN(LCD_CSC_PARM00_REG)
REGDEF_BIT(csc_in_offset0, 16)
REGDEF_BIT(csc_in_offset1, 16)
REGDEF_END(LCD_CSC_PARM00_REG)

REGDEF_OFFSET(LCD_CH0_CSC_PARM01_REG, 0xB4)
REGDEF_OFFSET(LCD_CH1_CSC_PARM11_REG, 0xDC)
REGDEF_OFFSET(LCD_CH2_CSC_PARM21_REG, 0x104)
REGDEF_OFFSET(LCD_CURSOR_CSC_PARM1_REG, 0x714)
REGDEF_OFFSET(LCD_CSC1_PARM1_REG, 0xA04)
REGDEF_OFFSET(LCD_CSC2_PARM1_REG, 0xA44)
REGDEF_OFFSET(LCD_CSC3_PARM1_REG, 0xA84)
REGDEF_BEGIN(LCD_CSC_PARM01_REG)
REGDEF_BIT(csc_in_offset2, 16)
REGDEF_BIT(, 16)
REGDEF_END(LCD_CSC_PARM01_REG)

REGDEF_OFFSET(LCD_CH0_CSC_PARM02_REG, 0xB8)
REGDEF_OFFSET(LCD_CH1_CSC_PARM12_REG, 0xE0)
REGDEF_OFFSET(LCD_CH2_CSC_PARM22_REG, 0x108)
REGDEF_OFFSET(LCD_CURSOR_CSC_PARM2_REG, 0x718)
REGDEF_OFFSET(LCD_CSC1_PARM2_REG, 0xA08)
REGDEF_OFFSET(LCD_CSC2_PARM2_REG, 0xA48)
REGDEF_OFFSET(LCD_CSC3_PARM2_REG, 0xA88)
REGDEF_BEGIN(LCD_CSC_PARM02_REG)
REGDEF_BIT(csc_out_offset0, 16)
REGDEF_BIT(csc_out_offset1, 16)
REGDEF_END(LCD_CSC_PARM02_REG)

REGDEF_OFFSET(LCD_CH0_CSC_PARM03_REG, 0xBC)
REGDEF_OFFSET(LCD_CH1_CSC_PARM13_REG, 0xE4)
REGDEF_OFFSET(LCD_CH2_CSC_PARM23_REG, 0x10C)
REGDEF_OFFSET(LCD_CURSOR_CSC_PARM3_REG, 0x71C)
REGDEF_OFFSET(LCD_CSC1_PARM3_REG, 0xA0C)
REGDEF_OFFSET(LCD_CSC2_PARM3_REG, 0xA4C)
REGDEF_OFFSET(LCD_CSC3_PARM3_REG, 0xA8C)
REGDEF_BEGIN(LCD_CSC_PARM03_REG)
REGDEF_BIT(csc_out_offset2, 16)
REGDEF_BIT(, 16)
REGDEF_END(LCD_CSC_PARM03_REG)

REGDEF_OFFSET(LCD_CH0_CSC_PARM04_REG, 0xC0)
REGDEF_OFFSET(LCD_CH1_CSC_PARM14_REG, 0xE8)
REGDEF_OFFSET(LCD_CH2_CSC_PARM24_REG, 0x110)
REGDEF_OFFSET(LCD_CURSOR_CSC_PARM4_REG, 0x720)
REGDEF_OFFSET(LCD_CSC1_PARM4_REG, 0xA10)
REGDEF_OFFSET(LCD_CSC2_PARM4_REG, 0xA50)
REGDEF_OFFSET(LCD_CSC3_PARM4_REG, 0xA90)
REGDEF_BEGIN(LCD_CSC_PARM04_REG)
REGDEF_BIT(csc_coef0, 16)
REGDEF_BIT(csc_coef1, 16)
REGDEF_END(LCD_CSC_PARM04_REG)

REGDEF_OFFSET(LCD_CH0_CSC_PARM05_REG, 0xC4)
REGDEF_OFFSET(LCD_CH1_CSC_PARM15_REG, 0xEC)
REGDEF_OFFSET(LCD_CH2_CSC_PARM25_REG, 0x114)
REGDEF_OFFSET(LCD_CURSOR_CSC_PARM5_REG, 0x724)
REGDEF_OFFSET(LCD_CSC1_PARM5_REG, 0xA14)
REGDEF_OFFSET(LCD_CSC2_PARM5_REG, 0xA54)
REGDEF_OFFSET(LCD_CSC3_PARM5_REG, 0xA94)
REGDEF_BEGIN(LCD_CSC_PARM05_REG)
REGDEF_BIT(csc_coef2, 16)
REGDEF_BIT(csc_coef3, 16)
REGDEF_END(LCD_CSC_PARM05_REG)

REGDEF_OFFSET(LCD_CH0_CSC_PARM06_REG, 0xC8)
REGDEF_OFFSET(LCD_CH1_CSC_PARM16_REG, 0xF0)
REGDEF_OFFSET(LCD_CH2_CSC_PARM26_REG, 0x118)
REGDEF_OFFSET(LCD_CURSOR_CSC_PARM6_REG, 0x728)
REGDEF_OFFSET(LCD_CSC1_PARM6_REG, 0xA18)
REGDEF_OFFSET(LCD_CSC2_PARM6_REG, 0xA58)
REGDEF_OFFSET(LCD_CSC3_PARM6_REG, 0xA98)
REGDEF_BEGIN(LCD_CSC_PARM06_REG)
REGDEF_BIT(csc_coef4, 16)
REGDEF_BIT(csc_coef5, 16)
REGDEF_END(LCD_CSC_PARM06_REG)

REGDEF_OFFSET(LCD_CH0_CSC_PARM07_REG, 0xCC)
REGDEF_OFFSET(LCD_CH1_CSC_PARM17_REG, 0xF4)
REGDEF_OFFSET(LCD_CH2_CSC_PARM27_REG, 0x11C)
REGDEF_OFFSET(LCD_CURSOR_CSC_PARM7_REG, 0x72C)
REGDEF_OFFSET(LCD_CSC1_PARM7_REG, 0xA1C)
REGDEF_OFFSET(LCD_CSC2_PARM7_REG, 0xA5C)
REGDEF_OFFSET(LCD_CSC3_PARM7_REG, 0xA9C)
REGDEF_BEGIN(LCD_CSC_PARM07_REG)
REGDEF_BIT(csc_coef6, 16)
REGDEF_BIT(csc_coef7, 16)
REGDEF_END(LCD_CSC_PARM07_REG)

REGDEF_OFFSET(LCD_CH0_CSC_PARM08_REG, 0xD0)
REGDEF_OFFSET(LCD_CH1_CSC_PARM18_REG, 0xF8)
REGDEF_OFFSET(LCD_CH2_CSC_PARM28_REG, 0x120)
REGDEF_OFFSET(LCD_CURSOR_CSC_PARM8_REG, 0x730)
REGDEF_OFFSET(LCD_CSC1_PARM8_REG, 0xA20)
REGDEF_OFFSET(LCD_CSC2_PARM8_REG, 0xA60)
REGDEF_OFFSET(LCD_CSC3_PARM8_REG, 0xAA0)
REGDEF_BEGIN(LCD_CSC_PARM08_REG)
REGDEF_BIT(csc_coef8, 16)
REGDEF_BIT(, 16)
REGDEF_END(LCD_CSC_PARM08_REG)

REGDEF_OFFSET(LCD_CH0_CSC_PARM09_REG, 0xD4)
REGDEF_OFFSET(LCD_CH1_CSC_PARM19_REG, 0xFC)
REGDEF_OFFSET(LCD_CH2_CSC_PARM29_REG, 0x124)
REGDEF_OFFSET(LCD_CURSOR_CSC_PARM9_REG, 0x734)
REGDEF_OFFSET(LCD_CSC1_PARM9_REG, 0xA24)
REGDEF_OFFSET(LCD_CSC2_PARM9_REG, 0xA64)
REGDEF_OFFSET(LCD_CSC3_PARM9_REG, 0xAA4)
REGDEF_BEGIN(LCD_CSC_PARM09_REG)
REGDEF_BIT(csc_input_clipping, 1)
REGDEF_BIT(csc_output_clipping, 1)
REGDEF_BIT(, 30)
REGDEF_END(LCD_CSC_PARM09_REG)

REGDEF_OFFSET(LCD_YCC_CONTROL_REG, 0x128)
REGDEF_BEGIN(LCD_YCC_CONTROL_REG)
REGDEF_BIT(ycc_dec_shift_mode, 1)
REGDEF_BIT(, 7)
REGDEF_BIT(ycc_dec_dith_en, 1)
REGDEF_BIT(, 3)
REGDEF_BIT(ycc_dec_dith_rst, 1)
REGDEF_BIT(ycc_sw_rst, 1)
REGDEF_BIT(, 3)
REGDEF_BIT(ycc_enc_shift_mode, 1)
REGDEF_BIT(, 14)
REGDEF_END(LCD_YCC_CONTROL_REG)

REGDEF_OFFSET(LCD_YCC_DITH_INIT_REG, 0x12C)
REGDEF_BEGIN(LCD_YCC_DITH_INIT_REG)
REGDEF_BIT(rounding_init0, 15)
REGDEF_BIT(, 1)
REGDEF_BIT(rounding_init1, 4)
REGDEF_BIT(, 12)
REGDEF_END(LCD_YCC_DITH_INIT_REG)

REGDEF_OFFSET(LCD_YCC_QTBL_IDX0_REG, 0x130)
REGDEF_OFFSET(LCD_YCC_QTBL_IDX1_REG, 0x134)
REGDEF_OFFSET(LCD_YCC_QTBL_IDX2_REG, 0x138)
REGDEF_OFFSET(LCD_YCC_QTBL_IDX3_REG, 0x13C)
REGDEF_BEGIN(LCD_YCC_QTBL_IDX_REG)
REGDEF_BIT(qtbl0, 5)
REGDEF_BIT(, 3)
REGDEF_BIT(qtbl1, 5)
REGDEF_BIT(, 3)
REGDEF_BIT(qtbl2, 5)
REGDEF_BIT(, 3)
REGDEF_BIT(qtbl3, 5)
REGDEF_BIT(, 3)
REGDEF_END(LCD_YCC_QTBL_IDX_REG)

REGDEF_OFFSET(LCD_YCC_QUALITY_TH0_REG, 0x140)
REGDEF_OFFSET(LCD_YCC_QUALITY_TH1_REG, 0x144)
REGDEF_BEGIN(LCD_YCC_QUALITY_TH0_REG)
REGDEF_BIT(dct_lvl_th0, 8)
REGDEF_BIT(dct_lvl_th1, 8)
REGDEF_BIT(dct_lvl_th2, 8)
REGDEF_BIT(dct_lvl_th3, 8)
REGDEF_END(LCD_YCC_QUALITY_TH0_REG)

REGDEF_OFFSET(LCD_YCC_DCT_STS_REG, 0x148)
REGDEF_BEGIN(LCD_YCC_DCT_STS_REG)
REGDEF_BIT(dct_maxdist, 8)
REGDEF_BIT(, 24)
REGDEF_END(LCD_YCC_DCT_STS_REG)

REGDEF_OFFSET(LCD_MG_PADDING_COLOR_REG, 0x14C)
REGDEF_BEGIN(LCD_MG_PADDING_COLOR_REG)
REGDEF_BIT(mg_color_y, 8)
REGDEF_BIT(mg_color_cb, 8)
REGDEF_BIT(mg_color_cr, 8)
REGDEF_BIT(, 8)
REGDEF_END(LCD_MG_PADDING_COLOR_REG)

REGDEF_OFFSET(LCD_CH0_CKEY_V0_REG, 0x150)
REGDEF_OFFSET(LCD_CH1_CKEY_V0_REG, 0x158)
REGDEF_OFFSET(LCD_CH2_CKEY_V0_REG, 0x160)
REGDEF_BEGIN(LCD_CKEY_V0_REG)
REGDEF_BIT(low_ckey0, 8)
REGDEF_BIT(low_ckey1, 8)
REGDEF_BIT(low_ckey2, 8)
REGDEF_BIT(, 8)
REGDEF_END(LCD_CKEY_V0_REG)

REGDEF_OFFSET(LCD_CH0_CKEY_V1_REG, 0x154)
REGDEF_OFFSET(LCD_CH1_CKEY_V1_REG, 0x15C)
REGDEF_OFFSET(LCD_CH2_CKEY_V1_REG, 0x164)
REGDEF_BEGIN(LCD_CKEY_V1_REG)
REGDEF_BIT(high_ckey0, 8)
REGDEF_BIT(high_ckey1, 8)
REGDEF_BIT(high_ckey2, 8)
REGDEF_BIT(, 7)
REGDEF_BIT(ckey_en, 1)
REGDEF_END(LCD_CKEY_V1_REG)

REGDEF_OFFSET(LCD_CH0_RLD_READ_SIZE_REG, 0x170)
REGDEF_OFFSET(LCD_CH1_RLD_READ_SIZE_REG, 0x178)
REGDEF_OFFSET(LCD_CH2_RLD_READ_SIZE_REG, 0x180)
REGDEF_BEGIN(LCD_RLD_READ_SIZE_REG)
REGDEF_BIT(rld_read_size, 32)
REGDEF_END(LCD_RLD_READ_SIZE_REG)

REGDEF_OFFSET(LCD_CH0_RLD_A_READ_SIZE_REG, 0x174)
REGDEF_OFFSET(LCD_CH1_RLD_A_READ_SIZE_REG, 0x17C)
REGDEF_OFFSET(LCD_CH2_RLD_A_READ_SIZE_REG, 0x184)
REGDEF_BEGIN(LCD_RLD_A_READ_SIZE_REG)
REGDEF_BIT(rld_a_read_size, 32)
REGDEF_END(LCD_RLD_A_READ_SIZE_REG)

REGDEF_OFFSET(LCD_MIXER_CTRL0_REG, 0x190)
REGDEF_BEGIN(LCD_MIXER_CTRL0_REG)
REGDEF_BIT(layer0_plane, 2)
REGDEF_BIT(layer1_plane, 2)
REGDEF_BIT(layer2_plane, 2)
REGDEF_BIT(, 26)
REGDEF_END(LCD_MIXER_CTRL0_REG)

REGDEF_OFFSET(LCD_MIXER_CTRL1_REG, 0x194)
REGDEF_OFFSET(LCD_MIXER_CTRL2_REG, 0x198)
REGDEF_OFFSET(LCD_MIXER_CTRL3_REG, 0x19C)
REGDEF_BEGIN(LCD_MIXER_CTRL_REG)
REGDEF_BIT(layer_xi, 16)
REGDEF_BIT(layer_yi, 16)
REGDEF_END(LCD_MIXER_CTRL_REG)

#define LCD_INTEN_MSK           		0x001FFFFF
#define LCD_VS_IRQSTS                   ((UINT32)0x00000001 << 0)
#define LCD_VEND_IRQSTS                 ((UINT32)0x00000001 << 1)
#define LCD_LINE1_MON_IRQSTS            ((UINT32)0x00000001 << 2)
#define LCD_LINE2_MON_IRQSTS            ((UINT32)0x00000001 << 3)
#define LCD_UNDER_RUN_IRQSTS            ((UINT32)0x00000001 << 4)
#define LCD_OVER_RUN_IRQSTS             ((UINT32)0x00000001 << 5)
#define LCD_OUT_DRAM_END_IRQSTS         ((UINT32)0x00000001 << 7)
#define LCD_CH0_YCC_ERR_IRQSTS          ((UINT32)0x00000001 << 8)
#define LCD_CH1_YCC_ERR_IRQSTS          ((UINT32)0x00000001 << 9)
#define LCD_CH2_YCC_ERR_IRQSTS          ((UINT32)0x00000001 << 10)
#define LCD_WB_YCC_ERR_IRQSTS           ((UINT32)0x00000001 << 11)
#define LCD_AFBC_ERR_IRQSTS             ((UINT32)0x00000001 << 12)
#define LCD_CURSOR_UNDER_RUN            ((UINT32)0x00000001 << 13)



REGDEF_OFFSET(LCD_INT_STS_REG, 0x1A4)
REGDEF_BEGIN(LCD_INT_STS_REG)
REGDEF_BIT(vs_int, 1)
REGDEF_BIT(vend_int, 1)
REGDEF_BIT(line1_int, 1)
REGDEF_BIT(line2_int, 1)
REGDEF_BIT(, 28)
REGDEF_END(LCD_INT_STS_REG)

REGDEF_OFFSET(LCD_INT_EN_REG, 0x1A8)
REGDEF_BEGIN(LCD_INT_EN_REG)
REGDEF_BIT(vs_int, 1)
REGDEF_BIT(vend_int, 1)
REGDEF_BIT(line1_int, 1)
REGDEF_BIT(line2_int, 1)
REGDEF_BIT(, 28)
REGDEF_END(LCD_INT_EN_REG)

REGDEF_OFFSET(LCD_INT_CLR_REG, 0x1AC)
REGDEF_BEGIN(LCD_INT_CLR_REG)
REGDEF_BIT(vs_int, 1)
REGDEF_BIT(vend_int, 1)
REGDEF_BIT(line1_int, 1)
REGDEF_BIT(line2_int, 1)
REGDEF_BIT(, 28)
REGDEF_END(LCD_INT_CLR_REG)

REGDEF_OFFSET(LCD_COLOR_BAR0_REG, 0x1B0)
REGDEF_OFFSET(LCD_COLOR_BAR1_REG, 0x1B4)
REGDEF_OFFSET(LCD_COLOR_BAR2_REG, 0x1B8)
REGDEF_OFFSET(LCD_COLOR_BAR3_REG, 0x1BC)
REGDEF_OFFSET(LCD_COLOR_BAR4_REG, 0x1C0)
REGDEF_OFFSET(LCD_COLOR_BAR5_REG, 0x1C4)
REGDEF_OFFSET(LCD_COLOR_BAR6_REG, 0x1C8)
REGDEF_OFFSET(LCD_COLOR_BAR7_REG, 0x1CC)
REGDEF_BEGIN(LCD_COLOR_BAR_REG)
REGDEF_BIT(colbar_b, 8)
REGDEF_BIT(colbar_g, 8)
REGDEF_BIT(colbar_r, 8)
REGDEF_BIT(, 8)
REGDEF_END(LCD_COLOR_BAR_REG)

REGDEF_OFFSET(LCD_PATTERN_GEN_REG, 0x1D0)
REGDEF_BEGIN(LCD_PATTERN_GEN_REG)
REGDEF_BIT(ch0_patgen, 2)
REGDEF_BIT(ch1_patgen, 2)
REGDEF_BIT(ch2_patgen, 2)
REGDEF_BIT(, 2)
REGDEF_BIT(patgen_ch, 2)
REGDEF_BIT(patgen_en, 1)
REGDEF_BIT(patgen_dma_ch, 1)
REGDEF_BIT(, 20)
REGDEF_END(LCD_PATTERN_GEN_REG)


REGDEF_OFFSET(LCD_LINE_MON_CTL1_REG, 0x1D4)
REGDEF_OFFSET(LCD_LINE_MON_CTL2_REG, 0x1D8)
REGDEF_BEGIN(LCD_LINE_MON_CTL_REG)
REGDEF_BIT(mon_line, 13)
REGDEF_BIT(, 19)
REGDEF_END(LCD_LINE_MON_CTL_REG)

REGDEF_OFFSET(LCD_MEM_PARM_REG, 0x1DC)
REGDEF_BEGIN(LCD_MEM_PARM_REG)
REGDEF_BIT(nap, 1)
REGDEF_BIT(dvse, 1)
REGDEF_BIT(, 2)
REGDEF_BIT(dvs, 4)
REGDEF_BIT(, 24)
REGDEF_END(LCD_MEM_PARM_REG)

REGDEF_OFFSET(LCD_FRM_RESET_REG, 0x1E0)
REGDEF_BEGIN(LCD_FRM_RESET_REG)
REGDEF_BIT(frst_cnt, 16)
REGDEF_BIT(px_rst_cnt, 8)
REGDEF_BIT(, 8)
REGDEF_END(LCD_FRM_RESET_REG)

REGDEF_OFFSET(LCD_SW_RESET_REG, 0x1FC)
REGDEF_BEGIN(LCD_SW_RESET_REG)
REGDEF_BIT(sw_rst, 1)
REGDEF_BIT(dmac_sw_rst, 1)
REGDEF_BIT(dmac0_disable, 1)
REGDEF_BIT(dmac1_disable, 1)
REGDEF_BIT(dmac0_shutdown_done, 1)
REGDEF_BIT(dmac1_shutdown_done, 1)
REGDEF_BIT(, 24)
REGDEF_END(LCD_SW_RESET_REG)

REGDEF_OFFSET(LCD_CH0_CE_PARM01_REG, 0x204)
REGDEF_OFFSET(LCD_CH0_CE_PARM02_REG, 0x208)
REGDEF_OFFSET(LCD_CH2_CE_PARM01_REG, 0x244)
REGDEF_OFFSET(LCD_CH2_CE_PARM02_REG, 0x248)
REGDEF_BEGIN(LCD_CE_PARM01_REG)
REGDEF_BIT(blk_width, 12)
REGDEF_BIT(, 4)
REGDEF_BIT(blk_height, 12)
REGDEF_BIT(, 4)
REGDEF_END(LCD_CE_PARM01_REG)

REGDEF_OFFSET(LCD_CH0_CE_PARM03_REG, 0x20C)
REGDEF_OFFSET(LCD_CH0_CE_PARM04_REG, 0x210)
REGDEF_OFFSET(LCD_CH2_CE_PARM03_REG, 0x24C)
REGDEF_OFFSET(LCD_CH2_CE_PARM04_REG, 0x250)
REGDEF_BEGIN(LCD_CE_PARM03_REG)
REGDEF_BIT(recip0, 18)
REGDEF_BIT(, 14)
REGDEF_END(LCD_CE_PARM03_REG)

REGDEF_OFFSET(LCD_CH0_CE_PARM05_REG, 0x214)
REGDEF_OFFSET(LCD_CH2_CE_PARM05_REG, 0x254)
REGDEF_BEGIN(LCD_CE_PARM05_REG)
REGDEF_BIT(blnrat, 8)
REGDEF_BIT(ceth, 8)
REGDEF_BIT(strth, 10)
REGDEF_BIT(, 5)
REGDEF_BIT(ceen, 1)
REGDEF_END(LCD_CE_PARM05_REG)

REGDEF_OFFSET(LCD_CH0_CE_PARM06_REG, 0x218)
REGDEF_OFFSET(LCD_CH2_CE_PARM06_REG, 0x288)
REGDEF_BEGIN(LCD_CE_PARM06_REG)
REGDEF_BIT(ce_sx, 16)
REGDEF_BIT(ce_sy, 16)
REGDEF_END(LCD_CE_PARM06_REG)

REGDEF_OFFSET(LCD_CH0_CE_PARM07_REG, 0x21C)
REGDEF_OFFSET(LCD_CH2_CE_PARM07_REG, 0x25C)
REGDEF_BEGIN(LCD_CH0_CE_PARM07_REG)
REGDEF_BIT(ce_ex, 16)
REGDEF_BIT(ce_ey, 16)
REGDEF_END(LCD_CH0_CE_PARM07_REG)

REGDEF_OFFSET(LCD_CH0_YUV_ADJ_REG, 0x300)
REGDEF_OFFSET(LCD_CH1_YUV_ADJ_REG, 0x314)
REGDEF_OFFSET(LCD_CH2_YUV_ADJ_REG, 0x328)
REGDEF_BEGIN(LCD_YUV_ADJ_REG)
REGDEF_BIT(bright_en, 1)
REGDEF_BIT(contrs_en, 1)
REGDEF_BIT(hs_en, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(contrs_mode, 2)
REGDEF_BIT(, 2)
REGDEF_BIT(brightness, 8)
REGDEF_BIT(contrast, 8)
REGDEF_BIT(, 8)
REGDEF_END(LCD_YUV_ADJ_REG)

REGDEF_OFFSET(LCD_CH0_HUE_PARM0_REG, 0x304)
REGDEF_OFFSET(LCD_CH1_HUE_PARM0_REG, 0x318)
REGDEF_OFFSET(LCD_CH2_HUE_PARM0_REG, 0x32C)
REGDEF_BEGIN(LCD_HUE_PARM0_REG)
REGDEF_BIT(hue0, 8)
REGDEF_BIT(hue1, 8)
REGDEF_BIT(hue2, 8)
REGDEF_BIT(hue3, 8)
REGDEF_END(LCD_HUE_PARM0_REG)

REGDEF_OFFSET(LCD_CH0_HUE_PARM1_REG, 0x308)
REGDEF_OFFSET(LCD_CH1_HUE_PARM1_REG, 0x31C)
REGDEF_OFFSET(LCD_CH2_HUE_PARM1_REG, 0x330)
REGDEF_BEGIN(LCD_HUE_PARM1_REG)
REGDEF_BIT(hue4, 8)
REGDEF_BIT(hue5, 8)
REGDEF_BIT(, 16)
REGDEF_END(LCD_HUE_PARM1_REG)

REGDEF_OFFSET(LCD_CH0_SAT_PARM0_REG, 0x30C)
REGDEF_OFFSET(LCD_CH1_SAT_PARM0_REG, 0x320)
REGDEF_OFFSET(LCD_CH2_SAT_PARM0_REG, 0x334)
REGDEF_BEGIN(LCD_SAT_PARM0_REG)
REGDEF_BIT(sat0, 8)
REGDEF_BIT(sat1, 8)
REGDEF_BIT(sat2, 8)
REGDEF_BIT(sat3, 8)
REGDEF_END(LCD_SAT_PARM0_REG)

REGDEF_OFFSET(LCD_CH0_SAT_PARM1_REG, 0x310)
REGDEF_OFFSET(LCD_CH1_SAT_PARM1_REG, 0x324)
REGDEF_OFFSET(LCD_CH2_SAT_PARM1_REG, 0x338)
REGDEF_BEGIN(LCD_SAT_PARM1_REG)
REGDEF_BIT(sat4, 8)
REGDEF_BIT(sat5, 8)
REGDEF_BIT(, 16)
REGDEF_END(LCD_SAT_PARM1_REG)

REGDEF_OFFSET(LCD_SDI_REG, 0x400)
REGDEF_BEGIN(LCD_SDI_REG)
REGDEF_BIT(bypass, 4)
REGDEF_BIT(crop_en, 4)
REGDEF_BIT(, 8)
REGDEF_BIT(map_sel, 4)
REGDEF_BIT(, 12)
REGDEF_END(LCD_SDI_REG)

REGDEF_OFFSET(LCD_SDI1_ALG_SEL_REG, 0x404)
REGDEF_BEGIN(LCD_SDI1_ALG_SEL_REG)
REGDEF_BIT(sdi0_y_luma_smo_en, 2)
REGDEF_BIT(sdi0_y_luma_wadi_en, 2)
REGDEF_BIT(sdi0_y_luma_mean_en, 2)
REGDEF_BIT(sdi0_x_luma_algo_en, 2)
REGDEF_BIT(sdi0_y_chroma_algo_en, 2)
REGDEF_BIT(sdi0_x_chroma_algo_en, 2)
REGDEF_BIT(, 4)
REGDEF_BIT(sdi1_y_luma_smo_en, 2)
REGDEF_BIT(sdi1_y_luma_wadi_en, 2)
REGDEF_BIT(sdi1_y_luma_mean_en, 2)
REGDEF_BIT(sdi1_x_luma_algo_en, 2)
REGDEF_BIT(sdi1_y_chroma_algo_en, 2)
REGDEF_BIT(sdi1_x_chroma_algo_en, 2)
REGDEF_BIT(, 4)
REGDEF_END(LCD_SDI1_ALG_SEL_REG)

REGDEF_OFFSET(LCD_SDI0_SRC_REG, 0x40C)
REGDEF_OFFSET(LCD_SDI1_SRC_REG, 0x420)
REGDEF_BEGIN(LCD_SDI0_SRC_REG)
REGDEF_BIT(sdi0_src_width, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(sdi0_src_height, 13)
REGDEF_BIT(, 3)
REGDEF_END(LCD_SDI0_SRC_REG)

REGDEF_OFFSET(LCD_SDI0_DST_REG, 0x410)
REGDEF_OFFSET(LCD_SDI1_DST_REG, 0x424)
REGDEF_BEGIN(LCD_SDI0_DST_REG)
REGDEF_BIT(sdi0_dst_width, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(sdi0_dst_height, 13)
REGDEF_BIT(, 3)
REGDEF_END(LCD_SDI0_DST_REG)

REGDEF_OFFSET(LCD_SDI0_STEP_REG, 0x414)
REGDEF_OFFSET(LCD_SDI1_STEP_REG, 0x428)
REGDEF_BEGIN(LCD_SDI_STEP_REG)
REGDEF_BIT(sdi_hstep, 16)
REGDEF_BIT(sdi_vstep, 16)
REGDEF_END(LCD_SDI_STEP_REG)

REGDEF_OFFSET(LCD_SDI0_DIV_REG, 0x418)
REGDEF_OFFSET(LCD_SDI1_DIV_REG, 0x42C)
REGDEF_BEGIN(LCD_SDI_DIV_REG)
REGDEF_BIT(sdi_hsca_divisor, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(sdi_vsca_divisor, 13)
REGDEF_BIT(, 3)
REGDEF_END(LCD_SDI_DIV_REG)

REGDEF_OFFSET(LCD_SDI0_MASK_REG, 0x41C)
REGDEF_OFFSET(LCD_SDI1_MASK_REG, 0x430)
REGDEF_BEGIN(LCD_SDI_MASK_REG)
REGDEF_BIT(sdi1_havg_pxl_msk, 8)
REGDEF_BIT(sdi1_vavg_pxl_msk, 4)
REGDEF_BIT(, 4)
REGDEF_BIT(sdi1_kval, 12)
REGDEF_BIT(, 4)
REGDEF_END(LCD_SDI_MASK_REG)

REGDEF_OFFSET(LCD_SDI0_SRC_CROP_WIDTH_REG, 0x45C)
REGDEF_OFFSET(LCD_SDI1_SRC_CROP_WIDTH_REG, 0x464)
REGDEF_BEGIN(LCD_SDI_SRC_CROP_WIDTH_REG)
REGDEF_BIT(sdi_crop_x_st, 12)
REGDEF_BIT(, 4)
REGDEF_BIT(sdi_crop_width, 12)
REGDEF_BIT(, 4)
REGDEF_END(LCD_SDI_SRC_CROP_WIDTH_REG)

REGDEF_OFFSET(LCD_SDI0_SRC_CROP_HEIGHT_REG, 0x460)
REGDEF_OFFSET(LCD_SDI1_SRC_CROP_HEIGHT_REG, 0x468)
REGDEF_BEGIN(LCD_SDI_SRC_CROP_HEIGHT_REG)
REGDEF_BIT(sdi_crop_y_st, 12)
REGDEF_BIT(, 4)
REGDEF_BIT(sdi_crop_height, 12)
REGDEF_BIT(, 4)
REGDEF_END(LCD_SDI_SRC_CROP_HEIGHT_REG)

REGDEF_OFFSET(LCD_SDI_ALPHA_X_REG, 0x47C)
REGDEF_BEGIN(LCD_SDI_ALPHA_X_REG)
REGDEF_BIT(sd0_x_alpha_wet, 8)
REGDEF_BIT(sd1_x_alpha_wet, 8)
REGDEF_BIT(, 16)
REGDEF_END(LCD_SDI_ALPHA_X_REG)

REGDEF_OFFSET(LCD_SDI_ALPHA_Y_REG, 0x480)
REGDEF_BEGIN(LCD_SDI_ALPHA_Y_REG)
REGDEF_BIT(sd0_y_alpha_wet, 8)
REGDEF_BIT(sd1_y_alpha_wet, 8)
REGDEF_BIT(, 16)
REGDEF_END(LCD_SDI_ALPHA_Y_REG)

REGDEF_OFFSET(LCD_SD0_HSTEP_OFS_REG, 0x484)
REGDEF_OFFSET(LCD_SD1_HSTEP_OFS_REG, 0x488)
REGDEF_BEGIN(LCD_SD_HSTEP_OFS_REG)
REGDEF_BIT(sd_hstep_ofs, 18)
REGDEF_BIT(, 14)
REGDEF_END(LCD_SD_HSTEP_OFS_REG)

REGDEF_OFFSET(LCD_SDO_REG, 0x500)
REGDEF_BEGIN(LCD_SDO_REG)
REGDEF_BIT(sdo_bypass, 2)
REGDEF_BIT(,2)
REGDEF_BIT(sdo_crop_en, 2)
REGDEF_BIT(, 2)
REGDEF_BIT(sdo_en, 2)
REGDEF_BIT(, 6)
REGDEF_BIT(sdo_sca_map_sel, 2)
REGDEF_BIT(, 14)
REGDEF_END(LCD_SDO_REG)

REGDEF_OFFSET(LCD_SDO1_ALG_SEL_REG, 0x504)
REGDEF_BEGIN(LCD_SDO1_ALG_SEL_REG)
REGDEF_BIT(sdo_res0_y_luma_smo_en, 2)
REGDEF_BIT(sdo_res0_y_luma_wadi_en, 2)
REGDEF_BIT(sdo_res0_y_luma_mean_en, 2)
REGDEF_BIT(sdo_res0_x_luma_algo_en, 2)
REGDEF_BIT(sdo_res0_y_chroma_algo_en, 2)
REGDEF_BIT(sdo_res0_x_chroma_algo_en, 2)
REGDEF_BIT(, 20)
REGDEF_END(LCD_SDO1_ALG_SEL_REG)

REGDEF_OFFSET(LCD_SDO_SRC_REG, 0x508)
REGDEF_BEGIN(LCD_SDO_SRC_REG)
REGDEF_BIT(sdo_src_width, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(sdo_src_height, 13)
REGDEF_BIT(, 3)
REGDEF_END(LCD_SDO_SRC_REG)

REGDEF_OFFSET(LCD_SDO_RES0_DST_REG, 0x50C)
REGDEF_BEGIN(LCD_SDO_RES0_DST_REG)
REGDEF_BIT(sdo_res_dst_width, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(sdo_res_dst_height, 13)
REGDEF_BIT(, 3)
REGDEF_END(LCD_SDO_RES0_DST_REG)

REGDEF_OFFSET(LCD_SDO_RES0_STEP_REG, 0x510)
REGDEF_BEGIN(LCD_SDO_RES_STEP_REG)
REGDEF_BIT(sdo_res_hvstep, 16)
REGDEF_BIT(sdo_res_vstep, 16)
REGDEF_END(LCD_SDO_RES_STEP_REG)

REGDEF_OFFSET(LCD_SDO_DIV_REG, 0x514)
REGDEF_BEGIN(LCD_SDO_DIV_REG)
REGDEF_BIT(sdo_res_hsca_divisor, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(sdo_res_vsca_divisor, 13)
REGDEF_BIT(, 3)
REGDEF_END(LCD_SDO_DIV_REG)

REGDEF_OFFSET(LCD_SDO_RES0_MASK_REG, 0x518)
REGDEF_BEGIN(LCD_SDO_RES_MASK_REG)
REGDEF_BIT(sdo_res_havg_pxl_msk, 8)
REGDEF_BIT(sdo_res_vavg_pxl_msk, 4)
REGDEF_BIT(, 4)
REGDEF_BIT(sdo_res_kval, 12)
REGDEF_BIT(, 4)
REGDEF_END(LCD_SDO_RES_MASK_REG)

REGDEF_OFFSET(LCD_SDO_RES0_CROP_WIDTH_REG, 0x52C)
REGDEF_BEGIN(LCD_SDO_RES0_CROP_WIDTH_REG)
REGDEF_BIT(sdo_res0_crop_x_st, 12)
REGDEF_BIT(, 4)
REGDEF_BIT(sdo_res0_crop_width, 12)
REGDEF_BIT(, 4)
REGDEF_END(LCD_SDO_RES0_CROP_WIDTH_REG)

REGDEF_OFFSET(LCD_SDO_RES0_CROP_HEIGHT_REG, 0x530)
REGDEF_BEGIN(LCD_SDO_RES_CROP_HEIGHT_REG)
REGDEF_BIT(sdo_res0_crop_y_st, 12)
REGDEF_BIT(, 4)
REGDEF_BIT(sdo_res0_crop_height, 12)
REGDEF_BIT(, 4)
REGDEF_END(LCD_SDO_RES_CROP_HEIGHT_REG)

REGDEF_OFFSET(LCD_SDO_WB_REG, 0x53C)
REGDEF_BEGIN(LCD_SDO_WB_REG)
REGDEF_BIT(wb_en, 1)
REGDEF_BIT(wb_mode, 1)
REGDEF_BIT(wb_uvswap, 1)
REGDEF_BIT(, 2)
REGDEF_BIT(wb_shot, 1)
REGDEF_BIT(wb_6, 1)
REGDEF_BIT(wb_7, 1)
REGDEF_BIT(, 5)
REGDEF_BIT(wb_oneshot, 1)
REGDEF_BIT(wb_sel, 2)
REGDEF_BIT(, 16)
REGDEF_END(LCD_SDO_WB_REG)

REGDEF_OFFSET(LCD_SDO_WB_POS_REG, 0x540)
REGDEF_BEGIN(LCD_SDO_WB_POS_REG)
REGDEF_BIT(wb_x, 16)
REGDEF_BIT(wb_y, 16)
REGDEF_END(LCD_SDO_WB_POS_REG)

REGDEF_OFFSET(LCD_SDO_WB_DIM_REG, 0x544)
REGDEF_BEGIN(LCD_SDO_WB_DIM_REG)
REGDEF_BIT(wb_w, 16)
REGDEF_BIT(wb_h, 16)
REGDEF_END(LCD_SDO_WB_DIM_REG)

REGDEF_OFFSET(LCD_WB_ADDR_REG, 0x548)
REGDEF_BEGIN(LCD_WB_ADDR_REG)
REGDEF_BIT(wb_ba, 32)
REGDEF_END(LCD_WB_ADDR_REG)

REGDEF_OFFSET(LCD_WB_HADDR_REG, 0x54C)
REGDEF_BEGIN(LCD_WB_HADDR_REG)
REGDEF_BIT(wb_hba, 4)
REGDEF_BIT(, 28)
REGDEF_END(LCD_WB_HADDR_REG)

REGDEF_OFFSET(LCD_WB_CBR_ADDR_REG, 0x550)
REGDEF_BEGIN(LCD_WB_CBR_ADDR_REG)
REGDEF_BIT(wb_cbr_ba, 32)
REGDEF_END(LCD_WB_CBR_ADDR_REG)

REGDEF_OFFSET(LCD_WB_CBR_ADDR_H_REG, 0x554)
REGDEF_BEGIN(LCD_WB_CBR_ADDR_H_REG)
REGDEF_BIT(wb_cbr_hba, 4)
REGDEF_BIT(, 28)
REGDEF_END(LCD_WB_CBR_ADDR_H_REG)

REGDEF_OFFSET(LCD_WB_CRL_REG, 0x558)
REGDEF_BEGIN(LCD_WB_CRL_REG)
REGDEF_BIT(wb_fmt, 2)
REGDEF_BIT(, 30)
REGDEF_END(LCD_WB_CRL_REG)

REGDEF_OFFSET(LCD_SDO_RES0_HSTEP_OFS_REG, 0x55C)
REGDEF_BEGIN(LCD_SDO_RES0_HSTEP_OFS_REG)
REGDEF_BIT(sdo_res0_hstep_ofs, 18)
REGDEF_BIT(, 14)
REGDEF_END(LCD_SDO_RES0_HSTEP_OFS_REG)

REGDEF_OFFSET(LCD_SDO_WB_LINE_OFS_REG, 0x564)
REGDEF_BEGIN(LCD_SDO_WB_LINE_OFS_REG)
REGDEF_BIT(wb_ofs, 13)
REGDEF_BIT(, 19)
REGDEF_END(LCD_SDO_WB_LINE_OFS_REG)

REGDEF_OFFSET(LCD_SDO_WB_CBR_LINE_OFS_REG, 0x568)
REGDEF_BEGIN(LCD_SDO_WB_CBR_LINE_OFS_REG)
REGDEF_BIT(wb_cbr_ofs, 13)
REGDEF_BIT(, 19)
REGDEF_END(LCD_SDO_WB_CBR_LINE_OFS_REG)

REGDEF_OFFSET(LCD_CH0_GAMMA_PARM0_REG, 0x600)
REGDEF_OFFSET(LCD_CH0_GAMMA_PARM1_REG, 0x604)
REGDEF_OFFSET(LCD_CH0_GAMMA_PARM2_REG, 0x608)
REGDEF_OFFSET(LCD_CH0_GAMMA_PARM3_REG, 0x60C)
REGDEF_OFFSET(LCD_CH1_GAMMA_PARM0_REG, 0x614)
REGDEF_OFFSET(LCD_CH1_GAMMA_PARM1_REG, 0x618)
REGDEF_OFFSET(LCD_CH1_GAMMA_PARM2_REG, 0x61C)
REGDEF_OFFSET(LCD_CH1_GAMMA_PARM3_REG, 0x620)
REGDEF_OFFSET(LCD_CH2_GAMMA_PARM0_REG, 0x62C)
REGDEF_OFFSET(LCD_CH2_GAMMA_PARM1_REG, 0x630)
REGDEF_OFFSET(LCD_CH2_GAMMA_PARM2_REG, 0x634)
REGDEF_OFFSET(LCD_CH2_GAMMA_PARM3_REG, 0x638)
REGDEF_BEGIN(LCD_GAMMA_PARM0_REG)
REGDEF_BIT(blk0_idx, 5)
REGDEF_BIT(, 3)
REGDEF_BIT(blk1_idx, 5)
REGDEF_BIT(, 3)
REGDEF_BIT(blk2_idx, 5)
REGDEF_BIT(, 3)
REGDEF_BIT(blk3_idx, 5)
REGDEF_BIT(, 3)
REGDEF_END(LCD_GAMMA_PARM0_REG)

REGDEF_OFFSET(LCD_CH0_GAMMA_PARM4_REG, 0x610)
REGDEF_OFFSET(LCD_CH1_GAMMA_PARM4_REG, 0x624)
REGDEF_OFFSET(LCD_CH2_GAMMA_PARM4_REG, 0x63C)
REGDEF_BEGIN(LCD_GAMMA_PARM4_REG)
REGDEF_BIT(blk0_split, 2)
REGDEF_BIT(blk1_split, 2)
REGDEF_BIT(blk2_split, 2)
REGDEF_BIT(blk3_split, 2)
REGDEF_BIT(blk4_split, 2)
REGDEF_BIT(blk5_split, 2)
REGDEF_BIT(blk6_split, 2)
REGDEF_BIT(blk7_split, 2)
REGDEF_BIT(blk8_split, 2)
REGDEF_BIT(blk9_split, 2)
REGDEF_BIT(blk10_split, 2)
REGDEF_BIT(blk11_split, 2)
REGDEF_BIT(blk12_split, 2)
REGDEF_BIT(blk13_split, 2)
REGDEF_BIT(blk14_split, 2)
REGDEF_BIT(blk15_split, 2)
REGDEF_END(LCD_GAMMA_PARM4_REG)

REGDEF_OFFSET(LCD_GAMMA_PARM10_REG, 0x628)
REGDEF_BEGIN(LCD_GAMMA_PARM10_REG)
REGDEF_BIT(ch0_gamma_en, 1)
REGDEF_BIT(ch1_gamma_en, 1)
REGDEF_BIT(ch2_gamma_en, 1)
REGDEF_BIT(, 29)
REGDEF_END(LCD_GAMMA_PARM10_REG)

REGDEF_OFFSET(LCD_CH0_GAMMA_LUT_REG, 0x640)
REGDEF_OFFSET(LCD_CH1_GAMMA_LUT_REG, 0x680)
REGDEF_OFFSET(LCD_CH2_GAMMA_LUT_REG, 0x6C0)
REGDEF_BEGIN(LCD_GAMMA_LUT_REG)
REGDEF_BIT(gamma_lut0, 12)
REGDEF_BIT(, 4)
REGDEF_BIT(gamma_lut1, 12)
REGDEF_BIT(, 4)
REGDEF_END(LCD_GAMMA_LUT_REG)

REGDEF_OFFSET(LCD_CURSOR_POS_REG, 0x700)
REGDEF_BEGIN(LCD_CURSOR_POS_REG)
REGDEF_BIT(cursor_sx, 12)
REGDEF_BIT(, 4)
REGDEF_BIT(cursor_sy, 12)
REGDEF_BIT(cursor_fmt, 1)
REGDEF_BIT(, 2)
REGDEF_BIT(cursor_en, 1)
REGDEF_END(LCD_CURSOR_POS_REG)

REGDEF_OFFSET(LCD_CURSOR_ADDR_REG, 0x704)
REGDEF_BEGIN(LCD_CURSOR_ADDR_REG)
REGDEF_BIT(cursor_ba, 32)
REGDEF_END(LCD_CURSOR_ADDR_REG)

REGDEF_OFFSET(LCD_CURSOR_HADDR_REG, 0x708)
REGDEF_BEGIN(LCD_CURSOR_HADDR_REG)
REGDEF_BIT(cursor_hba, 4)
REGDEF_BIT(, 28)
REGDEF_END(LCD_CURSOR_HADDR_REG)

REGDEF_OFFSET(LCD_CURSOR_BUFFER_DIM_REG, 0x70C)
REGDEF_BEGIN(LCD_CURSOR_BUFFER_DIM_REG)
REGDEF_BIT(cursor_bw, 8)
REGDEF_BIT(, 8)
REGDEF_BIT(cursor_bh, 8)
REGDEF_BIT(, 8)
REGDEF_END(LCD_CURSOR_BUFFER_DIM_REG)

REGDEF_OFFSET(LCD_TIMING_CTRL_PRM0_REG,0x800)
REGDEF_BEGIN(LCD_TIMING_CTRL_PRM0_REG)
REGDEF_BIT(vtc_en, 1)
REGDEF_BIT(vtc_on, 1)
REGDEF_BIT(dev_hdmi, 2)
REGDEF_BIT(disp_dev, 4)
REGDEF_BIT(hs_inv, 1)
REGDEF_BIT(vs_inv, 1)
REGDEF_BIT(hvld_inv, 1)
REGDEF_BIT(vvld_inv, 1)
REGDEF_BIT(clk_inv, 1)
REGDEF_BIT(fld_inv, 1)
REGDEF_BIT(de_inv, 1)
REGDEF_BIT(p_dir, 1)
REGDEF_BIT(lcd_odd, 2)
REGDEF_BIT(lcd_even, 2)
REGDEF_BIT(csc1_en, 1)
REGDEF_BIT(csc2_en, 1)
REGDEF_BIT(csc3_en, 1)
REGDEF_BIT(rgbd_swap, 1)
REGDEF_BIT(rgbd, 1)
REGDEF_BIT(out_ddr, 1)
REGDEF_BIT(through, 1)
REGDEF_BIT(clk_1_2, 1)
REGDEF_BIT(dither_en, 1)
REGDEF_BIT(dither_freerun, 1)
REGDEF_BIT(rgb_gamma_en, 1)
REGDEF_BIT(lcd_pclk_mux, 1)
REGDEF_END(LCD_TIMING_CTRL_PRM0_REG)

REGDEF_OFFSET(LCD_TIMING_CTRL_PRM1_REG,0x804)
REGDEF_BEGIN(LCD_TIMING_CTRL_PRM1_REG)
REGDEF_BIT(cex, 1)
REGDEF_BIT(yc_ex, 1)
REGDEF_BIT(ycc_clm, 2)
REGDEF_BIT(, 4)
REGDEF_BIT(r_vbits, 2)
REGDEF_BIT(g_vbits, 2)
REGDEF_BIT(b_vbits, 2)
REGDEF_BIT(out_comp0_sel, 2)
REGDEF_BIT(out_comp1_sel, 2)
REGDEF_BIT(out_comp2_sel, 2)
REGDEF_BIT(out_comp_bswp, 1)
REGDEF_BIT(out_comp_len, 2)
REGDEF_BIT(, 1)
REGDEF_BIT(out_clk_delay, 5)
REGDEF_BIT(, 2)
REGDEF_BIT(inter_load_mode, 1)
REGDEF_END(LCD_TIMING_CTRL_PRM1_REG)
REGDEF_OFFSET(LCD_TIMING_CTRL_PRM2_REG,0x808)
REGDEF_BEGIN(LCD_TIMING_CTRL_PRM2_REG)
REGDEF_BIT(hsynct, 12)
REGDEF_BIT(htotal, 17)
REGDEF_BIT(, 2)
REGDEF_BIT(hsdelay, 1)
REGDEF_END(LCD_TIMING_CTRL_PRM2_REG)

REGDEF_OFFSET(LCD_TIMING_CTRL_PRM3_REG,0x80C)
REGDEF_BEGIN(LCD_TIMING_CTRL_PRM3_REG)
REGDEF_BIT(hvldst, 12)
REGDEF_BIT(hvlded, 17)
REGDEF_BIT(, 3)
REGDEF_END(LCD_TIMING_CTRL_PRM3_REG)

REGDEF_OFFSET(LCD_TIMING_CTRL_PRM4_REG,0x810)
REGDEF_BEGIN(LCD_TIMING_CTRL_PRM4_REG)
REGDEF_BIT(vsynct, 9)
REGDEF_BIT(, 3)
REGDEF_BIT(vtotal, 17)
REGDEF_BIT(, 2)
REGDEF_BIT(vsdelay, 1)
REGDEF_END(LCD_TIMING_CTRL_PRM4_REG)

REGDEF_OFFSET(LCD_TIMING_CTRL_PRM5_REG,0x814)
REGDEF_BEGIN(LCD_TIMING_CTRL_PRM5_REG)
REGDEF_BIT(oddvvldst, 11)
REGDEF_BIT(, 1)
REGDEF_BIT(oddvvlded, 17)
REGDEF_BIT(, 2)
REGDEF_BIT(inter_load_mode, 1)
REGDEF_END(LCD_TIMING_CTRL_PRM5_REG)

REGDEF_OFFSET(LCD_TIMING_CTRL_PRM6_REG,0x818)
REGDEF_BEGIN(LCD_TIMING_CTRL_PRM6_REG)
REGDEF_BIT(evenvvldst, 11)
REGDEF_BIT(, 1)
REGDEF_BIT(evenvvlded, 17)
REGDEF_BIT(display_interlace, 1)
REGDEF_BIT(, 1)
REGDEF_BIT(cdfld, 1)
REGDEF_END(LCD_TIMING_CTRL_PRM6_REG)

REGDEF_OFFSET(LCD_DIGI_TIMING_PRM0_REG,0x81C)
REGDEF_BEGIN(LCD_DIGI_TIMING_PRM0_REG)
REGDEF_BIT(coddblkst, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(coddblked, 13)
REGDEF_BIT(, 3)
REGDEF_END(LCD_DIGI_TIMING_PRM0_REG)

REGDEF_OFFSET(LCD_DIGI_TIMING_PRM1_REG,0x820)
REGDEF_BEGIN(LCD_DIGI_TIMING_PRM1_REG)
REGDEF_BIT(cevenblkst, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(cevenblked, 13)
REGDEF_BIT(, 3)
REGDEF_END(LCD_DIGI_TIMING_PRM1_REG)

REGDEF_OFFSET(LCD_DIGI_TIMING_PRM2_REG,0x824)
REGDEF_BEGIN(LCD_DIGI_TIMING_PRM2_REG)
REGDEF_BIT(cfidst, 13)
REGDEF_BIT(, 3)
REGDEF_BIT(cfided, 13)
REGDEF_BIT(, 3)
REGDEF_END(LCD_DIGI_TIMING_PRM2_REG)

REGDEF_OFFSET(LCD_SUB_PIXEL_REG,0x828)
REGDEF_BEGIN(LCD_SUB_PIXEL_REG)
REGDEF_BIT(odd_r,  1)
REGDEF_BIT(odd_g,  1)
REGDEF_BIT(odd_b,  1)
REGDEF_BIT(,  1)
REGDEF_BIT(even_r,  1)
REGDEF_BIT(even_g,  1)
REGDEF_BIT(even_b,  1)
REGDEF_BIT(, 25)
REGDEF_END(LCD_SUB_PIXEL_REG)

REGDEF_OFFSET(LCD_AXI_CTRL0_REG,0x830)
REGDEF_BEGIN(LCD_AXI_CTRL0_REG)
REGDEF_BIT(channel_en,  16)
REGDEF_BIT(lock_dis,  16)
REGDEF_END(LCD_AXI_CTRL0_REG)

REGDEF_OFFSET(LCD_AXI_CTRL1_REG,0x834)
REGDEF_BEGIN(LCD_AXI_CTRL1_REG)
REGDEF_BIT(axi_dis,  1)
REGDEF_BIT(,  7)
REGDEF_BIT(r_ostd_num,  8)
REGDEF_BIT(w_ostd_num,  8)
REGDEF_BIT(, 8)
REGDEF_END(LCD_AXI_CTRL1_REG)

REGDEF_OFFSET(LCD_AXI_CTRL2_REG,0x838)
REGDEF_BEGIN(LCD_AXI_CTRL2_REG)
REGDEF_BIT(axi_ch_idle,  1)
REGDEF_BIT(, 15)
REGDEF_BIT(axi_read_ch,  6)
REGDEF_BIT(axi_afbc,  2)
REGDEF_BIT(axi_hwc,  1)
REGDEF_BIT(axi_write_ch,  2)
REGDEF_BIT(, 5)
REGDEF_END(LCD_AXI_CTRL2_REG)

REGDEF_OFFSET(LCD_IMG_CTRL_REG,0x880)
REGDEF_BEGIN(LCD_IMG_CTRL_REG)
REGDEF_BIT(, 16)
REGDEF_BIT(frame_cnt, 16)
REGDEF_END(LCD_IMG_CTRL_REG)



#define LCD_GAMMA_LEVEL         32
REGDEF_OFFSET(LCD_R_GAMMA_PRM0_REG,0x900)
REGDEF_OFFSET(LCD_R_GAMMA_PRM1_REG,0x904)
REGDEF_OFFSET(LCD_R_GAMMA_PRM2_REG,0x908)
REGDEF_OFFSET(LCD_R_GAMMA_PRM3_REG,0x90C)
REGDEF_OFFSET(LCD_R_GAMMA_PRM4_REG,0x910)
REGDEF_OFFSET(LCD_R_GAMMA_PRM5_REG,0x914)
REGDEF_OFFSET(LCD_R_GAMMA_PRM6_REG,0x918)
REGDEF_OFFSET(LCD_R_GAMMA_PRM7_REG,0x91C)
REGDEF_OFFSET(LCD_G_GAMMA_PRM0_REG,0x924)
REGDEF_OFFSET(LCD_G_GAMMA_PRM1_REG,0x928)
REGDEF_OFFSET(LCD_G_GAMMA_PRM2_REG,0x92C)
REGDEF_OFFSET(LCD_G_GAMMA_PRM3_REG,0x930)
REGDEF_OFFSET(LCD_G_GAMMA_PRM4_REG,0x934)
REGDEF_OFFSET(LCD_G_GAMMA_PRM5_REG,0x938)
REGDEF_OFFSET(LCD_G_GAMMA_PRM6_REG,0x93C)
REGDEF_OFFSET(LCD_G_GAMMA_PRM7_REG,0x940)
REGDEF_OFFSET(LCD_B_GAMMA_PRM0_REG,0x948)
REGDEF_OFFSET(LCD_B_GAMMA_PRM1_REG,0x94C)
REGDEF_OFFSET(LCD_B_GAMMA_PRM2_REG,0x950)
REGDEF_OFFSET(LCD_B_GAMMA_PRM3_REG,0x954)
REGDEF_OFFSET(LCD_B_GAMMA_PRM4_REG,0x958)
REGDEF_OFFSET(LCD_B_GAMMA_PRM5_REG,0x95C)
REGDEF_OFFSET(LCD_B_GAMMA_PRM6_REG,0x960)
REGDEF_OFFSET(LCD_B_GAMMA_PRM7_REG,0x964)
REGDEF_BEGIN(LCD_RGB_GAMMA_PRM0_REG)
REGDEF_BIT(gamma0, 8)
REGDEF_BIT(gamma1, 8)
REGDEF_BIT(gamma2, 8)
REGDEF_BIT(gamma3, 8)
REGDEF_END(LCD_RGB_GAMMA_PRM0_REG)

REGDEF_OFFSET(LCD_R_GAMMA_PRM8_REG,0x920)
REGDEF_OFFSET(LCD_G_GAMMA_PRM8_REG,0x944)
REGDEF_OFFSET(LCD_B_GAMMA_PRM8_REG,0x968)
REGDEF_BEGIN(LCD_R_GAMMA_PRM8_REG)
REGDEF_BIT(gamma32, 8)
REGDEF_BIT(, 24)
REGDEF_END(LCD_R_GAMMA_PRM8_REG)

REGDEF_OFFSET(LCD_P2I_CTRL_REG,0x970)
REGDEF_BEGIN(LCD_P2I_CTRL_REG)
REGDEF_BIT(pif_coef0, 4)
REGDEF_BIT(pif_coef1, 4)
REGDEF_BIT(, 23)
REGDEF_BIT(vpi_en, 1)
REGDEF_END(LCD_P2I_CTRL_REG)

REGDEF_OFFSET(LCD_FD_EN_REG,0xB00)
REGDEF_BEGIN(LCD_FD_EN_REG)
REGDEF_BIT(fd0, 1)
REGDEF_BIT(fd1, 1)
REGDEF_BIT(fd2, 1)
REGDEF_BIT(fd3, 1)
REGDEF_BIT(fd4, 1)
REGDEF_BIT(fd5, 1)
REGDEF_BIT(fd6, 1)
REGDEF_BIT(fd7, 1)
REGDEF_BIT(fd8, 1)
REGDEF_BIT(fd9, 1)
REGDEF_BIT(fd10, 1)
REGDEF_BIT(fd11, 1)
REGDEF_BIT(fd12, 1)
REGDEF_BIT(fd13, 1)
REGDEF_BIT(fd14, 1)
REGDEF_BIT(fd15, 1)
REGDEF_BIT(fd16, 1)
REGDEF_BIT(fd17, 1)
REGDEF_BIT(fd18, 1)
REGDEF_BIT(fd19, 1)
REGDEF_BIT(fd20, 1)
REGDEF_BIT(fd21, 1)
REGDEF_BIT(fd22, 1)
REGDEF_BIT(fd23, 1)
REGDEF_BIT(fd24, 1)
REGDEF_BIT(fd25, 1)
REGDEF_BIT(fd26, 1)
REGDEF_BIT(fd27, 1)
REGDEF_BIT(fd28, 1)
REGDEF_BIT(fd29, 1)
REGDEF_BIT(fd30, 1)
REGDEF_BIT(fd31, 1)
REGDEF_END(LCD_FD_EN_REG)

REGDEF_OFFSET(LCD_FD0_ATTR0_REG,0xB04)
REGDEF_BEGIN(LCD_FD_ATTR0_REG)
REGDEF_BIT(fd_x, 12)
REGDEF_BIT(fd_y, 12)
REGDEF_BIT(border_h, 8)
REGDEF_END(LCD_FD_ATTR0_REG)

REGDEF_OFFSET(LCD_FD0_ATTR1_REG,0xB08)
REGDEF_BEGIN(LCD_FD_ATTR1_REG)
REGDEF_BIT(fd_w, 12)
REGDEF_BIT(fd_h, 12)
REGDEF_BIT(border_v, 8)
REGDEF_END(LCD_FD_ATTR1_REG)

REGDEF_OFFSET(LCD_FD0_ATTR2_REG,0xB0C)
REGDEF_BEGIN(LCD_FD_ATTR2_REG)
REGDEF_BIT(fd_y, 8)
REGDEF_BIT(fd_cb, 8)
REGDEF_BIT(fd_cr, 8)
REGDEF_BIT(, 8)
REGDEF_END(LCD_FD_ATTR2_REG)

REGDEF_OFFSET(LCD_AFBC_CTRL_REG,0xC00)
REGDEF_BEGIN(LCD_AFBC_CTRL_REG)
REGDEF_BIT(chn, 2)
REGDEF_BIT(, 2)
REGDEF_BIT(block_split, 1)
REGDEF_BIT(, 27)
REGDEF_END(LCD_AFBC_CTRL_REG)

REGDEF_OFFSET(LCD_AFBC_HDR_ADDR_REG,0xC10)
REGDEF_BEGIN(LCD_AFBC_HDR_ADDR_REG)
REGDEF_BIT(hdr_ba, 32)
REGDEF_END(LCD_AFBC_HDR_ADDR_REG)

REGDEF_OFFSET(LCD_AFBC_HDR_HADDR_REG,0xC14)
REGDEF_BEGIN(LCD_AFBC_HDR_HADDR_REG)
REGDEF_BIT(hdr_hba, 4)
REGDEF_BIT(, 28)
REGDEF_END(LCD_AFBC_HDR_HADDR_REG)

REGDEF_OFFSET(LCD_AFBC_CROP_REG,0xC18)
REGDEF_BEGIN(LCD_AFBC_CROP_REG)
REGDEF_BIT(left_crop, 8)
REGDEF_BIT(top_crop, 8)
REGDEF_BIT(, 16)
REGDEF_END(LCD_AFBC_CROP_REG)

REGDEF_OFFSET(LCD_AFBC_HDR_CKSUM_REG,0xC1C)
REGDEF_OFFSET(LCD_AFBC_BDY_CKSUM_REG,0xC20)
REGDEF_OFFSET(LCD_AFBC_DATA_CKSUM_REG,0xC24)
REGDEF_OFFSET(LCD_AFBC_DOUT_CKSUM_REG,0xC28)
REGDEF_BEGIN(LCD_AFBC_CKSUM_REG)
REGDEF_BIT(checksum, 32)
REGDEF_END(LCD_AFBC_CKSUM_REG)


REGDEF_OFFSET(LCD_MG0_CTRL0_REG,0x1000)
REGDEF_BEGIN(LCD_MG_CTRL0_REG)
REGDEF_BIT(mg_en, 1)
REGDEF_BIT(, 7)
REGDEF_BIT(mg_stx, 4)
REGDEF_BIT(, 4)
REGDEF_BIT(mg_lofs, 16)
REGDEF_END(LCD_MG_CTRL0_REG)

REGDEF_OFFSET(LCD_MG0_CTRL1_REG,0x1004)
REGDEF_BEGIN(LCD_MG_CTRL1_REG)
REGDEF_BIT(mg_w, 16)
REGDEF_BIT(mg_h, 16)
REGDEF_END(LCD_MG_CTRL1_REG)

REGDEF_OFFSET(LCD_MG0_CTRL2_REG,0x1008)
REGDEF_BEGIN(LCD_MG_CTRL2_REG)
REGDEF_BIT(mg_sx, 16)
REGDEF_BIT(mg_sy, 16)
REGDEF_END(LCD_MG_CTRL2_REG)

REGDEF_OFFSET(LCD_MG0_CTRL3_REG,0x100C)
REGDEF_BEGIN(LCD_MG_CTRL3_REG)
REGDEF_BIT(mg_ex, 16)
REGDEF_BIT(mg_ey, 16)
REGDEF_END(LCD_MG_CTRL3_REG)

REGDEF_OFFSET(LCD_MG0_Y_ADDR_REG,0x1010)
REGDEF_BEGIN(LCD_MG_Y_ADDR_REG)
REGDEF_BIT(mg_y_ba, 32)
REGDEF_END(LCD_MG_Y_ADDR_REG)

REGDEF_OFFSET(LCD_MG0_Y_HADDR_REG,0x1014)
REGDEF_BEGIN(LCD_MG_Y_HADDR_REG)
REGDEF_BIT(mg_y_hba, 4)
REGDEF_BIT(, 28)
REGDEF_END(LCD_MG_Y_HADDR_REG)

REGDEF_OFFSET(LCD_MG0_UV_ADDR_REG,0x1018)
REGDEF_BEGIN(LCD_MG_UV_ADDR_REG)
REGDEF_BIT(mg_uv_ba, 32)
REGDEF_END(LCD_MG_UV_ADDR_REG)

REGDEF_OFFSET(LCD_MG0_UV_HADDR_REG,0x101C)
REGDEF_BEGIN(LCD_MG_UV_HADDR_REG)
REGDEF_BIT(mg_uv_hba, 4)
REGDEF_BIT(, 28)
REGDEF_END(LCD_MG_UV_HADDR_REG)

REGDEF_OFFSET(LCD_PAL_RAM_REG,0xF000)
REGDEF_BEGIN(LCD_PAL_RAM_REG)
REGDEF_BIT(palette_entry0, 16)
REGDEF_BIT(palette_entry1, 16)
REGDEF_END(LCD_PAL_RAM_REG)


//
//0x10 System Clock Rate Register
//
#define PLL_SYS_CR_REG_OFS              0x10
REGDEF_BEGIN(PLL_SYS_CR_REG)
REGDEF_BIT(DONTCARE, 32)
REGDEF_END(PLL_SYS_CR_REG)

REGDEF_BEGIN(PLL_PLL2_CR0_REG)
REGDEF_BIT(PLL_RATIO0, 8)
REGDEF_BIT(reserved1, 24)
REGDEF_END(PLL_PLL2_CR0_REG)

REGDEF_BEGIN(PLL_PLL2_CR1_REG)
REGDEF_BIT(PLL_RATIO1, 8)
REGDEF_BIT(reserved1, 24)
REGDEF_END(PLL_PLL2_CR1_REG)

REGDEF_BEGIN(PLL_PLL2_CR2_REG)
REGDEF_BIT(PLL_RATIO2, 8)
REGDEF_BIT(reserved1, 24)
REGDEF_END(PLL_PLL2_CR2_REG)
//
//0x68 ~ 0x6C Reserved Register
//

//
//0x70 Clock Enable Register 0
//
#define PLL_CLKEN0_REG_OFS              0x70
REGDEF_BEGIN(PLL_CLKEN0_REG)
REGDEF_BIT(DONTCARE, 32)
REGDEF_END(PLL_CLKEN0_REG)


//
//0x00 PLL power enable Register
//
#define PLL_PLL_PWREN_REG_OFS           0x00
REGDEF_BEGIN(PLL_PLL_PWREN_REG)
REGDEF_BIT(DONTCARE, 32)
REGDEF_END(PLL_PLL_PWREN_REG)

//
//0x04 PLL Status Register
//
#define PLL_PLL_STATUS_REG_OFS          0x04
REGDEF_BEGIN(PLL_PLL_STATUS_REG)
REGDEF_BIT(DONTCARE, 32)
REGDEF_END(PLL_PLL_STATUS_REG)



#endif
