#define CONFIG_MODEL_NVT_FPGA_S3

/* NVT board configuration */
#define CONFIG_MEM_SIZE				_BOARD_DRAM_SIZE_
/* 6MB for kernel image */
#define CONFIG_NVT_UIMAGE_SIZE			(SZ_1M * 6)
/* We have two DSP cores can be used here. The DSP address definition only needs to be defined in first DSP base address */
#if _BOARD_DSP1_ADDR_ > _BOARD_DSP2_ADDR_
	#define CONFIG_DSP_SDRAM_BASE		_BOARD_DSP2_ADDR_
#else
	#define CONFIG_DSP_SDRAM_BASE		_BOARD_DSP1_ADDR_
#endif
#define CONFIG_DSP_SDRAM_SIZE			(_BOARD_DSP1_SIZE_ + _BOARD_DSP2_SIZE_)
#define CONFIG_RAMDISK_SDRAM_BASE		_BOARD_RAMDISK_ADDR_
#define CONFIG_RAMDISK_SDRAM_SIZE		_BOARD_RAMDISK_SIZE_
#define CONFIG_ITRON_SDRAM_BASE			_BOARD_UITRON_ADDR_
#define CONFIG_ITRON_SDRAM_SIZE			_BOARD_UITRON_SIZE_
/* temp buffer for all-in-one T.bin boot requirement */
#define CONFIG_NVT_RUNFW_SDRAM_BASE		(CONFIG_ITRON_SDRAM_BASE + (SZ_1M * 40))
#define CONFIG_UBOOT_SDRAM_BASE			_BOARD_UBOOT_ADDR_
#define CONFIG_UBOOT_SDRAM_SIZE			_BOARD_UBOOT_SIZE_
#define CONFIG_LINUX_SDRAM_BASE			_BOARD_LINUX_ADDR_
#define CONFIG_LINUX_SDRAM_SIZE			_BOARD_LINUX_SIZE_
#define CONFIG_LINUX_SDRAM_START		(CONFIG_UBOOT_SDRAM_BASE - CONFIG_NVT_UIMAGE_SIZE)
#define CONFIG_LINUX_SDRAM_MEMRESERVED_BASE	(_BOARD_DRAM_SIZE_ - CONFIG_DSP_SDRAM_SIZE - _BOARD_RAMDISK_SIZE_ - _BOARD_UITRON_RESV_SIZE_)
#define CONFIG_LINUX_SDRAM_MEMRESERVED_SIZE	_BOARD_UITRON_RESV_SIZE_

#define CONFIG_SMEM_SDRAM_BASE			_BOARD_IPC_ADDR_
#define CONFIG_MODELEXT_SDRAM_BASE		CONFIG_SMEM_SDRAM_BASE
#define CONFIG_MODELEXT_SDRAM_SIZE		0x1000
#define CONFIG_NVTIPC_SHARED_MEM_ADDR		0x00080000
#define CONFIG_NVTIPC_SHARED_MEM_SIZE		0x1000
#define CONFIG_SMEM_SDRAM_SIZE			_BOARD_IPC_SIZE_

#define CONFIG_MODELEXT_SPINAND_BASE		0x40000

/* FLASH        FileSystem */
#ifdef CONFIG_NVT_SPI_NAND
#define CONFIG_CMD_NAND
#define CONFIG_SYS_MAX_NAND_DEVICE		1
#endif

#define CONFIG_SYS_NAND_BASE			0xF0400000
#define CONFIG_SYS_HZ_CLOCK			24000000
