/*
	Register definition header file for CG module of NA51055.

	This file is the header file that define the address offset
	definition of registers of CG module.

	@file       cg-reg.h

	Copyright   Novatek Microelectronics Corp. 2018.  All rights reserved
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 as
	published by the Free Software Foundation.
*/

#ifndef _CG_REG_H
#define _CG_REG_H

#include "hardware.h"

#define CG_CPU_RATIO  	0x20

/* Reset or not during clk_prepare() */
#define DO_RESET        1
#define NOT_RESET       0

/* Enable or not during clock tree construction */
#define DO_DISABLE      2
#define DO_ENABLE       1
#define NOT_ENABLE      0 // keep previous value

/* Enable or not during clock tree construction */
#define DO_AUTOGATING   1
#define NOT_AUTOGATING  0

#define NVT_PLL_MAX_NUMBER 21

#define STBC_BASE_OFFSET 0x00560000 // base address from 0xF0020000 to 0xF0580000


/* PLL */
#define CG_PLL_EN_REG_OFFSET				(0x00+STBC_BASE_OFFSET)
#define CG_PLL_STAT_REG_OFFSET				(0x04+STBC_BASE_OFFSET)

/* Clock source control */
#define CG_SYS_CLK_RATE_REG_OFFSET			0x10
#define CG_IPP_CLK_RATE_REG0_OFFSET			0x14
#define CG_IPP_CLK_RATE_REG1_OFFSET			0x18
#define CG_CODEC_CLK_RATE_REG_OFFSET		0x1C
#define CG_PERI_CLK_RATE_REG0_OFFSET		0x20
#define CG_PERI_CLK_RATE_REG1_OFFSET		0x24
#define CG_PERI_CLK_RATE_REG2_OFFSET		0x28
#define CG_PERI_CLK_RATE_REG3_OFFSET		0x2C

/* Clock rate control */
#define CG_PWM_CLK_DIV_REG0_OFFSET			0x30
#define CG_PWM_CLK_DIV_REG1_OFFSET			0x34
#define CG_PWM_CLK_DIV_REG2_OFFSET			0x38
#define CG_DAI_MCLK_DIV_REG_OFFSET			0x3C
#define CG_SDIO_CLK_DIV_REG_OFFSET			0x40
#define CG_UART_CLK_DIV_REG_OFFSET			0x44
#define CG_PERI_CLK_DIV_REG0_OFFSET			0x48
#define CG_DISP_CLK_DIV_REG_OFFSET			0x4C
#define CG_PERI_CLK_DIV_REG2_OFFSET			0x50
#define CG_DSP_CLK_DIV_REG_OFFSET			0x54
#define CG_DAI_CLK_DIV_REG0_OFFSET			0x58
#define CG_SDIO_CLK_DIV_REG1_OFFSET			0x5C
#define CG_UART_CLK_DIV_REG1_OFFSET			0x60
#define CG_SPI_CLK_DIV_REG0_OFFSET			0x64
#define CG_SPI_CLK_DIV_REG1_OFFSET			0x68
#define CG_SPI_CLK_DIV_REG2_OFFSET			0x6C

/* Clock enable/disable control */
#define CG_CLK_EN_REG0_OFFSET				0x70
#define CG_CLK_EN_REG1_OFFSET				0x74
#define CG_CLK_EN_REG2_OFFSET				0x78
#define CG_CLK_EN_REG3_OFFSET				0x7C
#define CG_CLK_EN_REG4_OFFSET				0x80
#define CG_CLK_EN_REG5_OFFSET				0x84
#define CG_CLK_EN_REG6_OFFSET				0x88


/* Module reset control */
#define CG_SYS_RESET_REG0_OFFSET			0x90
#define CG_SYS_RESET_REG1_OFFSET			0x94
#define CG_SYS_RESET_REG2_OFFSET			0x98
#define CG_SYS_RESET_REG3_OFFSET			0x9C
#define CG_SYS_RESET_REG4_OFFSET			0xA0
#define CG_SYS_RESET_REG5_OFFSET			0xA4

/* Low power control */
#define CG_SLEEP_MODE_REG_OFFSET			(0xB0+STBC_BASE_OFFSET)
#define CG_CLK_AUTO_GATING_REG0_OFFSET		0xC0
#define CG_CLK_AUTO_GATING_REG1_OFFSET		0xC4
#define CG_CLK_AUTO_GATING_REG2_OFFSET		0xC8

#define CG_APB_CLK_AUTO_GATING_REG0_OFFSET	0xD0
#define CG_APB_CLK_AUTO_GATING_REG1_OFFSET	0xD4
#define CG_APB_CLK_AUTO_GATING_REG2_OFFSET	0xD8
#define CG_APB_CLK_AUTO_GATING_REG3_OFFSET	0xDC

/* Extclk source control */
#define CG_EXT_CLK_OUT_SRC_REG_OFFSET		0xF0

#define CG_PLL_MCU_FLAG_REG_OFFSET			0x1180

/* PLL clock rate control */
#define CG_PLL0_CLK_RATE0_REG_OFFSET 			0x4420
#define CG_PLL2_CLK_RATE0_REG_OFFSET 			0x44A0
#define CG_PLL3_CLK_RATE0_REG_OFFSET			0x44E0
#define CG_PLL4_CLK_RATE0_REG_OFFSET			0x4520
#define CG_PLL5_CLK_RATE0_REG_OFFSET			0x4560
#define CG_PLL6_CLK_RATE0_REG_OFFSET			0x45A0
#define CG_PLL7_CLK_RATE0_REG_OFFSET			0x45E0
#define CG_PLL8_CLK_RATE0_REG_OFFSET			0x4620
#define CG_PLL9_CLK_RATE0_REG_OFFSET			0x4660
#define CG_PLL10_CLK_RATE0_REG_OFFSET			0x46A0
#define CG_PLL11_CLK_RATE0_REG_OFFSET			0x46E0
#define CG_PLL12_CLK_RATE0_REG_OFFSET			0x4720
#define CG_PLL13_CLK_RATE0_REG_OFFSET			0x4760
#define CG_PLL14_CLK_RATE0_REG_OFFSET			0x47A0
#define CG_PLL15_CLK_RATE0_REG_OFFSET			0x47E0
#define CG_PLL16_CLK_RATE0_REG_OFFSET			0x4820
#define CG_PLL17_CLK_RATE0_REG_OFFSET			0x4860
#define CG_PLL18_CLK_RATE0_REG_OFFSET			0x48A0
#define CG_PLL19_CLK_RATE0_REG_OFFSET			0x48E0
#define CG_PLL20_CLK_RATE0_REG_OFFSET			0x4920
#define CG_PLL21_CLK_RATE0_REG_OFFSET           0x4960

/* Extclk source control */
#define CG_EXT_IPP_CLK_RATE_REG0_OFFSET			0x200
#define CG_EXT_IPP_CLK_RATE_REG1_OFFSET			0x204
#define CG_EXT_IPP_CLK_RATE_REG2_OFFSET			0x208
#define CG_EXT_IPP_CLK_RATE_REG3_OFFSET			0x20C

/* Extclk rate control */
#define CG_EXT_IPP_CLK_DIV_REG0_OFFSET			0x300
#define CG_EXT_IPP_CLK_DIV_REG1_OFFSET			0x304
#define CG_EXT_IPP_CLK_DIV_REG2_OFFSET			0x308
#define CG_EXT_IPP_CLK_DIV_REG3_OFFSET			0x30C

/* STBC control*/
#define CG_STBC_CLK_EN_REG_OFFSET                       (0x140+STBC_BASE_OFFSET)
#define CG_STBC_APB_CLK_AUTO_GATING_REG_OFFSET          (0x148+STBC_BASE_OFFSET)

#define SPREAD_SPECTRUM_REG0_MINUS_OFFSET		(0x14) /* MPLL + 0xC */
#define SPREAD_SPECTRUM_REG1_MINUS_OFFSET		(0x10) /* MPLL + 0x10 */
#define SPREAD_SPECTRUM_REG2_MINUS_OFFSET		(0xC)  /* MPLL + 0x14 */
#define SPREAD_SPECTRUM_REG3_MINUS_OFFSET		(0x4)  /* MPLL + 0x1C */
#define SPREAD_SPECTRUM_STEP_OFFSET				(0x4)
#define SPREAD_SPECTRUM_NEW_MODE_OFFSET			(0x2)
#define SPREAD_SPECTRUM_DSSC_OFFSET				(0x7)
#define SPREAD_SPECTRUM_PERIOD_VALUE			(0xFF)

#endif
