/**
    NVT hardware description
    To define NVT platform IO address
    @file      hardware.h
    @ingroup
    @note

    Copyright   Novatek Microelectronics Corp. 2019.  All rights reserved.
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as
    published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_PLAT_HARDWARE_H
#define __ASM_ARCH_PLAT_HARDWARE_H

/*
 * ----------------------------------------------------------------------------
 * Interrupts (GIC)
 * ----------------------------------------------------------------------------
 */
#define NVT_GIC_DIST_PHYS_BASE  (0x2fff01000)
#define NVT_GIC_CPU_PHYS_BASE   (0x2fff02000)

#define NVT_CPU_REG_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x1400000)
/*
 * ----------------------------------------------------------------------------
 * Peripheral mapping address
 * ----------------------------------------------------------------------------
 */
#define NVT_PERIPHERAL_PHYS_BASE    (0x2f0000000)

#define NVT_TOP_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x0010000)

#define NVT_SRAM_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0011000)

#define NVT_CG_BASE_PHYS        (NVT_PERIPHERAL_PHYS_BASE + 0x0020000)

#define NVT_PAD_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x0030000)

#define NVT_TIMER_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x0040000)

#define NVT_WDT_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x0050000)

#define NVT_GPIO_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0070000)

#define NVT_INTC_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0080000)

#define NVT_CC_BASE_PHYS        (NVT_PERIPHERAL_PHYS_BASE + 0x0090000)

#define NVT_HVYLOAD_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x00A0000)

#define NVT_DRTC_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x00B0000)

#define NVT_TZPC_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x00C0000)

#define NVT_RTC_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x00F0000)

#define NVT_TIMER_2_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x0100000)

#define NVT_TIMER_3_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x0110000)

#define NVT_HVYLOAD_2_BASE_PHYS (NVT_PERIPHERAL_PHYS_BASE + 0x0120000)

#define NVT_HVYLOAD_3_BASE_PHYS (NVT_PERIPHERAL_PHYS_BASE + 0x0130000)

#define NVT_I2C6_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0200000)

#define NVT_PWM_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x0210000)

#define NVT_I2C1_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0220000)

#define NVT_SPI_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x0230000)

#define NVT_SIF_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x0240000)

#define NVT_SAR_ADC_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x0260000)

#define NVT_CSI_RX_BASE_PHYS    (NVT_PERIPHERAL_PHYS_BASE + 0x0280000)

#define NVT_UART1_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x0290000)

#define NVT_ADC_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x02A0000)

#define NVT_ETH_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x02B0000)

#define NVT_I2C7_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x02C0000)

#define NVT_I2C8_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x02D0000)

#define NVT_I2C9_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x02E0000)

#define NVT_I2C10_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x02F0000)

#define NVT_UART2_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x0300000)

#define NVT_UART3_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x0310000)

#define NVT_SPI2_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0320000)

#define NVT_CSI2_RX_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x0330000)

#define NVT_SPI3_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0340000)

#define NVT_I2C2_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0350000)

#define NVT_SPI4_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0360000)

#define NVT_UART4_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x0380000)

#define NVT_I2C3_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x03A0000)

#define NVT_I2C4_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x03B0000)

#define NVT_I2C5_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x03C0000)

#define NVT_SPI5_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x03D0000)

#define NVT_UART5_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x03E0000)

#define NVT_UART6_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x03F0000)

#define NVT_NAND_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0400000)

#define NVT_I2C11_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x0410000)

#define NVT_SDIO_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0420000)

#define NVT_ETH2_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0430000)

#define NVT_UART7_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x0470000)

#define NVT_UART8_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x0480000)

#define NVT_UART9_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x0490000)

#define NVT_CSI3_RX_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x04A0000)

#define NVT_CSI4_RX_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x04B0000)

#define NVT_CSI5_RX_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x04C0000)

#define NVT_SDIO2_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x0500000)

#define NVT_SDIO3_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x0510000)

#define NVT_SATA_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0590000)

#define NVT_USB2_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x05A0000)

#define NVT_USB3_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x05B0000)

#define NVT_PMC_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x05C0000)

#define NVT_SATACTL_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x05D0000)

#define NVT_USB2_PHY_BASE_PHYS  (NVT_PERIPHERAL_PHYS_BASE + 0x05E0000)

#define NVT_USB3_PHY_BASE_PHYS  (NVT_PERIPHERAL_PHYS_BASE + 0x05F0000)

#define NVT_PMC_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x05C0000)

#define NVT_STBC_CG_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x0580000)

#define NVT_EAC_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x0640000)

#define CORE_REG_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0xFE41000)

#define NVT_MAU_PHY_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x00D8000)

#define NVT_RTC_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x00F0000)

#define NVT_HDMI_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0820000)

#define NVT_DSI_PHY_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x0840000)

#define NVT_CSI_TX_BASE_PHYS    (NVT_PERIPHERAL_PHYS_BASE + 0x0850000)

#define NVT_SENIF_PHY_BASE_PHYS (NVT_PERIPHERAL_PHYS_BASE + 0x06B0000)

#define NVT_SENIF_PHY2_BASE_PHYS (NVT_PERIPHERAL_PHYS_BASE + 0x06C0000)


#endif  /* __ASM_ARCH_PLAT_HARDWARE_H */
