/**
    NVT hardware description
    To define NVT platform IO address
    @file      hardware.h
    @ingroup
    @note

    Copyright   Novatek Microelectronics Corp. 2019.  All rights reserved.
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as
    published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_PLAT_HARDWARE_H
#define __ASM_ARCH_PLAT_HARDWARE_H

/*
 * ----------------------------------------------------------------------------
 * Interrupts (GIC)
 * ----------------------------------------------------------------------------
 */
#define NVT_GIC_DIST_PHYS_BASE  (0x2fff01000)
#define NVT_GIC_CPU_PHYS_BASE   (0x2fff02000)

#define NVT_CPU_REG_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0xFE40000)
/*
 * ----------------------------------------------------------------------------
 * Peripheral mapping address
 * ----------------------------------------------------------------------------
 */
#define NVT_PERIPHERAL_PHYS_BASE    (0x2f0000000)

#define NVT_TOP_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x0010000)

#define NVT_SRAM_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0011000)

#define NVT_CG_BASE_PHYS        (NVT_PERIPHERAL_PHYS_BASE + 0x0020000)

#define NVT_PAD_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x0030000)

#define NVT_GPIO_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0040000)

#define NVT_WDT_BASE_PHYS       (NVT_PERIPHERAL_PHYS_BASE + 0x0060000)

#define NVT_TIMER_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE + 0x0100000)

#define NVT_HRTIMER_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x0101000)

#define NVT_HRTIMER2_BASE_PHYS  (NVT_PERIPHERAL_PHYS_BASE + 0x0102000)

#define NVT_HRTIMER3_BASE_PHYS  (NVT_PERIPHERAL_PHYS_BASE + 0x0103000)

#define NVT_HRTIMER4_BASE_PHYS  (NVT_PERIPHERAL_PHYS_BASE + 0x0104000)

#define NVT_HRTIMER5_BASE_PHYS  (NVT_PERIPHERAL_PHYS_BASE + 0x0105000)

#define NVT_HRTIMER6_BASE_PHYS  (NVT_PERIPHERAL_PHYS_BASE + 0x0106000)

#define NVT_TIMER2_BASE_PHYS 	(NVT_PERIPHERAL_PHYS_BASE + 0x0107000)

#define NVT_CC_BASE_PHYS        (NVT_PERIPHERAL_PHYS_BASE + 0x0110000)

#define NVT_DRTC_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0111000)

#define NVT_INTC_DSP1_BASE_PHYS (NVT_PERIPHERAL_PHYS_BASE + 0x0112000)

#define NVT_INTC_DSP2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0113000)

#define NVT_INTC_N25_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0114000)

#define NVT_MSI_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0115000)

#define NVT_MSI2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0116000)

#define NVT_DOORBELL_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0117000)

#define NVT_PWM_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0120000)

#define NVT_REMOTE_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0121000)

#define NVT_TRNG_BASE_PHYS 	(NVT_PERIPHERAL_PHYS_BASE + 0x0122000)

#define NVT_UART1_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0130000)

#define NVT_UART2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0131000)

#define NVT_UART3_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0132000)

#define NVT_UART4_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0133000)

#define NVT_UART5_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0134000)

#define NVT_UART6_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0135000)

#define NVT_UART7_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0136000)

#define NVT_UART8_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0137000)

#define NVT_UART9_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0138000)

#define NVT_I2C1_BASE_PHYS 	(NVT_PERIPHERAL_PHYS_BASE + 0x0140000)

#define NVT_I2C2_BASE_PHYS 	(NVT_PERIPHERAL_PHYS_BASE + 0x0141000)

#define NVT_I2C3_BASE_PHYS 	(NVT_PERIPHERAL_PHYS_BASE + 0x0142000)

#define NVT_I2C4_BASE_PHYS 	(NVT_PERIPHERAL_PHYS_BASE + 0x0143000)

#define NVT_I2C5_BASE_PHYS 	(NVT_PERIPHERAL_PHYS_BASE + 0x0144000)

#define NVT_I2C6_BASE_PHYS 	(NVT_PERIPHERAL_PHYS_BASE + 0x0145000)

#define NVT_I2C7_BASE_PHYS 	(NVT_PERIPHERAL_PHYS_BASE + 0x0146000)

#define NVT_I2C8_BASE_PHYS 	(NVT_PERIPHERAL_PHYS_BASE + 0x0147000)

#define NVT_I2C9_BASE_PHYS 	(NVT_PERIPHERAL_PHYS_BASE + 0x0148000)

#define NVT_I2C10_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0149000)

#define NVT_I2C11_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x014a000)

#define NVT_I2C12_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x014b000)

#define NVT_I2C13_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x014c000)

#define NVT_I2C14_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x014d000)

#define NVT_I2C15_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x014e000)

#define NVT_I2C16_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x014f000)

#define NVT_I2C17_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0150000)

#define NVT_I2C18_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0151000)

#define NVT_I2C19_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0152000)

#define NVT_I2C20_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0153000)

#define NVT_SPI_BASE_PHYS  	(NVT_PERIPHERAL_PHYS_BASE + 0x0158000)

#define NVT_SPI2_BASE_PHYS 	(NVT_PERIPHERAL_PHYS_BASE + 0x0159000)

#define NVT_SPI3_BASE_PHYS 	(NVT_PERIPHERAL_PHYS_BASE + 0x015a000)

#define NVT_SPI4_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x015b000)

#define NVT_SPI5_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x015c000)

#define NVT_SIF_BASE_PHYS   	(NVT_PERIPHERAL_PHYS_BASE + 0x015D000)

#define NVT_SDP_BASE_PHYS   	(NVT_PERIPHERAL_PHYS_BASE + 0x015E000)

#define NVT_EAC_BASE_PHYS   	(NVT_PERIPHERAL_PHYS_BASE + 0x0160000)

#define NVT_DAI_BASE_PHYS   	(NVT_PERIPHERAL_PHYS_BASE + 0x0161000)

#define NVT_DAI2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0162000)

#define NVT_DAI3_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0163000)

#define NVT_DAI4_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0164000)

#define NVT_DAI5_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0165000)

#define NVT_TSE_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0170000)

#define NVT_UVCP_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0171000)

#define NVT_UVCP2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0172000)

#define NVT_GPENC_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0173000)

#define NVT_GPENC2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0174000)

#define NVT_GRAPHIC_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0175000)

#define NVT_GRAPHIC2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0176000)

#define NVT_GRAPHIC3_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0177000)

#define NVT_N25_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0180000)

#define NVT_AGE_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0190000)

#define NVT_MAU_PHY_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0200000)

#define NVT_MAU2_PHY_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0210000)

#define NVT_TZPC_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE + 0x0220000)

#define NVT_EFUSE_PHY_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0240000)

#define NVT_SCE_PHY_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0250000)

#define NVT_HASH_PHY_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0260000)

#define NVT_RSA_PHY_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0270000)

#define NVT_HWCP_PHY_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0280000)

#define NVT_ETH_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x04A0000)

#define NVT_ETH2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x04B0000)

#define NVT_MALI_APB_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0600000)

#define NVT_DSP_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0700000)

#define NVT_OCEM_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0710000)

#define NVT_DSP2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0800000)

#define NVT_OCEM2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0810000)

#define NVT_VDEC_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0900000)

#define NVT_JPEG_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0910000)

#define NVT_JPEG2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0920000)

#define NVT_JPEG_LITE_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0930000)

#define NVT_USB2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0940000)

#define NVT_USB3_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0950000)

#define NVT_USB2_A_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0960000)

#define NVT_USB3_A_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0970000)

#define NVT_SDIO3_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0980000)

#define NVT_NAND_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0990000)

#define NVT_DSI_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x09A0000)

#define NVT_DSI2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x09B0000)

#define NVT_CSITX_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x09C0000)

#define NVT_CSITX2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x09D0000)

#define NVT_DSIPHY_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x09E0000)

#define NVT_VENC_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0A00000)

#define NVT_VTRC_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0A10000)

#define NVT_TSEN_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0A20000)

#define NVT_VPE3_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0B00000)

#define NVT_USB3_2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0B10000)

#define NVT_SATA_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0B20000)

#define NVT_SATA2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0B30000)

#define NVT_PCIE_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0B40000)

#define NVT_PCIE2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0B50000)

#define NVT_RTC_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0B60000)

#define NVT_PWBC_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0B70000)

#define NVT_USB3_2A_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0B80000)

#define NVT_SATA_A_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0B90000)

#define NVT_SATA2_A_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0BA0000)

#define NVT_ADC_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0BB0000)

#define NVT_PCIEPHY_L0_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0BD0000)

#define NVT_PCIEPHY_L1_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0BE0000)

#define NVT_IFE_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0C00000)

#define NVT_ISE_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0C10000)

#define NVT_DRE_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0C20000)

#define NVT_VPE_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0C30000)

#define NVT_IPE_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0C40000)

#define NVT_IME_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0C50000)

#define NVT_SYS_SRAM_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0D00000)

#define NVT_IFE2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0E00000)

#define NVT_ISE2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0E10000)

#define NVT_VPE2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0E20000)

#define NVT_TRICKBOX_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0F00000)

#define NVT_IPE2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0F10000)

#define NVT_IME2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0F20000)

#define NVT_SDIO_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0F30000)

#define NVT_SDIO2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0F40000)

#define NVT_MALI_AXI_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x1400000)

#define NVT_N25_SRAM_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x1800000)

#define NVT_PCIE_DBI_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x2000000)

#define NVT_PCIE2_DBI_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x2400000)

#define NVT_PCIE_PHY_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0BD0000)
#define NVT_PCIE2_PHY_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0BE0000)

#define NVT_MTIMER_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0xFE00000)

#define NVT_DDR_PHY_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0x0208000)

#define NVT_DDR_PHY2_BASE_PHYS  (NVT_PERIPHERAL_PHYS_BASE + 0x0218000)

#define NVT_HDMI_BASE_PHYS      (NVT_PERIPHERAL_PHYS_BASE+0x0480000)

#define NVT_HDMI2_BASE_PHYS     (NVT_PERIPHERAL_PHYS_BASE+0x0490000)

#define NVT_SENPHY_BASE_PHYS    (NVT_PERIPHERAL_PHYS_BASE+0x0320000)

#define NVT_SENPHY2_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE+0x0330000)

#define NVT_SLVSEC_PHY_BASE_PHYS (NVT_PERIPHERAL_PHYS_BASE+0x0380000)

#endif  /* __ASM_ARCH_PLAT_HARDWARE_H */
