/**
    NVT hardware description
    To define NVT platform IO address
    @file      hardware.h
    @ingroup
    @note

    Copyright   Novatek Microelectronics Corp. 2023.  All rights reserved.
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as
    published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_PLAT_HARDWARE_H
#define __ASM_ARCH_PLAT_HARDWARE_H

/*
 * ----------------------------------------------------------------------------
 * Interrupts (GIC)
 * ----------------------------------------------------------------------------
 */
#define NVT_GIC_DIST_PHYS_BASE  (0x2fff01000)
#define NVT_GIC_CPU_PHYS_BASE   (0x2fff02000)

#define NVT_CPU_REG_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0xFE40000)
/*
 * ----------------------------------------------------------------------------
 * Peripheral mapping address
 * ----------------------------------------------------------------------------
 */
#define NVT_PERIPHERAL_PHYS_BASE		(0x2f0000000)

#define NVT_TOP_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0010000)

#define NVT_SRAM_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0011000)

#define NVT_CG_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0020000)

#define NVT_PAD_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0030000)

#define NVT_GPIO_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0040000)

#define NVT_TIMER_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0100000)

#define NVT_HRTIMER_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0101000)

#define NVT_HRTIMER2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0102000)

#define NVT_HRTIMER3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0103000)

#define NVT_HRTIMER4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0104000)

#define NVT_HRTIMER5_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0105000)

#define NVT_HRTIMER6_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0106000)

#define NVT_HRTIMER7_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0107000)

#define NVT_HRTIMER8_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0108000)

#define NVT_HRTIMER9_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0109000)

#define NVT_HRTIMER10_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x010A000)

#define NVT_UART1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0110000)

#define NVT_UART2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0111000)

#define NVT_UART3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0112000)

#define NVT_UART4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0113000)

#define NVT_UART5_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0114000)

#define NVT_UART6_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0115000)

#define NVT_I2C1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0120000)

#define NVT_I2C2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0121000)

#define NVT_I2C3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0122000)

#define NVT_I2C4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0123000)

#define NVT_I2C5_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0124000)

#define NVT_SPI1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0130000)

#define NVT_SPI2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0131000)

#define NVT_SPI3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0132000)

#define NVT_SPI4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0133000)

#define NVT_SPI5_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0134000)

#define NVT_SDP_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0135000)

#define NVT_PWM_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0140000)

#define NVT_RMT_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0141000)

#define NVT_SIF_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0142000)

#define NVT_DRTC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0143000)

#define NVT_EAC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0150000)

#define NVT_DAI_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0151000)

#define NVT_EFUSE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0160000)

#define NVT_SCE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0161000)

#define NVT_HASH_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0162000)

#define NVT_RSA_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0163000)

#define NVT_ECDSA_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0164000)

#define NVT_TRNG_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0165000)

#define NVT_TZPC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0166000)

#define NVT_HVYLD_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0170000)

#define NVT_HVYLD2_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0171000)

#define NVT_HVYLD3_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0172000)

#define NVT_MAU_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0180000)

#define NVT_MAU_PHY_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0188000)

#define NVT_IDE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0190000)

#define NVT_MI_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x01A0000)

#define NVT_ETH_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x01B0000)

#define NVT_MCU_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0200000)

#define NVT_CC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0210000)

#define NVT_MCU_SRAM_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0220000)

#define NVT_STBC_CG_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0230000)

#define NVT_WDT_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x0240000)

#define NVT_USB3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0280000)

#define NVT_USB3_A_BASE_PHYS	(NVT_PERIPHERAL_PHYS_BASE + 0x0290000)

#define NVT_RTC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x02B0000)

#define NVT_SIE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0310000)

#define NVT_SIE2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0311000)

#define NVT_SIE3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0312000)

#define NVT_SIE4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0313000)

#define NVT_SIE5_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0314000)

#define NVT_VIE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0320000)

#define NVT_TGE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0330000)

#define NVT_IFE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0340000)

#define NVT_NAND_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0350000)

#define NVT_SDIO3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0360000)

#define NVT_DRE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0370000)

#define NVT_ISE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0380000)

#define NVT_IPE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0400000)

#define NVT_IME_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0410000)

#define NVT_SDIO_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0420000)

#define NVT_SDIO2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0430000)

#define NVT_ADC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0440000)

#define NVT_VPE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0500000)

#define NVT_VENC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0600000)

#define NVT_JM_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0700000)

#define NVT_JMISP_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0710000)

#define NVT_UTL_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0720000)

#define NVT_ROU_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0730000)

#define NVT_CAL_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0740000)

#define NVT_LSU_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0750000)

#define NVT_PPU_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0760000)

#define NVT_CONV_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0800000)

#define CORE_REG_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0xFE41000)

#define NVT_SENPHY_BASE_PHYS    (NVT_PERIPHERAL_PHYS_BASE + 0x0308000)

#endif  /* __ASM_ARCH_PLAT_HARDWARE_H */
