/**
    NVT hardware description
    To define NVT platform IO address
    @file      hardware.h
    @ingroup
    @note

    Copyright   Novatek Microelectronics Corp. 2023.  All rights reserved.
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as
    published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_PLAT_HARDWARE_H
#define __ASM_ARCH_PLAT_HARDWARE_H

/*
 * ----------------------------------------------------------------------------
 * Interrupts (GIC)
 * ----------------------------------------------------------------------------
 */
#define NVT_GIC_DIST_PHYS_BASE  (0x4ff800000)

#define NVT_CPU_REG_BASE_PHYS   (NVT_PERIPHERAL_PHYS_BASE + 0xFF00000)
/*
 * ----------------------------------------------------------------------------
 * Peripheral mapping address
 * ----------------------------------------------------------------------------
 */
#define NVT_PERIPHERAL_PHYS_BASE		(0x4f0000000)

#define NVT_TOP_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0010000)

#define NVT_SRAM_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0011000)

#define NVT_CG_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0020000)

#define NVT_PAD_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0030000)

#define NVT_GPIO_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0040000)

#define NVT_TIMER_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0100000)

#define NVT_HRTIMER_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0101000)

#define NVT_HRTIMER2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0102000)

#define NVT_HRTIMER3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0103000)

#define NVT_HRTIMER4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0104000)

#define NVT_HRTIMER5_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0105000)

#define NVT_HRTIMER6_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0106000)

#define NVT_HRTIMER7_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0107000)

#define NVT_HRTIMER8_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0108000)

#define NVT_HRTIMER9_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0109000)

#define NVT_HRTIMER10_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x010A000)

#define NVT_CC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0110000)

#define NVT_DOORBELL_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0112000)

#define NVT_MSI_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0113000)

#define NVT_TRNG_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0114000)

#define NVT_PWM_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0120000)

#define NVT_REMOTE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0121000)

#define NVT_UART1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0130000)

#define NVT_UART2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0131000)

#define NVT_UART3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0132000)

#define NVT_UART4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0133000)

#define NVT_UART5_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0134000)

#define NVT_I2C1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0140000)

#define NVT_I2C2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0141000)

#define NVT_I2C3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0142000)

#define NVT_I2C4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0143000)

#define NVT_I2C5_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0144000)

#define NVT_I2C6_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0145000)

#define NVT_I2C7_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0146000)

#define NVT_I2C8_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0147000)

#define NVT_SPI1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0150000)

#define NVT_SPI2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0151000)

#define NVT_SDP_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0155000)

#define NVT_DAI1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0160000)

#define NVT_DAI2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0161000)

#define NVT_DAI3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0162000)

#define NVT_DAI4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0163000)

#define NVT_DAI5_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0164000)

#define NVT_GRAPHIC1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0170000)

#define NVT_GRAPHIC2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0171000)

#define NVT_GRAPHIC3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0172000)

#define NVT_GPENC1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0173000)

#define NVT_GPENC2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0174000)

#define NVT_GPENC3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0175000)

#define NVT_AGE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0180000)

#define NVT_JPEG1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0190000)

#define NVT_JPEG2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x01A0000)

#define NVT_MAU1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0200000)

#define NVT_MAU2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0210000)

#define NVT_EFUSE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0221000)

#define NVT_SCE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0222000)

#define NVT_HASH_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0223000)

#define NVT_RSA_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0224000)

#define NVT_ECDSA_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0225000)

#define NVT_HVYLD1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0230000)

#define NVT_HVYLD2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0231000)

#define NVT_HVYLD3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0232000)

#define NVT_HWCP_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x0240000)

#define NVT_NUE2_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x0250000)

#define NVT_IVE_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x0260000)

#define NVT_MDBC_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x0270000)

#define NVT_ISE_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x0280000)

#define NVT_XOR_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x0290000)

#define NVT_TZASC_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x02D0000)

#define NVT_TSEN_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x02E0000)

#define NVT_VENC_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x0300000)

#define NVT_PCIE1_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x0310000)

#define NVT_PCIE2_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x0320000)

#define NVT_PCIE3_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x0330000)

#define NVT_PCIE4_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x0340000)

#define NVT_PCIEPHY1_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x03B0000)

#define NVT_PCIEPHY2_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x03C0000)

#define NVT_PCIEPHY3_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x03D0000)

#define NVT_PCIEPHY4_BASE_PHYS 		(NVT_PERIPHERAL_PHYS_BASE + 0x03E0000)

#define NVT_LCD1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0400000)

#define NVT_LCD2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0410000)

#define NVT_LCD3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0420000)

#define NVT_DSC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0430000)

#define NVT_HDMI1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0440000)

#define NVT_HDMI2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0450000)

#define NVT_HDMI3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0460000)

#define NVT_HDMIPHY_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0470000)

#define NVT_USB2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0480000)

#define NVT_USB3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0490000)

#define NVT_SATA_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x04A0000)

#define NVT_USB2A_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x04C0000)

#define NVT_USB3A_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x04D0000)

#define NVT_SATAA_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x04E0000)

#define NVT_VPEL2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0500000)

#define NVT_XGMAC1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0510000)

#define NVT_XGMAC2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0520000)

#define NVT_SATA2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0530000)

#define NVT_SATA3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0540000)

#define NVT_SDIO1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0550000)

#define NVT_SDIO2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0560000)

#define NVT_NAND_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0570000)

#define NVT_XPCS1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x05B0000)

#define NVT_XPCS2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x05C0000)

#define NVT_SATA2A_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x05D0000)

#define NVT_SATA3A_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x05E0000)

#define NVT_MALI_APB_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0600000)

#define NVT_MALI_AXI_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0610000)

#define NVT_JM_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0700000)

#define NVT_UTL_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0710000)

#define NVT_ROU_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0720000)

#define NVT_CAL_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0730000)

#define NVT_PPU_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0740000)

#define NVT_LSU_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0750000)

#define NVT_JMISP_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0760000)

#define NVT_ROU2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0770000)

#define NVT_LSU2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0780000)

#define NVT_CONV_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0800000)

#define NVT_VPE_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0A00000)

#define NVT_USB2_2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0A10000)

#define NVT_USB3_2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0A20000)

#define NVT_SATA4_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0A30000)

#define NVT_SATA5_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0A40000)

#define NVT_SATA6_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0A50000)

#define NVT_ADC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0A60000)

#define NVT_RTC_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0A70000)

#define NVT_USB2_2A_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0AA0000)

#define NVT_USB3_2A_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0AB0000)

#define NVT_SATA4A_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0AC0000)

#define NVT_SATA5A_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0AD0000)

#define NVT_SATA6A_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0AE0000)

#define NVT_VPEL_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0B00000)

#define NVT_VDEC1_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0B10000)

#define NVT_VDEC2_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0C00000)

#define NVT_VDEC3_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0C10000)

#define NVT_SYS_SRAM_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0D00000)

#define NVT_TRICKBOX_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0F00000)

#define NVT_TCM_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x0F10000)

#define NVT_PCIE_DBI_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x2000000)

#define NVT_PCIE2_DBI_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x2400000)

#define NVT_PCIE3_DBI_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x2800000)

#define NVT_PCIE4_DBI_BASE_PHYS		(NVT_PERIPHERAL_PHYS_BASE + 0x2C00000)

#endif  /* __ASM_ARCH_PLAT_HARDWARE_H */
