#include "../stbc_platform.h"
#include <linux/semaphore.h>
#include <linux/spinlock.h>
#include <linux/delay.h>

#include <linux/soc/nvt/fmem.h>

#include <plat/hardware.h>
void __iomem *STBC_IOADDR_CG_REG_BASE;
void __iomem *STBC_IOADDR_STBC_REG_BASE;
void __iomem *STBC_IOADDR_STBC_CG_REG_BASE;
void __iomem *STBC_IOADDR_STBC_SRAM_REG_BASE;
void __iomem *STBC_IOADDR_CORE_REG_BASE;
void __iomem *STBC_IOADDR_CC_REG_BASE;

static struct semaphore otp_sem;
static spinlock_t v_otp_spin_locks;
static struct clk *stbc_clk;

static const UINT32 vSTBC_CODE[] = {
0x02A20902,
0xFEE4820D,
0x022222FF,
0xFEE4A40D,
0x022222FF,
0xFEE4950D,
0x022222FF,
0x007FB00D,
0x02222222,
0x207FDB0B,
0x12220912,
0x4DE51505,
0x02708054,
0x0912B161,
0xE54FF58A,
0xE54EF54E,
0xF57F544D,
0x4EADFC4D,
0x50AF4FAE,
0x00A30512,
0x000000A1,
0x00B60001,
0x00020000,
0x000000E3,
0x00230103,
0x03050000,
0x00000097,
0x00CB0006,
0x01070000,
0x000000D9,
0x00130208,
0x02090000,
0x00000040,
0x0049020A,
0x020B0000,
0x00000063,
0x0074020C,
0x030D0000,
0x00000093,
0x0300000E,
0x12247F97,
0x05122209,
0xCE041221,
0x6B8E6C8F,
0x698C6A8D,
0x0412D421,
0x8E6C8F7F,
0x8C6A8D6B,
0xAE54AF69,
0xAC52AD53,
0x758E6151,
0x877555AA,
0x00000001,
0x0BE50000,
0xFA600A45,
0xF50AF5E4,
0x1297610B,
0x09127F04,
0x75057034,
0x03800158,
0xF558F5E4,
0xF556F557,
0x12FFE455,
0x0A705E09,
0x126D0912,
0xC8929109,
0x7FE49761,
0x5E091201,
0x706D0912,
0x91091207,
0x9761C992,
0x92910912,
0x759761CA,
0x247FAAAA,
0x12220912,
0x05122105,
0x008901A3,
0x01880000,
0x0000008D,
0x0091018C,
0x018D0000,
0x00000095,
0x0099018E,
0x018F0000,
0x0000009D,
0x00A1019C,
0x019D0000,
0x000000A5,
0x00A9019E,
0x019F0000,
0x000000AD,
0x00B101A8,
0x01AA0000,
0x000000B5,
0x00B901B8,
0x01C80000,
0x000000BD,
0x010000D8,
0x8088AFC4,
0x808CAF32,
0x808DAF2E,
0x808EAF2A,
0x808FAF26,
0x809CAF22,
0x809DAF1E,
0x809EAF1A,
0x809FAF16,
0x80A8AF12,
0x80AAAF0E,
0x80B8AF0A,
0x80C8AF06,
0xE4D8AF02,
0x0480588F,
0x58F5FF74,
0x56F557F5,
0x588555F5,
0x760912AA,
0x61200912,
0xBBAA758E,
0x0912247F,
0xCE041222,
0x7FE4AA8F,
0x36091201,
0xAA752070,
0x888075AA,
0x30AA8085,
0x75E4F486,
0x0412036C,
0xCCAA75F8,
0xC8D2CDD2,
0xCAD2C9D2,
0xAA759761,
0x7F9761DD,
0x22091224,
0x12310A12,
0x8FE44809,
0x1208789C,
0x9D8F0D09,
0x786D0912,
0x57051210,
0x129E8FE4,
0x9F8F0B09,
0x09F508F5,
0x976188D2,
0x882088D2,
0x80976102,
0xCBAA75F9,
0x85450912,
0x8D85AA8C,
0xAA8E85AA,
0x12AA8F85,
0x09127609,
0xAE8E6120,
0xEE09AF08,
0x8FE09533,
0x126B8E6C,
0x8E611C09,
0x75CEAA75,
0x9D75FF9C,
0xFF9E75FF,
0xE4FF9F75,
0x09F508F5,
0x60290912,
0xF5FF7409,
0x1A09126C,
0x88D28E61,
0x70290912,
0x75FF740A,
0x0912FE6C,
0x128E611A,
0xAA754509,
0xE70812C0,
0x7EFFAA8F,
0x0912D380,
0xD2EC4038,
0x4509128A,
0x12C1AA75,
0xAA8FE708,
0xFD807EFF,
0xAA58ABFC,
0xA856A957,
0x0512D355,
0x740A4046,
0xFD6C75FF,
0x611A0912,
0xD288C28E,
0x4BF5E48A,
0xF5E44CF5,
0x1209F508,
0x9C8F5109,
0x78530912,
0x57051208,
0x09129D8F,
0x12107851,
0x9E8F5705,
0x78530912,
0x57051218,
0xAA759F8F,
0xAA9C85C2,
0x85AA9D85,
0x9F85AA9E,
0xE588D2AA,
0x60084509,
0xE54C05FA,
0x0502704C,
0x4504644B,
0x75B3704B,
0xF5E4C3AA,
0xF509F508,
0x759DF59C,
0x9FF5059E,
0x4BF588D2,
0x88D24CF5,
0x0912247F,
0x310A1222,
0xC2480912,
0x0D883088,
0x6C75FF74,
0x1A0912FC,
0x801B0B12,
0xE54C0513,
0x0502704C,
0xE894C34B,
0x80644BE5,
0xCE408394,
0x7F980912,
0x207DFE28,
0x0B12F07C,
0xD204801B,
0xE5A9D2AA,
0xE56CF550,
0xE56BF54F,
0xE56AF54E,
0xF57F544D,
0x12207F69,
0x0B122209,
0x4511E51B,
0xE42A6010,
0x11F510F5,
0xD2B1AA75,
0xDA0412AB,
0x548A0912,
0xD10812FD,
0x0912007F,
0x1B0B1222,
0xE5A60412,
0x12804450,
0x0412CD08,
0x450FE5EC,
0xE443600E,
0x0FF50EF5,
0x7FB2AA75,
0x237DFEB0,
0x0512F07C,
0x12AA8F15,
0x0412C908,
0xE4ABD2EC,
0x6C75AAF5,
0xF8041207,
0xD210AA75,
0xD2C8D2CD,
0x75CAD2C9,
0x041220AA,
0x5450E5BA,
0xCD0812FE,
0x75090512,
0x0DE550AA,
0x4E600C45,
0xF50CF5E4,
0xB3AA750D,
0x12DA0412,
0xF7548A09,
0x7FD10812,
0x22091200,
0xC21B0B12,
0xC2C9C2CA,
0xA60412C8,
0x7FC90812,
0x7D007EB0,
0x12F07C23,
0x04121B0B,
0x4450E5BA,
0xCD081201,
0xC2090512,
0x980912CD,
0x7DFE047F,
0x12F07C20,
0x7F221B0B,
0x7D007E24,
0x12F07C20,
0x548F310A,
0x528D538E,
0x287F518C,
0x207D007E,
0x0A12F07C,
0x8E588F31,
0x8C568D57,
0xB07F2255,
0x237D007E,
0x0A12F07C,
0x8E508F31,
0x8C4E8D4F,
0x907F224D,
0x237D007E,
0x0A12F07C,
0x8E508F31,
0x8C4E8D4F,
0x0A12224D,
0x8E588F31,
0x8C568D57,
0xFEFF2255,
0xF07C207D,
0x8F310A12,
0x8D4F8E50,
0x224D8C4E,
0x007EB07F,
0xF07C237D,
0x221B0B12,
0x6AF56BF5,
0x047F69F5,
0x7C207DFE,
0x1B0B12F0,
0x7E907F22,
0x7C237D00,
0x1B0B12F0,
0x310A1222,
0x4F8E508F,
0x4D8C4E8D,
0x310A1222,
0x538E548F,
0x518C528D,
0x0601BB22,
0x838A8289,
0x025022E0,
0xFEBB22E7,
0x8922E302,
0xE4838A82,
0x9FEB2293,
0x9EEAF0F5,
0x9DE9F042,
0x9CE8F042,
0xE822F045,
0xC3EC0F60,
0x13EDFC13,
0xFE13EEFD,
0xD8FF13EF,
0x60E822F1,
0x33C3EF0F,
0xFE33EEFF,
0xECFD33ED,
0xF1D8FC33,
0x08FCE622,
0xE608FDE6,
0xFFE608FE,
0x0701BB22,
0x838A8289,
0x50910702,
0x02F8E905,
0xFEBB7807,
0x02F8E905,
0xD022C207,
0xE482D083,
0x74127093,
0x0D709301,
0xF893A3A3,
0xF5930174,
0xE4838882,
0x93027473,
0x7412706C,
0x706D9303,
0x9304740C,
0x7406706E,
0x606F9305,
0xA3A3A3DD,
0x80A3A3A3,
0xF0F5E3CA,
0xB508E209,
0x6B606DF0,
0xF5E3F380,
0x08E609F0,
0x6060F0B5,
0x87F3805E,
0x08E609F0,
0x6054F0B5,
0x87F48052,
0x08E209F0,
0x6048F0B5,
0x88F48046,
0x87838C82,
0xA3E009F0,
0x6038F0B5,
0x88F48036,
0x87838C82,
0x93E409F0,
0x27F0B5A3,
0xF3802560,
0x838C8288,
0x09F0F5E3,
0xF0B5A3E0,
0x80146016,
0x8C8288F3,
0xF0F5E383,
0xA393E409,
0x6004F0B5,
0x02F28002,
0x85800807,
0x8E80E780,
0x3C80D280,
0x6C801580,
0x9B807E80,
0x8B80B580,
0x4F80A180,
0x3A807080,
0x89140702,
0xEC838A82,
0xF593E4FA,
0xC5C8A3F0,
0xC5CCC882,
0x93E4CC83,
0x82C5C8A3,
0x83C5CCC8,
0x70F0B5CC,
0xE1806E60,
0x838A8289,
0xF0F593E4,
0xB508E2A3,
0x5C605EF0,
0x8289F280,
0xF5E0838A,
0x08E6A3F0,
0x604DF0B5,
0x89F3804B,
0xE0838A82,
0xE2A3F0F5,
0x3CF0B508,
0xF3803A60,
0x838A8289,
0xF0F593E4,
0xB508E6A3,
0x28602AF0,
0x5380F280,
0x838A8289,
0x93E4FAEC,
0xC8A3F0F5,
0xCCC882C5,
0xE0CC83C5,
0x82C5C8A3,
0x83C5CCC8,
0x04F0B5CC,
0xE2800260,
0xF0B5FF7F,
0x40220F02,
0x22017F02,
0x838A8289,
0xF5E0FAEC,
0xC5C8A3F0,
0xC5CCC882,
0xA3E0CC83,
0xC882C5C8,
0xCC83C5CC,
0x60D5F0B5,
0x89E380D3,
0xEC838A82,
0xF0F5E0FA,
0x82C5C8A3,
0x83C5CCC8,
0xA393E4CC,
0xC882C5C8,
0xCC83C5CC,
0x60B1F0B5,
0x88E280AF,
0x0224EDF0,
0x500004B4,
0xEB82F5A3,
0x04B40224,
0x23995000,
0x23824523,
0x73560690,
0x82D083D0,
0x08F693E4,
0xF6930174,
0x93027408,
0x037408F6,
0x0474F693,
0x8582A873,
0x83D0F083,
0x071282D0,
0xA80712A8,
0x12A80712,
0x73E4A807,
0xC5A393E4,
0xC5F0C583,
0x82C5C883,
0xC5A3F0C8,
0xC5F0C583,
0x82C5C883,
0x83D022C8,
0x93E482D0,
0x017408F2,
0x7408F293,
0x08F29302,
0xF2930374,
0x0D730474,
0x3D3D000A,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x3D3D3D3D,
0x000A0D3D,
0x203D3D3D,
0x20202020,
0x4E202020,
0x5441564F,
0x4E204B45,
0x35383954,
0x38203833,
0x20313530,
0x2055434D,
0x6C756D45,
0x6F697461,
0x6554206E,
0x50207473,
0x72676F72,
0x20206D61,
0x20202020,
0x0D3D3D3D,
0x3028000A,
0x64202029,
0x73797268,
0x656E6F74,
0x28000A0D,
0x29435345,
0x74697845,
0x0D000A0D,
0x6F59200A,
0x43207275,
0x63696F68,
0x3E3E2065,
0x72686400,
0x6F747379,
0x7320656E,
0x74726174,
0x2E2E2E20,
0x65000A0D,
0x5400756D,
0x20736968,
0x38207369,
0x20313530,
0x0D55434D,
0x203E000A,
0x5450E500,
0xE550F57F,
0xE54FF54F,
0xE54EF54E,
0x854DF54D,
0x4F856C50,
0x6A4E856B,
0xE42269F5,
0xAFAA5885,
0xAD57AE58,
0x7855AC56,
0x57051208,
0xAFAA8FE4,
0xAD57AE58,
0x7855AC56,
0x57051210,
0x78AA8FE4,
0xAE58AF18,
0xAC56AD57,
0x57051255,
0x6BF522E4,
0x69F56AF5,
0x007E287F,
0xF07C207D,
0x7C0B1222,
0x578E588F,
0x558C568D,
0xC3FEFFE4,
0x58ABFCFD,
0x56A957AA,
0x050255A8,
0x7C0B1246,
0x578E588F,
0x558C568D,
0xEB4CAB22,
0xE025E025,
0x02F82324,
0xFDFE7D05,
0xAA54ABFC,
0xA852A953,
0x0502C351,
0xAE58AF46,
0xAC56AD57,
0x58852255,
0x6B57856C,
0x856A5685,
0xE4226955,
0x02FEFDFC,
0x50E56A05,
0x4FE550F5,
0x4E4DEC22,
0x22FF244F,
0xF56CF5E4,
0xF56AF56B,
0xFF782269,
0xFDD8F6E4,
0x75002075,
0x09026C81,
0xBA0A02EC,
0xF8A393E4,
0x40A393E4,
0x0180F603,
0xF4DF08F2,
0x93E42980,
0x0754F8A3,
0xC3C80C24,
0x0F54C433,
0x83C82044,
0x56F40440,
0xF6460180,
0x0B80E4DF,
0x08040201,
0x80402010,
0xE4A80C90,
0x6093017E,
0x54FFA3BC,
0x09E5303F,
0xE4FE1F54,
0x0160A393,
0xC054CF0E,
0xA860E025,
0x93E4B840,
0x93E4FAA3,
0x93E4F8A3,
0x82C5C8A3,
0x83C5CAC8,
0xC8A3F0CA,
0xCAC882C5,
0xDFCA83C5,
0x80E7DEE9,
0x8E5C8FBE,
0x8C5A8D5B,
0x2A0E1259,
0xE4FF5CE5,
0x0878C08F,
0x8F770C12,
0x121078C1,
0xC28F770C,
0x5BAE5CAF,
0x59AC5AAD,
0x05121878,
0xC38FE457,
0xB030B0F5,
0xE4C4AFFD,
0xEFFEFDFC,
0xF5EE60F5,
0xF55EF55F,
0x78C5AF5D,
0x9E0C1208,
0xE55FF54E,
0xE55EF55E,
0xAF5DF55D,
0x121078C6,
0x5FF59A0C,
0xF54D5EE5,
0xF55DE55E,
0x78C7AF5D,
0x9A0C1218,
0x5EE55FF5,
0x5DE55EF5,
0xE45DF54C,
0x0E12B0F5,
0xAE60AF27,
0xAC5EAD5F,
0xF5E4225D,
0xF549F54A,
0x1247F548,
0x0012270E,
0x7E087F1A,
0x180D1200,
0x087AFF7B,
0x0D12B379,
0xFFA875C3,
0x144A75E4,
0x48F549F5,
0xFF7B47F5,
0xC679087A,
0xF5C30D12,
0x004F754E,
0xFB475075,
0x3379007A,
0xAF490D12,
0xAD49AE4A,
0xEC47AC48,
0x604F4E4D,
0x7A007B09,
0x12337900,
0x0012D30C,
0x8FC18026,
0x8D678E68,
0x12658C66,
0x68E52A0E,
0xC08FE4FF,
0x0C120878,
0xC18FE484,
0x0C121078,
0xC28FE484,
0x67AE68AF,
0x65AC66AD,
0x05121878,
0xE5C38F57,
0x8FE4FF6C,
0x120878C4,
0x8FE48F0C,
0x121078C5,
0x8FE48F0C,
0xAE6CAFC6,
0xAC6AAD6B,
0x12187869,
0xC78F5705,
0x3010B075,
0xF5E4FDB0,
0x270E02B0,
0x8EAF89D2,
0x09121078,
0xC004C083,
0xC006C005,
0x788FAF07,
0x83091218,
0x02D003D0,
0x00D001D0,
0xEEFF4BEF,
0x49EDFE4A,
0xFC48ECFD,
0x05C004C0,
0x07C006C0,
0xFCE48DAF,
0x0878FEFD,
0xD06A0512,
0xD002D003,
0xEF00D001,
0x4AEEFB4B,
0xF949EDFA,
0xAFF848EC,
0xFF4BEF8C,
0xFDE9FEEA,
0xC022FCE8,
0xC0F0C0E0,
0xC082C083,
0x00D075D0,
0x01C000C0,
0x03C002C0,
0x05C004C0,
0x07C006C0,
0x75A4AA75,
0x6B75026C,
0x006A7500,
0x7F006975,
0x7D007E14,
0x12F07C21,
0x0A751B0B,
0x010B7500,
0x06D007D0,
0x04D005D0,
0x02D003D0,
0x00D001D0,
0x82D0D0D0,
0xF0D083D0,
0x7B32E0D0,
0x79077AFF,
0xBC0D12DB,
0x2479087A,
0x7ABC0D12,
0x126A7908,
0x087AC30D,
0x0D127B79,
0x79087AC3,
0xC30D1287,
0x007A007B,
0x0D124E79,
0x244EE5EB,
0x240F60E5,
0x7BC870EB,
0x79087AFF,
0xC30D1299,
0xAF22BD80,
0xAD5BAE5C,
0x1259AC5A,
0x22E45705,
0x67AE68AF,
0x65AC66AD,
0xAF570502,
0xAD6BAE6C,
0x0269AC6A,
0xFCE45705,
0x0512FEFD,
0xF560E56A,
0x225FE560,
0x00002102,
0x00002310,
0x0100E803,
0xF505A086,
0xD0B200E1,
0x0802005E,
0x10020000,
0x0E020000,
0x0C020000,
0x0A020000,
0x8B000000,
0x894C8A4B,
0x2D05124D,
0x15709B24,
0x4CAC4DA8,
0xFF7B4BAD,
0xAF79087A,
0xEF5B0712,
0x0C020670,
0x21001233,
0x3F0D1222,
0x0D120D40,
0xC3028035,
0xF4FCD833,
0x1222CB52,
0x0280350D,
0xFCD833C3,
0x22CA52F4,
0x403F0D12,
0x350D120C,
0x33C30280,
0xCB42FCD8,
0x350D1222,
0x33C30280,
0xCA42FCD8,
0xF824EF22,
0xA80174FF,
0xC3220807,
0xEE0894EF,
0x80948064,
0xAA4EAB22,
0x1250A94F,
0x00008905,
0xFFE40000,
0x22FCFDFE,
0x16AA15AB,
0x051217A9,
0x00000089,
0xFEFFE400,
0xAB22FCFD,
0xA91CAA1B,
0x8905121D,
0x00000000,
0xFDFEFFE4,
0xAA7522FC,
0xAA8885A0,
0x8AD288C2,
0x08758CD2,
0x01097500,
0x75AAC232,
0x0F75000E,
0xA2AA7501,
0x32AAA885,
0xAA75A9C2,
0x001075A1,
0x32011175,
0xAA75ABC2,
0x000C75A3,
0x32010D75,
0x7AC30D12,
0x22DE7907,
0x007A007B,
0x7B220079,
0x79007A00,
0x007B2200,
0x0079007A,
0xFEFFE422,
0xE422FCFD,
0xFCFDFEFF,
0xFEFFE422,
0xE422FCFD,
0xFCFDFEFF,
0xFEFFE422,
0xE422FCFD,
0xFCFDFEFF,
0xFEFFE422,
0xE422FCFD,
0xFCFDFEFF,
0xFEFFE422,
0xE422FCFD,
0xFCFDFEFF,
0xFEFFE422,
0xE422FCFD,
0xFCFDFEFF,
0x22007F22,
0xD222007F,
0xAFC222AF,
0x22222222,
0x22222222,


};


ER stbc_platform_sem_wait(void)
{
#if defined __UITRON || defined __ECOS
	return wai_sem(v_sem[0]);
#elif defined(__FREERTOS)
	return SEM_WAIT(*v_sem[0]);
#else
	down(&otp_sem);
	return E_OK;
#endif
}

ER stbc_platform_sem_signal(void)
{
#if defined __UITRON || defined __ECOS
	return sig_sem(v_sem[0]);
#elif defined(__FREERTOS)
	SEM_SIGNAL(*v_sem[0]);
	return E_OK;
#else
	up(&otp_sem);
	return E_OK;
#endif
}

void stbc_platform_clk_standby(void)
{
	struct clk *parent_clk;

	if (IS_ERR(stbc_clk))
	{
		printk("%s: stbc_clk NULL\r\n", __func__);
		return;
	}

	parent_clk = clk_get(NULL, "stbc_32k");
	clk_set_parent(stbc_clk, parent_clk);
	clk_put(parent_clk);
}

unsigned long stbc_platform_spin_lock(void)
{
#if defined __UITRON || defined __ECOS
	loc_cpu();
#elif defined(__FREERTOS)
	unsigned long flags;
	vk_spin_lock_irqsave(&v_otp_spin_locks, flags);
	return flags;
#else
	unsigned long flags;
	spin_lock_irqsave(&v_otp_spin_locks, flags);
	return flags;
#endif
}

void stbc_platform_spin_unlock(unsigned long flags)
{
#if defined __UITRON || defined __ECOS
	unl_cpu();
#elif defined(__FREERTOS)
	vk_spin_unlock_irqrestore(&v_otp_spin_locks, flags);
#else
	spin_unlock_irqrestore(&v_otp_spin_locks, flags);
#endif
}


void stbc_platform_delay_ms(UINT32 ms)
{
#if defined __UITRON || defined __ECOS
	Delay_DelayMs(ms);
#elif defined __FREERTOS
	vos_task_delay_ms(ms);
#else
	msleep(ms);
#endif
}
#if defined __FREERTOS
void stbc_platform_create_resource(void)
#else
void stbc_platform_create_resource(MODULE_INFO *pmodule_info)
#endif
{
#if defined __FREERTOS
	SEM_CREATE(SEMID_OTP, 1);
	v_sem[0] = &SEMID_OTP;
#else
	UINT32 reg;

	STBC_IOADDR_STBC_REG_BASE   = pmodule_info->io_addr[IOADDR_STBC_REG_BASE_ENUM];
	reg = readl(STBC_IOADDR_STBC_REG_BASE);
	reg &= ~(0x1);
	writel(reg, STBC_IOADDR_STBC_REG_BASE);

	if (!STBC_IOADDR_STBC_CG_REG_BASE) {
		STBC_IOADDR_STBC_CG_REG_BASE = ioremap(NVT_STBC_CG_BASE_PHYS, 0x100);
	}

	if (!STBC_IOADDR_CORE_REG_BASE) {
		STBC_IOADDR_CORE_REG_BASE = ioremap(CORE_REG_BASE_PHYS, 0x100);
	}

	if (!STBC_IOADDR_STBC_SRAM_REG_BASE) {
		STBC_IOADDR_STBC_SRAM_REG_BASE = ioremap(NVT_MCU_SRAM_BASE_PHYS, sizeof(vSTBC_CODE));
	}

	if (!IS_ERR(pmodule_info->pclk[0])) {
		int i;
		u32 *p_src;
		u32 *p_dst;

		stbc_clk = pmodule_info->pclk[0];
		clk_prepare_enable(stbc_clk);

		reg = readl(STBC_IOADDR_STBC_REG_BASE);
		printk("%s: STBC reg 0x%x\r\n", __func__, reg);

		p_src = (UINT32*)vSTBC_CODE;
		p_dst = (UINT32*)STBC_IOADDR_STBC_SRAM_REG_BASE;
		for (i=0; i<sizeof(vSTBC_CODE)/sizeof(vSTBC_CODE[0]); i++) {
			*p_dst++ = *p_src++;
		}
	} else {
		printk("%s: clk node not found\r\n", __func__);
	}

	sema_init(&otp_sem, 1);
	spin_lock_init(&v_otp_spin_locks);
#endif
}

void stbc_platform_release_resource(void)
{
#if defined __FREERTOS
	SEM_DESTROY(SEMID_OTP);
#endif
}
