#ifndef _DT_BINDINGS_GPIO_NVT_NA51090_H
#define _DT_BINDINGS_GPIO_NVT_NA51090_H

/* Reset or not during clk_prepare() */
#define DO_RESET        1
#define NOT_RESET       0

/* Enable or not during clock tree construction */
#define DO_ENABLE       1
#define NOT_ENABLE      0

/* Enable or not during clock tree construction */
#define DO_AUTOGATING   1
#define NOT_AUTOGATING  0

#define IOADDR_CG_REG_SIZE 0x12A0

#define DEFAULT_OSC_IN_CLK_FREQ 12000000
#define DEFAULT_PLL_DIV_VALUE   131072
#define DEFAULT_PLL0_RATIO    5461333  /* 0x535555 (500MHz for AXI0) */
#define DEFAULT_PLL2_RATIO    4369066  /* 0x42AAAA (400MHz for AXI1) */
#define DEFAULT_PLL3_RATIO    2184533  /* 0x215555 (200MHz for DRAM) */
#define DEFAULT_PLL4_RATIO    3276800  /* 0x320000 (300MHz for AHB) */
#define DEFAULT_PLL5_RATIO    1092266  /* 0x10AAAA (100MHz for SATA_PHY) */
#define DEFAULT_PLL6_RATIO    2184533  /* 0x215555 (200MHz for SDC) */
#define DEFAULT_PLL7_RATIO    2730666  /* 0x29AAAA (250MHz for MAC) */
#define DEFAULT_PLL8_RATIO    6553600  /* 0x640000 (600MHz for CNN) */
#define DEFAULT_PLL9_RATIO    3244032  /* 0x318000 (297MHz for DISPLAY0) */
#define DEFAULT_PLL10_RATIO   2730666  /* 0x29AAAA (250MHz for DISPALY1) */
#define DEFAULT_PLL11_RATIO    589824  /* 0x90000  (54MHz for DISPLAY2) */
#define DEFAULT_PLL12_RATIO   4026531  /* 0x3D70A3 (368.64MHz for SSP) */
#define DEFAULT_PLL13_RATIO   3822933  /* 0x3A5555 (350MHz for AXI2) */
#define DEFAULT_PLL14_RATIO   4150613  /* 0x3F5555 (380MHz for VENC) */
#define DEFAULT_PLL15_RATIO   5461333  /* 0x535555 (500MHz for IPP, Codec bakup) */
#define DEFAULT_PLL16_RATIO   1911466  /* 0x1D2AAA (175MHz for CPU) */
#define DEFAULT_PLL17_RATIO   2184533  /* 0x215555 (200MHz for DRAM2) */
#define DEFAULT_PLL18_RATIO   4915200  /* 0x4B0000 (450MHz for VDEC) */
#define DEFAULT_PLL19_RATIO   4915200  /* 0x4B0000 (450MHz for VCAP) */
#define DEFAULT_PLL20_RATIO   5461333  /* 0x535555 (500MHz for USB3_PHY) */

/* PLL */
#define CG_PLL_EN_REG_OFFSET                            0x00
#define CG_PLL_STAT_REG_OFFSET                          0x04

/* Clock source control */
#define CG_SYS_CLK_RATE_REG_OFFSET                      0x10
#define CG_IPP_CLK_RATE_REG0_OFFSET                     0x14
#define CG_IPP_CLK_RATE_REG1_OFFSET                   0x18
#define CG_CODEC_CLK_RATE_REG_OFFSET                    0x1C
#define CG_PERI_CLK_RATE_REG0_OFFSET                    0x20
#define CG_PERI_CLK_RATE_REG1_OFFSET                    0x24
#define CG_PERI_CLK_RATE_REG2_OFFSET                    0x28
#define CG_PERI_CLK_RATE_REG3_OFFSET                    0x2C

/* Clock rate control */
#define CG_IPP_CLK_DIV_REG0_OFFSET                      0x30
#define CG_PWM_CLK_DIV_REG0_OFFSET                      0x34
#define CG_PWM_CLK_DIV_REG1_OFFSET                      0x38
#define CG_DAI_MCLK_DIV_REG_OFFSET                      0x3C
#define CG_SDIO_CLK_DIV_REG_OFFSET                      0x40
#define CG_UART_CLK_DIV_REG_OFFSET                      0x44
#define CG_PERI_CLK_DIV_REG0_OFFSET                     0x48
#define CG_PERI_CLK_DIV_REG1_OFFSET                     0x4C
#define CG_PERI_CLK_DIV_REG2_OFFSET                     0x50
#define CG_PERI_CLK_DIV_REG3_OFFSET                     0x54
#define CG_DAI_CLK_DIV_REG0_OFFSET                      0x58
#define CG_DAI_CLK_DIV_REG1_OFFSET                      0x5C

/* Clock enable/disable control */
#define CG_CLK_EN_REG0_OFFSET                           0x70
#define CG_CLK_EN_REG1_OFFSET                           0x74
#define CG_CLK_EN_REG2_OFFSET                           0x78
#define CG_CLK_EN_REG3_OFFSET                           0x7C
#define CG_CLK_EN_REG4_OFFSET                           0x80

/* Module reset control */
#define CG_SYS_RESET_REG0_OFFSET                        0x90
#define CG_SYS_RESET_REG1_OFFSET                        0x94
#define CG_SYS_RESET_REG2_OFFSET                        0x98
#define CG_SYS_RESET_REG3_OFFSET                        0x9C
#define CG_SYS_RESET_REG4_OFFSET                        0xA0

/* Low power control */
#define CG_SLEEP_MODE_REG_OFFSET                        0xB0
#define CG_CLK_AUTO_GATING_REG0_OFFSET                  0xC0
#define CG_CLK_AUTO_GATING_REG1_OFFSET                  0xC4
#define CG_APB_CLK_AUTO_GATING_REG0_OFFSET              0xD0
#define CG_APB_CLK_AUTO_GATING_REG1_OFFSET              0xD4
#define CG_APB_CLK_AUTO_GATING_REG2_OFFSET              0xD8

/* Extclk source control */
#define CG_EXT_CLK_OUT_SRC_REG_OFFSET           0xF0

#define CG_PLL_MCU_FLAG_REG_OFFSET                      0x1180

/* PLL clock rate control */
#define CG_PLL0_CLK_BASE_REG_OFFSET                     0x4400
#define CG_PLL2_CLK_BASE_REG_OFFSET                     0x4480
#define CG_PLL3_CLK_BASE_REG_OFFSET                     0x44C0
#define CG_PLL4_CLK_BASE_REG_OFFSET                     0x4500
#define CG_PLL5_CLK_BASE_REG_OFFSET                     0x4540
#define CG_PLL6_CLK_BASE_REG_OFFSET                     0x4580
#define CG_PLL7_CLK_BASE_REG_OFFSET                     0x45C0
#define CG_PLL8_CLK_BASE_REG_OFFSET                     0x4600
#define CG_PLL9_CLK_BASE_REG_OFFSET                     0x4640
#define CG_PLL10_CLK_BASE_REG_OFFSET                    0x4680
#define CG_PLL11_CLK_BASE_REG_OFFSET                    0x46C0
#define CG_PLL12_CLK_BASE_REG_OFFSET                    0x4700
#define CG_PLL13_CLK_BASE_REG_OFFSET                    0x4740
#define CG_PLL14_CLK_BASE_REG_OFFSET                    0x4780
#define CG_PLL15_CLK_BASE_REG_OFFSET                    0x47C0
#define CG_PLL16_CLK_BASE_REG_OFFSET                    0x4800
#define CG_PLL17_CLK_BASE_REG_OFFSET                    0x4840
#define CG_PLL18_CLK_BASE_REG_OFFSET                    0x4880
#define CG_PLL19_CLK_BASE_REG_OFFSET                    0x48C0
#define CG_PLL20_CLK_BASE_REG_OFFSET                    0x4900

#define CG_PLL0_CLK_RATE0_REG_OFFSET                    0x4420
#define CG_PLL2_CLK_RATE0_REG_OFFSET                    0x44A0
#define CG_PLL3_CLK_RATE0_REG_OFFSET                    0x44E0
#define CG_PLL4_CLK_RATE0_REG_OFFSET                    0x4520
#define CG_PLL5_CLK_RATE0_REG_OFFSET                    0x4560
#define CG_PLL6_CLK_RATE0_REG_OFFSET                    0x45A0
#define CG_PLL7_CLK_RATE0_REG_OFFSET                    0x45E0
#define CG_PLL8_CLK_RATE0_REG_OFFSET                    0x4620
#define CG_PLL9_CLK_RATE0_REG_OFFSET                    0x4660
#define CG_PLL10_CLK_RATE0_REG_OFFSET                   0x46A0
#define CG_PLL11_CLK_RATE0_REG_OFFSET                   0x46E0
#define CG_PLL12_CLK_RATE0_REG_OFFSET                   0x4720
#define CG_PLL13_CLK_RATE0_REG_OFFSET                   0x4760
#define CG_PLL14_CLK_RATE0_REG_OFFSET                   0x47A0
#define CG_PLL15_CLK_RATE0_REG_OFFSET                   0x47E0
#define CG_PLL16_CLK_RATE0_REG_OFFSET                   0x4820
#define CG_PLL17_CLK_RATE0_REG_OFFSET                   0x4860
#define CG_PLL18_CLK_RATE0_REG_OFFSET                   0x48A0
#define CG_PLL19_CLK_RATE0_REG_OFFSET                   0x48E0
#define CG_PLL20_CLK_RATE0_REG_OFFSET                   0x4920

#define CG_PLL_SPREAD_SPECTRUM_REG0_OFFSET              0x0C
#define CG_PLL_SPREAD_SPECTRUM_REG1_OFFSET              0x10
#define CG_PLL_SPREAD_SPECTRUM_REG2_OFFSET              0x14
#define CG_PLL_SPREAD_SPECTRUM_REG3_OFFSET              0x1C

#endif /* _DT_BINDINGS_GPIO_NVT_NA51090_H */
